/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application;

import de.todesbaum.jsite.application.FileOption;
import de.todesbaum.util.mime.DefaultMIMETypes;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Project
implements Comparable<Project> {
    protected String name;
    protected String description;
    protected String insertURI;
    protected String requestURI;
    protected String indexFile;
    protected String localPath;
    protected String path;
    protected long lastInsertionTime;
    protected int edition;
    private boolean ignoreHiddenFiles;
    protected Map<String, FileOption> fileOptions = new HashMap<String, FileOption>();

    public Project() {
    }

    public Project(Project project) {
        this.name = project.name;
        this.description = project.description;
        this.insertURI = project.insertURI;
        this.requestURI = project.requestURI;
        this.path = project.path;
        this.edition = project.edition;
        this.localPath = project.localPath;
        this.indexFile = project.indexFile;
        this.lastInsertionTime = project.lastInsertionTime;
        this.ignoreHiddenFiles = project.ignoreHiddenFiles;
        this.fileOptions = new HashMap<String, FileOption>(project.fileOptions);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String string) {
        this.localPath = string;
    }

    public String getIndexFile() {
        return this.indexFile;
    }

    public void setIndexFile(String string) {
        this.indexFile = string;
    }

    public long getLastInsertionTime() {
        return this.lastInsertionTime;
    }

    public void setLastInsertionTime(long l) {
        this.lastInsertionTime = l;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getInsertURI() {
        return this.insertURI;
    }

    public void setInsertURI(String string) {
        this.insertURI = this.shortenURI(string);
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String string) {
        this.requestURI = this.shortenURI(string);
    }

    public boolean isIgnoreHiddenFiles() {
        return this.ignoreHiddenFiles;
    }

    public void setIgnoreHiddenFiles(boolean bl) {
        this.ignoreHiddenFiles = bl;
    }

    public String toString() {
        return this.name;
    }

    private String shortenURI(String string) {
        String string2 = string;
        if (string2.startsWith("freenet:")) {
            string2 = string2.substring("freenet:".length());
        }
        if (string2.startsWith("SSK@")) {
            string2 = string2.substring("SSK@".length());
        }
        if (string2.startsWith("USK@")) {
            string2 = string2.substring("USK@".length());
        }
        if (string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public String shortenFilename(File file) {
        String string = file.getPath();
        if (string.startsWith(this.localPath) && (string = string.substring(this.localPath.length())).startsWith(File.separator)) {
            string = string.substring(1);
        }
        return string;
    }

    public FileOption getFileOption(String string) {
        FileOption fileOption = this.fileOptions.get(string);
        if (fileOption == null) {
            fileOption = new FileOption(DefaultMIMETypes.guessMIMEType(string));
            this.fileOptions.put(string, fileOption);
        }
        return fileOption;
    }

    public void setFileOption(String string, FileOption fileOption) {
        if (fileOption != null) {
            this.fileOptions.put(string, fileOption);
        } else {
            this.fileOptions.remove(string);
        }
    }

    public Map<String, FileOption> getFileOptions() {
        return Collections.unmodifiableMap(this.fileOptions);
    }

    public void setFileOptions(Map<String, FileOption> map) {
        this.fileOptions.clear();
        this.fileOptions.putAll(map);
    }

    @Override
    public int compareTo(Project project) {
        return this.name.compareToIgnoreCase(project.name);
    }

    public int getEdition() {
        return this.edition;
    }

    public void setEdition(int n) {
        this.edition = n;
    }

    public String getFinalRequestURI(int n) {
        return "USK@" + this.requestURI + "/" + this.path + "/" + (this.edition + n) + "/";
    }

    public void onSuccessfulInsert() {
        for (Map.Entry<String, FileOption> entry : this.fileOptions.entrySet()) {
            FileOption fileOption = entry.getValue();
            if (fileOption.getCurrentHash() != null && fileOption.getCurrentHash().length() > 0 && (!fileOption.getCurrentHash().equals(fileOption.getLastInsertHash()) || fileOption.isForceInsert())) {
                fileOption.setLastInsertEdition(this.edition);
                fileOption.setLastInsertHash(fileOption.getCurrentHash());
                fileOption.setLastInsertFilename(fileOption.hasChangedName() ? fileOption.getChangedName() : entry.getKey());
            }
            fileOption.setForceInsert(false);
        }
    }
}

