/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.gui;

import de.todesbaum.jsite.application.Node;
import de.todesbaum.jsite.gui.NodeManagerListener;
import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import de.todesbaum.util.swing.TLabel;
import de.todesbaum.util.swing.TWizard;
import de.todesbaum.util.swing.TWizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class NodeManagerPage
extends TWizardPage
implements ListSelectionListener,
DocumentListener,
ChangeListener {
    private List<NodeManagerListener> nodeManagerListeners = new ArrayList<NodeManagerListener>();
    protected Action addNodeAction;
    protected Action deleteNodeAction;
    private DefaultListModel nodeListModel;
    private JList nodeList;
    private JTextField nodeNameTextField;
    private JTextField nodeHostnameTextField;
    private JSpinner nodePortSpinner;

    public NodeManagerPage(TWizard tWizard) {
        super(tWizard);
        this.pageInit();
        this.setHeading(I18n.getMessage("jsite.node-manager.heading"));
        this.setDescription(I18n.getMessage("jsite.node-manager.description"));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                NodeManagerPage.this.setHeading(I18n.getMessage("jsite.node-manager.heading"));
                NodeManagerPage.this.setDescription(I18n.getMessage("jsite.node-manager.description"));
            }
        });
    }

    public void addNodeManagerListener(NodeManagerListener nodeManagerListener) {
        this.nodeManagerListeners.add(nodeManagerListener);
    }

    public void removeNodeManagerListener(NodeManagerListener nodeManagerListener) {
        this.nodeManagerListeners.remove(nodeManagerListener);
    }

    protected void fireNodesUpdated(Node[] nodeArray) {
        for (NodeManagerListener nodeManagerListener : this.nodeManagerListeners) {
            nodeManagerListener.nodesUpdated(nodeArray);
        }
    }

    protected void fireNodeSelected(Node node) {
        for (NodeManagerListener nodeManagerListener : this.nodeManagerListeners) {
            nodeManagerListener.nodeSelected(node);
        }
    }

    private void createActions() {
        this.addNodeAction = new AbstractAction(I18n.getMessage("jsite.node-manager.add-node")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodeManagerPage.this.addNode();
            }
        };
        this.deleteNodeAction = new AbstractAction(I18n.getMessage("jsite.node-manager.delete-node")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodeManagerPage.this.deleteNode();
            }
        };
        this.deleteNodeAction.setEnabled(false);
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                NodeManagerPage.this.addNodeAction.putValue("Name", I18n.getMessage("jsite.node-manager.add-node"));
                NodeManagerPage.this.deleteNodeAction.putValue("Name", I18n.getMessage("jsite.node-manager.delete-node"));
            }
        });
    }

    private void pageInit() {
        this.createActions();
        this.nodeListModel = new DefaultListModel();
        this.nodeList = new JList(this.nodeListModel);
        this.nodeList.setName("node-list");
        this.nodeList.setSelectionMode(0);
        this.nodeList.addListSelectionListener(this);
        this.nodeList.setPreferredSize(new Dimension(250, -1));
        this.nodeNameTextField = new JTextField("");
        this.nodeNameTextField.getDocument().putProperty("Name", "node-name");
        this.nodeNameTextField.getDocument().addDocumentListener(this);
        this.nodeNameTextField.setEnabled(false);
        this.nodeHostnameTextField = new JTextField("localhost");
        this.nodeHostnameTextField.getDocument().putProperty("Name", "node-hostname");
        this.nodeHostnameTextField.getDocument().addDocumentListener(this);
        this.nodeHostnameTextField.setEnabled(false);
        this.nodePortSpinner = new JSpinner(new SpinnerNumberModel(9481, 1, 65535, 1));
        this.nodePortSpinner.setName("node-port");
        this.nodePortSpinner.addChangeListener(this);
        this.nodePortSpinner.setEnabled(false);
        JPanel jPanel = new JPanel(new FlowLayout(3, 12, 12));
        jPanel.setBorder(new EmptyBorder(-12, -12, -12, -12));
        jPanel.add(new JButton(this.addNodeAction));
        jPanel.add(new JButton(this.deleteNodeAction));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel3, "First");
        jPanel3.add((Component)jPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        final JLabel jLabel = new JLabel("<html><b>" + I18n.getMessage("jsite.node-manager.node-information") + "</b></html>");
        jPanel3.add((Component)jLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 21, 2, new Insets(6, 0, 0, 0), 0, 0));
        final TLabel tLabel = new TLabel(I18n.getMessage("jsite.node-manager.name") + ":", 78, (Component)this.nodeNameTextField);
        jPanel3.add((Component)tLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel3.add((Component)this.nodeNameTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        final TLabel tLabel2 = new TLabel(I18n.getMessage("jsite.node-manager.hostname") + ":", 72, (Component)this.nodeHostnameTextField);
        jPanel3.add((Component)tLabel2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel3.add((Component)this.nodeHostnameTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        final TLabel tLabel3 = new TLabel(I18n.getMessage("jsite.node-manager.port") + ":", 80, (Component)this.nodePortSpinner);
        jPanel3.add((Component)tLabel3, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel3.add((Component)this.nodePortSpinner, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)new JScrollPane(this.nodeList), "Before");
        this.add((Component)jPanel2, "Center");
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                jLabel.setText("<html><b>" + I18n.getMessage("jsite.node-manager.node-information") + "</b></html>");
                tLabel.setText(I18n.getMessage("jsite.node-manager.name") + ":");
                tLabel2.setText(I18n.getMessage("jsite.node-manager.hostname") + ":");
                tLabel3.setText(I18n.getMessage("jsite.node-manager.port") + ":");
            }
        });
    }

    @Override
    public void pageAdded(TWizard tWizard) {
        this.wizard.setNextEnabled(this.nodeListModel.getSize() > 0);
        this.wizard.setPreviousName(I18n.getMessage("jsite.wizard.previous"));
        this.wizard.setNextName(I18n.getMessage("jsite.wizard.next"));
        this.wizard.setQuitName(I18n.getMessage("jsite.wizard.quit"));
    }

    public void setNodes(Node[] nodeArray) {
        this.nodeListModel.clear();
        for (Node node : nodeArray) {
            this.nodeListModel.addElement(node);
        }
        this.nodeList.repaint();
        this.fireNodesUpdated(nodeArray);
    }

    public Node[] getNodes() {
        Node[] nodeArray = new Node[this.nodeListModel.getSize()];
        int n = this.nodeListModel.getSize();
        for (int i = 0; i < n; ++i) {
            nodeArray[i] = (Node)this.nodeListModel.get(i);
        }
        return nodeArray;
    }

    private Node getSelectedNode() {
        return (Node)this.nodeList.getSelectedValue();
    }

    private void updateTextField(DocumentEvent documentEvent) {
        Node node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Document document = documentEvent.getDocument();
        String string = null;
        try {
            string = document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (string == null) {
            return;
        }
        String string2 = (String)document.getProperty("Name");
        if ("node-name".equals(string2)) {
            node.setName(string);
            this.nodeList.repaint();
            this.fireNodesUpdated(this.getNodes());
        } else if ("node-hostname".equals(string2)) {
            node.setHostname(string);
            this.nodeList.repaint();
            this.fireNodesUpdated(this.getNodes());
        }
    }

    private void addNode() {
        Node node = new Node("localhost", 9481, I18n.getMessage("jsite.node-manager.new-node"));
        this.nodeListModel.addElement(node);
        this.deleteNodeAction.setEnabled(this.nodeListModel.size() > 1);
        this.wizard.setNextEnabled(true);
        this.fireNodesUpdated(this.getNodes());
    }

    private void deleteNode() {
        Node node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this.wizard, I18n.getMessage("jsite.node-manager.delete-node.warning"), null, 2, 2) == 2) {
            return;
        }
        int n = this.nodeListModel.indexOf(node);
        this.nodeListModel.removeElement(node);
        this.nodeList.repaint();
        this.fireNodeSelected((Node)this.nodeListModel.get(Math.min(n, this.nodeListModel.size() - 1)));
        this.fireNodesUpdated(this.getNodes());
        this.deleteNodeAction.setEnabled(this.nodeListModel.size() > 1);
        this.wizard.setNextEnabled(this.nodeListModel.size() > 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList;
        Object object = listSelectionEvent.getSource();
        if (object instanceof JList && "node-list".equals((jList = (JList)object).getName())) {
            Node node = (Node)jList.getSelectedValue();
            boolean bl = node != null;
            this.nodeNameTextField.setEnabled(bl);
            this.nodeHostnameTextField.setEnabled(bl);
            this.nodePortSpinner.setEnabled(bl);
            this.deleteNodeAction.setEnabled(bl && this.nodeListModel.size() > 1);
            if (bl) {
                this.nodeNameTextField.setText(node.getName());
                this.nodeHostnameTextField.setText(node.getHostname());
                this.nodePortSpinner.setValue(node.getPort());
            } else {
                this.nodeNameTextField.setText("");
                this.nodeHostnameTextField.setText("localhost");
                this.nodePortSpinner.setValue(9481);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateTextField(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateTextField(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateTextField(documentEvent);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JSpinner jSpinner;
        Object object = changeEvent.getSource();
        Node node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        if (object instanceof JSpinner && "node-port".equals((jSpinner = (JSpinner)object).getName())) {
            node.setPort((Integer)jSpinner.getValue());
            this.fireNodeSelected(node);
            this.nodeList.repaint();
        }
    }
}

