/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.gui;

import de.todesbaum.jsite.application.FileOption;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.gui.FileScanner;
import de.todesbaum.jsite.gui.FileScannerListener;
import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import de.todesbaum.util.mime.DefaultMIMETypes;
import de.todesbaum.util.swing.TLabel;
import de.todesbaum.util.swing.TWizard;
import de.todesbaum.util.swing.TWizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ProjectFilesPage
extends TWizardPage
implements ActionListener,
ListSelectionListener,
DocumentListener,
FileScannerListener {
    private Project project;
    private Action scanAction;
    private JCheckBox ignoreHiddenFilesCheckBox;
    private JList projectFileList;
    private JCheckBox defaultFileCheckBox;
    private JCheckBox fileOptionsInsertCheckBox;
    private JCheckBox fileOptionsForceInsertCheckBox;
    private JCheckBox fileOptionsInsertRedirectCheckBox;
    private JTextField fileOptionsCustomKeyTextField;
    private JCheckBox fileOptionsRenameCheckBox;
    private JTextField fileOptionsRenameTextField;
    private JComboBox fileOptionsMIMETypeComboBox;

    public ProjectFilesPage(TWizard tWizard) {
        super(tWizard);
        this.pageInit();
    }

    private void pageInit() {
        this.createActions();
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)this.createProjectFilesPanel(), "Center");
    }

    private void createActions() {
        this.scanAction = new AbstractAction(I18n.getMessage("jsite.project-files.action.rescan")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFilesPage.this.actionScan();
            }
        };
        this.scanAction.putValue("MnemonicKey", 83);
        this.scanAction.putValue("ShortDescription", I18n.getMessage("jsite.project-files.action.rescan.tooltip"));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                ProjectFilesPage.this.scanAction.putValue("Name", I18n.getMessage("jsite.project-files.action.rescan"));
                ProjectFilesPage.this.scanAction.putValue("ShortDescription", I18n.getMessage("jsite.project-files.action.rescan.tooltip"));
            }
        });
    }

    @Override
    public void pageAdded(TWizard tWizard) {
        this.actionScan();
        this.wizard.setPreviousName(I18n.getMessage("jsite.wizard.previous"));
        this.wizard.setNextName(I18n.getMessage("jsite.project-files.insert-now"));
        this.wizard.setQuitName(I18n.getMessage("jsite.wizard.quit"));
    }

    private JComponent createProjectFilesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        this.projectFileList = new JList();
        this.projectFileList.setSelectionMode(0);
        this.projectFileList.setMinimumSize(new Dimension(250, this.projectFileList.getPreferredSize().height));
        this.projectFileList.addListSelectionListener(this);
        jPanel.add((Component)new JScrollPane(this.projectFileList), "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(12, 12));
        jPanel.add((Component)jPanel2, "Last");
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel3, "First");
        this.ignoreHiddenFilesCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.ignore-hidden-files"));
        this.ignoreHiddenFilesCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.ignore-hidden-files.tooltip"));
        this.ignoreHiddenFilesCheckBox.setName("ignore-hidden-files");
        this.ignoreHiddenFilesCheckBox.addActionListener(this);
        jPanel3.add((Component)this.ignoreHiddenFilesCheckBox, new GridBagConstraints(0, 0, 5, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel3.add((Component)new JButton(this.scanAction), new GridBagConstraints(0, 1, 5, 1, 1.0, 0.0, 21, 0, new Insets(6, 0, 0, 0), 0, 0));
        final JLabel jLabel = new JLabel("<html><b>" + I18n.getMessage("jsite.project-files.file-options") + "</b></html>");
        jPanel3.add((Component)jLabel, new GridBagConstraints(0, 2, 5, 1, 1.0, 0.0, 21, 0, new Insets(6, 0, 0, 0), 0, 0));
        this.defaultFileCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.default"));
        this.defaultFileCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.default.tooltip"));
        this.defaultFileCheckBox.setName("default-file");
        this.defaultFileCheckBox.addActionListener(this);
        this.defaultFileCheckBox.setEnabled(false);
        jPanel3.add((Component)this.defaultFileCheckBox, new GridBagConstraints(0, 3, 5, 1, 0.0, 0.0, 21, 2, new Insets(6, 18, 0, 0), 0, 0));
        this.fileOptionsInsertCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.insert"), true);
        this.fileOptionsInsertCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.insert.tooltip"));
        this.fileOptionsInsertCheckBox.setName("insert");
        this.fileOptionsInsertCheckBox.setMnemonic(73);
        this.fileOptionsInsertCheckBox.addActionListener(this);
        this.fileOptionsInsertCheckBox.setEnabled(false);
        jPanel3.add((Component)this.fileOptionsInsertCheckBox, new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.fileOptionsForceInsertCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.force-insert"));
        this.fileOptionsForceInsertCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.force-insert.tooltip"));
        this.fileOptionsForceInsertCheckBox.setName("force-insert");
        this.fileOptionsForceInsertCheckBox.setMnemonic(70);
        this.fileOptionsForceInsertCheckBox.addActionListener(this);
        this.fileOptionsForceInsertCheckBox.setEnabled(false);
        jPanel3.add((Component)this.fileOptionsForceInsertCheckBox, new GridBagConstraints(0, 5, 5, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.fileOptionsCustomKeyTextField = new JTextField(45);
        this.fileOptionsCustomKeyTextField.setToolTipText(I18n.getMessage("jsite.project-files.custom-key.tooltip"));
        this.fileOptionsCustomKeyTextField.setEnabled(false);
        this.fileOptionsCustomKeyTextField.getDocument().addDocumentListener(this);
        this.fileOptionsInsertRedirectCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.insert-redirect"), false);
        this.fileOptionsInsertRedirectCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.insert-redirect.tooltip"));
        this.fileOptionsInsertRedirectCheckBox.setName("insert-redirect");
        this.fileOptionsInsertRedirectCheckBox.setMnemonic(82);
        this.fileOptionsInsertRedirectCheckBox.addActionListener(this);
        this.fileOptionsInsertRedirectCheckBox.setEnabled(false);
        final TLabel tLabel = new TLabel(I18n.getMessage("jsite.project-files.custom-key") + ":", 75, (Component)this.fileOptionsCustomKeyTextField);
        jPanel3.add((Component)this.fileOptionsInsertRedirectCheckBox, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel3.add((Component)tLabel, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 6, 0, 0), 0, 0));
        jPanel3.add((Component)this.fileOptionsCustomKeyTextField, new GridBagConstraints(2, 6, 3, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.fileOptionsRenameCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.rename"), false);
        this.fileOptionsRenameCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.rename.tooltip"));
        this.fileOptionsRenameCheckBox.setName("rename");
        this.fileOptionsRenameCheckBox.setMnemonic(78);
        this.fileOptionsRenameCheckBox.addActionListener(this);
        this.fileOptionsRenameCheckBox.setEnabled(false);
        this.fileOptionsRenameTextField = new JTextField();
        this.fileOptionsRenameTextField.setEnabled(false);
        this.fileOptionsRenameTextField.getDocument().addDocumentListener(new DocumentListener(){

            private void storeText(DocumentEvent documentEvent) {
                FileOption fileOption = ProjectFilesPage.this.getSelectedFile();
                if (fileOption == null) {
                    return;
                }
                Document document = documentEvent.getDocument();
                int n = document.getLength();
                try {
                    fileOption.setChangedName(document.getText(0, n).trim());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.storeText(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.storeText(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.storeText(documentEvent);
            }
        });
        jPanel3.add((Component)this.fileOptionsRenameCheckBox, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel3.add((Component)this.fileOptionsRenameTextField, new GridBagConstraints(2, 7, 3, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.fileOptionsMIMETypeComboBox = new JComboBox<String>(DefaultMIMETypes.getAllMIMETypes());
        this.fileOptionsMIMETypeComboBox.setToolTipText(I18n.getMessage("jsite.project-files.mime-type.tooltip"));
        this.fileOptionsMIMETypeComboBox.setName("project-files.mime-type");
        this.fileOptionsMIMETypeComboBox.addActionListener(this);
        this.fileOptionsMIMETypeComboBox.setEditable(true);
        this.fileOptionsMIMETypeComboBox.setEnabled(false);
        final TLabel tLabel2 = new TLabel(I18n.getMessage("jsite.project-files.mime-type") + ":", 77, (Component)this.fileOptionsMIMETypeComboBox);
        jPanel3.add((Component)tLabel2, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel3.add((Component)this.fileOptionsMIMETypeComboBox, new GridBagConstraints(1, 8, 4, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                ProjectFilesPage.this.ignoreHiddenFilesCheckBox.setText(I18n.getMessage("jsite.project-files.ignore-hidden-files"));
                ProjectFilesPage.this.ignoreHiddenFilesCheckBox.setToolTipText(I18n.getMessage("jsite.projet-files.ignore-hidden-files.tooltip"));
                jLabel.setText("<html><b>" + I18n.getMessage("jsite.project-files.file-options") + "</b></html>");
                ProjectFilesPage.this.defaultFileCheckBox.setText(I18n.getMessage("jsite.project-files.default"));
                ProjectFilesPage.this.defaultFileCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.default.tooltip"));
                ProjectFilesPage.this.fileOptionsInsertCheckBox.setText(I18n.getMessage("jsite.project-files.insert"));
                ProjectFilesPage.this.fileOptionsInsertCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.insert.tooltip"));
                ProjectFilesPage.this.fileOptionsForceInsertCheckBox.setText(I18n.getMessage("jsite.project-files.force-insert"));
                ProjectFilesPage.this.fileOptionsForceInsertCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.force-insert.tooltip"));
                ProjectFilesPage.this.fileOptionsInsertRedirectCheckBox.setText(I18n.getMessage("jsite.project-files.insert-redirect"));
                ProjectFilesPage.this.fileOptionsInsertRedirectCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.insert-redirect.tooltip"));
                ProjectFilesPage.this.fileOptionsCustomKeyTextField.setToolTipText(I18n.getMessage("jsite.project-files.custom-key.tooltip"));
                tLabel.setText(I18n.getMessage("jsite.project-files.custom-key") + ":");
                ProjectFilesPage.this.fileOptionsRenameCheckBox.setText("jsite.project-files.rename");
                ProjectFilesPage.this.fileOptionsRenameCheckBox.setToolTipText("jsite.project-files.rename.tooltip");
                ProjectFilesPage.this.fileOptionsMIMETypeComboBox.setToolTipText(I18n.getMessage("jsite.project-files.mime-type.tooltip"));
                tLabel2.setText(I18n.getMessage("jsite.project-files.mime-type") + ":");
            }
        });
        return jPanel;
    }

    public void setProject(final Project project) {
        this.project = project;
        this.setHeading(MessageFormat.format(I18n.getMessage("jsite.project-files.heading"), project.getName()));
        this.setDescription(I18n.getMessage("jsite.project-files.description"));
        this.ignoreHiddenFilesCheckBox.setSelected(project.isIgnoreHiddenFiles());
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                ProjectFilesPage.this.setHeading(MessageFormat.format(I18n.getMessage("jsite.project-files.heading"), project.getName()));
                ProjectFilesPage.this.setDescription(I18n.getMessage("jsite.project-files.description"));
            }
        });
    }

    private void actionScan() {
        this.projectFileList.clearSelection();
        this.projectFileList.setListData(new Object[0]);
        this.wizard.setNextEnabled(false);
        this.wizard.setPreviousEnabled(false);
        this.wizard.setQuitEnabled(false);
        FileScanner fileScanner = new FileScanner(this.project);
        fileScanner.addFileScannerListener(this);
        new Thread(fileScanner).start();
    }

    @Override
    public void fileScannerFinished(FileScanner fileScanner) {
        final boolean bl = fileScanner.isError();
        if (!bl) {
            final List<FileScanner.ScannedFile> list = fileScanner.getFiles();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectFilesPage.this.projectFileList.setListData(list.toArray());
                    ProjectFilesPage.this.projectFileList.clearSelection();
                }
            });
            HashSet<String> hashSet = new HashSet<String>();
            for (String object : new HashSet<String>(this.project.getFileOptions().keySet())) {
                boolean bl2 = false;
                for (FileScanner.ScannedFile scannedFile : list) {
                    if (!scannedFile.getFilename().equals(object)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                hashSet.add(object);
            }
            for (String string : hashSet) {
                this.project.setFileOption(string, null);
            }
        } else {
            JOptionPane.showMessageDialog(this.wizard, I18n.getMessage("jsite.project-files.scan-error"), null, 0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectFilesPage.this.wizard.setPreviousEnabled(true);
                ProjectFilesPage.this.wizard.setNextEnabled(!bl);
                ProjectFilesPage.this.wizard.setQuitEnabled(true);
            }
        });
    }

    private FileOption getSelectedFile() {
        FileScanner.ScannedFile scannedFile = (FileScanner.ScannedFile)this.projectFileList.getSelectedValue();
        if (scannedFile == null) {
            return null;
        }
        return this.project.getFileOption(scannedFile.getFilename());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox;
        Object object = actionEvent.getSource();
        if (object instanceof JCheckBox && "ignore-hidden-files".equals(((JCheckBox)object).getName())) {
            this.project.setIgnoreHiddenFiles(((JCheckBox)object).isSelected());
            this.actionScan();
            return;
        }
        FileScanner.ScannedFile scannedFile = (FileScanner.ScannedFile)this.projectFileList.getSelectedValue();
        if (scannedFile == null) {
            return;
        }
        String string = scannedFile.getFilename();
        FileOption fileOption = this.project.getFileOption(string);
        if (object instanceof JCheckBox) {
            JCheckBox jCheckBox = (JCheckBox)object;
            if ("default-file".equals(jCheckBox.getName())) {
                if (jCheckBox.isSelected()) {
                    if (string.indexOf(47) > -1) {
                        JOptionPane.showMessageDialog(this.wizard, I18n.getMessage("jsite.project-files.invalid-default-file"), null, 0);
                        jCheckBox.setSelected(false);
                    } else {
                        this.project.setIndexFile(string);
                    }
                } else if (string.equals(this.project.getIndexFile())) {
                    this.project.setIndexFile(null);
                }
            } else if ("insert".equals(jCheckBox.getName())) {
                boolean bl = jCheckBox.isSelected();
                fileOption.setInsert(bl);
                this.fileOptionsInsertRedirectCheckBox.setEnabled(!bl);
            } else if ("force-insert".equals(jCheckBox.getName())) {
                boolean bl = jCheckBox.isSelected();
                fileOption.setForceInsert(bl);
            } else if ("insert-redirect".equals(jCheckBox.getName())) {
                boolean bl = jCheckBox.isSelected();
                fileOption.setInsertRedirect(bl);
                this.fileOptionsCustomKeyTextField.setEnabled(bl);
            } else if ("rename".equals(jCheckBox.getName())) {
                boolean bl = jCheckBox.isSelected();
                this.fileOptionsRenameTextField.setEnabled(bl);
                fileOption.setChangedName(bl ? this.fileOptionsRenameTextField.getText() : "");
            }
        } else if (object instanceof JComboBox && "project-files.mime-type".equals((jComboBox = (JComboBox)object).getName())) {
            fileOption.setMimeType((String)jComboBox.getSelectedItem());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        FileScanner.ScannedFile scannedFile = (FileScanner.ScannedFile)this.projectFileList.getSelectedValue();
        boolean bl = scannedFile != null;
        String string = scannedFile == null ? null : scannedFile.getFilename();
        this.defaultFileCheckBox.setEnabled(bl);
        this.fileOptionsInsertCheckBox.setEnabled(bl);
        this.fileOptionsRenameCheckBox.setEnabled(bl);
        this.fileOptionsMIMETypeComboBox.setEnabled(bl);
        if (string != null) {
            FileOption fileOption = this.project.getFileOption(string);
            this.defaultFileCheckBox.setSelected(string.equals(this.project.getIndexFile()));
            this.fileOptionsInsertCheckBox.setSelected(fileOption.isInsert());
            this.fileOptionsForceInsertCheckBox.setEnabled(scannedFile.getHash().equals(fileOption.getLastInsertHash()));
            this.fileOptionsForceInsertCheckBox.setSelected(fileOption.isForceInsert());
            this.fileOptionsInsertRedirectCheckBox.setEnabled(!fileOption.isInsert());
            this.fileOptionsInsertRedirectCheckBox.setSelected(fileOption.isInsertRedirect());
            this.fileOptionsCustomKeyTextField.setEnabled(fileOption.isInsertRedirect());
            this.fileOptionsCustomKeyTextField.setText(fileOption.getCustomKey());
            this.fileOptionsRenameCheckBox.setSelected(fileOption.hasChangedName());
            this.fileOptionsRenameTextField.setEnabled(fileOption.hasChangedName());
            this.fileOptionsRenameTextField.setText(fileOption.getChangedName());
            this.fileOptionsMIMETypeComboBox.getModel().setSelectedItem(fileOption.getMimeType());
        } else {
            this.defaultFileCheckBox.setSelected(false);
            this.fileOptionsInsertCheckBox.setSelected(true);
            this.fileOptionsForceInsertCheckBox.setEnabled(false);
            this.fileOptionsForceInsertCheckBox.setSelected(false);
            this.fileOptionsInsertRedirectCheckBox.setEnabled(false);
            this.fileOptionsInsertRedirectCheckBox.setSelected(false);
            this.fileOptionsCustomKeyTextField.setEnabled(false);
            this.fileOptionsCustomKeyTextField.setText("CHK@");
            this.fileOptionsRenameCheckBox.setEnabled(false);
            this.fileOptionsRenameCheckBox.setSelected(false);
            this.fileOptionsRenameTextField.setEnabled(false);
            this.fileOptionsRenameTextField.setText("");
            this.fileOptionsMIMETypeComboBox.getModel().setSelectedItem("application/octet-stream");
        }
    }

    private void processDocumentUpdate(DocumentEvent documentEvent) {
        FileScanner.ScannedFile scannedFile = (FileScanner.ScannedFile)this.projectFileList.getSelectedValue();
        if (scannedFile == null) {
            return;
        }
        FileOption fileOption = this.project.getFileOption(scannedFile.getFilename());
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            fileOption.setCustomKey(string);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.processDocumentUpdate(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.processDocumentUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.processDocumentUpdate(documentEvent);
    }
}

