/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.main;

import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.InsertListener;
import de.todesbaum.jsite.application.Node;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.application.ProjectInserter;
import de.todesbaum.jsite.main.Configuration;
import de.todesbaum.jsite.main.ConfigurationLocator;
import de.todesbaum.util.io.StreamCopier;
import java.io.PrintWriter;

public class CLI
implements InsertListener {
    private Object lockObject = new Object();
    private PrintWriter outputWriter = new PrintWriter(System.out, true);
    private Freenet7Interface freenetInterface;
    private ProjectInserter projectInserter = new ProjectInserter();
    private Node[] nodes;
    private Project[] projects;
    private boolean finished = false;
    private boolean success;

    /*
     * WARNING - void declaration
     */
    private CLI(String[] stringArray) {
        void var6_10;
        if (stringArray.length == 0 || stringArray[0].equals("-h") || stringArray[0].equals("--help")) {
            this.outputWriter.println("\nParameters:\n");
            this.outputWriter.println("  --config-file=<configuration file>");
            this.outputWriter.println("  --node=<node name>");
            this.outputWriter.println("  --project=<project name>");
            this.outputWriter.println("  --local-directory=<local directory>");
            this.outputWriter.println("  --path=<path>");
            this.outputWriter.println("  --edition=<edition>");
            this.outputWriter.println("\nA project gets inserted when a new project is loaded on the command line,");
            this.outputWriter.println("or when the command line is finished. --local-directory, --path, and --edition");
            this.outputWriter.println("override the parameters in the project.");
            return;
        }
        String string = System.getProperty("user.home") + "/.jSite/config7";
        for (String object2 : stringArray) {
            String[] stringArray2 = object2.substring(object2.indexOf(61) + 1).trim();
            if (!object2.startsWith("--config-file=")) continue;
            string = stringArray2;
        }
        ConfigurationLocator configurationLocator = new ConfigurationLocator();
        if (string != null) {
            configurationLocator.setCustomLocation(string);
        }
        Configuration configuration = new Configuration(configurationLocator, configurationLocator.findPreferredLocation());
        this.projectInserter.addInsertListener(this);
        this.projects = configuration.getProjects();
        Node node = configuration.getSelectedNode();
        this.nodes = configuration.getNodes();
        this.freenetInterface = new Freenet7Interface();
        this.freenetInterface.setNode(node);
        this.projectInserter.setFreenetInterface(this.freenetInterface);
        Object var6_9 = null;
        for (String string2 : stringArray) {
            if (string2.startsWith("--config-file=")) continue;
            String string3 = string2.substring(string2.indexOf(61) + 1).trim();
            if (string2.startsWith("--node=")) {
                Node node2 = this.getNode(string3);
                if (node2 == null) {
                    this.outputWriter.println("Node \"" + string3 + "\" not found.");
                    return;
                }
                node = node2;
                this.freenetInterface.setNode(node);
                continue;
            }
            if (string2.startsWith("--project=")) {
                Project project;
                if (var6_10 != null) {
                    if (this.insertProject((Project)var6_10)) {
                        this.outputWriter.println("Project \"" + var6_10.getName() + "\" successfully inserted.");
                    } else {
                        this.outputWriter.println("Project \"" + var6_10.getName() + "\" was not successfully inserted.");
                    }
                    Object var6_11 = null;
                }
                if ((project = this.getProject(string3)) != null) continue;
                this.outputWriter.println("Project \"" + string3 + "\" not found.");
                continue;
            }
            if (string2.startsWith("--local-directory")) {
                if (var6_10 == null) {
                    this.outputWriter.println("You can't specifiy --local-directory before --project.");
                    return;
                }
                var6_10.setLocalPath(string3);
                continue;
            }
            if (string2.startsWith("--path=")) {
                if (var6_10 == null) {
                    this.outputWriter.println("You can't specify --path before --project.");
                    return;
                }
                var6_10.setPath(string3);
                continue;
            }
            if (string2.startsWith("--edition=")) {
                if (var6_10 == null) {
                    this.outputWriter.println("You can't specify --edition before --project.");
                    return;
                }
                var6_10.setEdition(Integer.parseInt(string3));
                continue;
            }
            this.outputWriter.println("Unknown parameter: " + string2);
            return;
        }
        int n = 1;
        if (var6_10 != null) {
            if (this.insertProject((Project)var6_10)) {
                this.outputWriter.println("Project \"" + var6_10.getName() + "\" successfully inserted.");
                n = 0;
            } else {
                this.outputWriter.println("Project \"" + var6_10.getName() + "\" was not successfully inserted.");
            }
        }
        configuration.setProjects(this.projects);
        configuration.save();
        System.exit(n);
    }

    private Project getProject(String string) {
        for (Project project : this.projects) {
            if (!project.getName().equals(string)) continue;
            return project;
        }
        return null;
    }

    private Node getNode(String string) {
        for (Node node : this.nodes) {
            if (!node.getName().equals(string)) continue;
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertProject(Project project) {
        if (!this.freenetInterface.hasNode()) {
            this.outputWriter.println("Node is not running!");
            return false;
        }
        this.projectInserter.setProject(project);
        this.projectInserter.start(new StreamCopier.ProgressListener(){

            @Override
            public void onProgress(long l, long l2) {
                System.out.print("Uploaded: " + l + " / " + l2 + " bytes...\r");
            }
        });
        Object object = this.lockObject;
        synchronized (object) {
            while (!this.finished) {
                try {
                    this.lockObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.success;
    }

    @Override
    public void projectInsertStarted(Project project) {
        this.outputWriter.println("Starting Insert of project \"" + project.getName() + "\".");
    }

    @Override
    public void projectUploadFinished(Project project) {
        this.outputWriter.println("Project \"" + project.getName() + "\" has been uploaded, starting insert...");
    }

    @Override
    public void projectURIGenerated(Project project, String string) {
        this.outputWriter.println("URI: " + string);
    }

    @Override
    public void projectInsertProgress(Project project, int n, int n2, int n3, int n4, boolean bl) {
        this.outputWriter.println("Progress: " + n + " done, " + n2 + " failed, " + n3 + " fatal, " + n4 + " total" + (bl ? " (finalized)" : "") + ", " + (n + n2 + n3) * 100 / n4 + "%");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void projectInsertFinished(Project project, boolean bl, Throwable throwable) {
        this.outputWriter.println("Request URI: " + project.getFinalRequestURI(0));
        this.finished = true;
        this.success = bl;
        Object object = this.lockObject;
        synchronized (object) {
            this.lockObject.notify();
        }
    }

    public static void main(String[] stringArray) {
        new CLI(stringArray);
    }
}

