/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.main;

import de.todesbaum.jsite.application.FileOption;
import de.todesbaum.jsite.application.Node;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.main.ConfigurationLocator;
import de.todesbaum.util.freenet.fcp2.ClientPutDir;
import de.todesbaum.util.freenet.fcp2.PriorityClass;
import de.todesbaum.util.io.Closer;
import de.todesbaum.util.io.StreamCopier;
import de.todesbaum.util.xml.SimpleXML;
import de.todesbaum.util.xml.XML;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Configuration {
    private SimpleXML rootNode;
    private final ConfigurationLocator configurationLocator;
    private ConfigurationLocator.ConfigurationLocation configurationLocation;

    public Configuration(ConfigurationLocator configurationLocator, ConfigurationLocator.ConfigurationLocation configurationLocation) {
        this.configurationLocator = configurationLocator;
        this.configurationLocation = configurationLocation;
        this.readConfiguration(configurationLocator.getFile(configurationLocation));
    }

    public ConfigurationLocator getConfigurationLocator() {
        return this.configurationLocator;
    }

    public ConfigurationLocator.ConfigurationLocation getConfigurationDirectory() {
        return this.configurationLocation;
    }

    public void setConfigurationLocation(ConfigurationLocator.ConfigurationLocation configurationLocation) {
        this.configurationLocation = configurationLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readConfiguration(String string) {
        File file;
        Logger.getLogger(Configuration.class.getName()).log(Level.CONFIG, "Reading configuration from: " + string);
        if (string != null && (file = new File(string)).exists()) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            FileInputStream fileInputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                fileInputStream = new FileInputStream(file);
                StreamCopier.copy(fileInputStream, byteArrayOutputStream, file.length());
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.rootNode = SimpleXML.fromDocument(XML.transformToDocument(byArray));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Closer.close(fileInputStream);
                Closer.close(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                Closer.close(fileInputStream);
                Closer.close(byteArrayOutputStream);
                {
                    catch (Throwable throwable) {
                        Closer.close(fileInputStream);
                        Closer.close(byteArrayOutputStream);
                        throw throwable;
                    }
                }
            }
            Closer.close(fileInputStream);
            Closer.close(byteArrayOutputStream);
            return;
        }
        this.rootNode = new SimpleXML("configuration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public boolean save() {
        boolean bl;
        Object object;
        Logger.getLogger(Configuration.class.getName()).log(Level.CONFIG, "Trying to save configuration to: " + (Object)((Object)this.configurationLocation));
        File file = new File(this.configurationLocator.getFile(this.configurationLocation));
        if (!(file.exists() || ((File)(object = file.getAbsoluteFile().getParentFile())).exists() || ((File)object).mkdirs())) {
            return false;
        }
        object = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byte[] byArray = XML.transformToByteArray(this.rootNode.getDocument());
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            object = new FileOutputStream(file);
            StreamCopier.copy(byteArrayInputStream, (OutputStream)object, byArray.length);
            bl = true;
        }
        catch (IOException iOException) {
            Closer.close(byteArrayInputStream);
            Closer.close((OutputStream)object);
            catch (Throwable throwable) {
                Closer.close(byteArrayInputStream);
                Closer.close((OutputStream)object);
                throw throwable;
            }
        }
        Closer.close(byteArrayInputStream);
        Closer.close((OutputStream)object);
        return bl;
        return false;
    }

    private String getNodeValue(String[] stringArray, String string) {
        SimpleXML simpleXML;
        int n = 0;
        for (simpleXML = this.rootNode; simpleXML != null && n < stringArray.length; simpleXML = simpleXML.getNode(stringArray[n++])) {
        }
        if (simpleXML == null) {
            return string;
        }
        return simpleXML.getValue();
    }

    private int getNodeIntValue(String[] stringArray, int n) {
        try {
            return Integer.parseInt(this.getNodeValue(stringArray, String.valueOf(n)));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private boolean getNodeBooleanValue(String[] stringArray, boolean bl) {
        String string = this.getNodeValue(stringArray, null);
        if (string == null) {
            return bl;
        }
        return Boolean.parseBoolean(string);
    }

    @Deprecated
    public String getNodeAddress() {
        return this.getNodeValue(new String[]{"node-address"}, "localhost");
    }

    @Deprecated
    public void setNodeAddress(String string) {
        this.rootNode.replace("node-address", string);
    }

    @Deprecated
    public int getNodePort() {
        return this.getNodeIntValue(new String[]{"node-port"}, 9481);
    }

    @Deprecated
    public void setNodePort(int n) {
        this.rootNode.replace("node-port", String.valueOf(n));
    }

    public boolean isSkipNodePage() {
        return this.getNodeBooleanValue(new String[]{"skip-node-page"}, false);
    }

    public void setSkipNodePage(boolean bl) {
        this.rootNode.replace("skip-node-page", String.valueOf(bl));
    }

    public Project[] getProjects() {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        SimpleXML simpleXML = this.rootNode.getNode("project-list");
        if (simpleXML != null) {
            SimpleXML[] simpleXMLArray;
            for (SimpleXML simpleXML2 : simpleXMLArray = simpleXML.getNodes("project")) {
                try {
                    Object object;
                    Object object2;
                    Project project = new Project();
                    arrayList.add(project);
                    project.setDescription(simpleXML2.getNode("description").getValue(""));
                    String string = simpleXML2.getNode("index-file").getValue("");
                    if (string.indexOf(47) > -1) {
                        string = "";
                    }
                    project.setIndexFile(string);
                    project.setLastInsertionTime(Long.parseLong(simpleXML2.getNode("last-insertion-time").getValue("0")));
                    project.setLocalPath(simpleXML2.getNode("local-path").getValue(""));
                    project.setName(simpleXML2.getNode("name").getValue(""));
                    project.setPath(simpleXML2.getNode("path").getValue(""));
                    if (project.getPath() != null && project.getPath().indexOf("/") != -1) {
                        project.setPath(project.getPath().replaceAll("/", ""));
                    }
                    project.setEdition(Integer.parseInt(simpleXML2.getNode("edition").getValue("0")));
                    project.setInsertURI(simpleXML2.getNode("insert-uri").getValue(""));
                    project.setRequestURI(simpleXML2.getNode("request-uri").getValue(""));
                    if (simpleXML2.getNode("ignore-hidden-files") != null) {
                        project.setIgnoreHiddenFiles(Boolean.parseBoolean(simpleXML2.getNode("ignore-hidden-files").getValue("true")));
                    } else {
                        project.setIgnoreHiddenFiles(true);
                    }
                    HashMap<String, FileOption> hashMap = new HashMap<String, FileOption>();
                    SimpleXML simpleXML3 = simpleXML2.getNode("last-insert-hashes");
                    if (simpleXML3 != null) {
                        object2 = simpleXML3.getNodes("file");
                        int n = ((SimpleXML[])object2).length;
                        for (int i = 0; i < n; ++i) {
                            Object object3 = object2[i];
                            String string2 = ((SimpleXML)object3).getNode("filename").getValue();
                            String string3 = ((SimpleXML)object3).getNode("last-insert-hash").getValue();
                            int n2 = Integer.valueOf(((SimpleXML)object3).getNode("last-insert-edition").getValue());
                            object = string2;
                            if (((SimpleXML)object3).getNode("last-insert-filename") != null) {
                                object = ((SimpleXML)object3).getNode("last-insert-filename").getValue();
                            }
                            FileOption fileOption = project.getFileOption(string2);
                            fileOption.setLastInsertHash(string3).setLastInsertEdition(n2).setLastInsertFilename((String)object);
                            hashMap.put(string2, fileOption);
                        }
                    }
                    if ((object2 = simpleXML2.getNode("file-options")) != null) {
                        SimpleXML[] simpleXMLArray2;
                        for (SimpleXML simpleXML4 : simpleXMLArray2 = ((SimpleXML)object2).getNodes("file-option")) {
                            String string4 = simpleXML4.getNode("filename").getValue();
                            object = project.getFileOption(string4);
                            ((FileOption)object).setInsert(Boolean.parseBoolean(simpleXML4.getNode("insert").getValue()));
                            if (simpleXML4.getNode("insert-redirect") != null) {
                                ((FileOption)object).setInsertRedirect(Boolean.parseBoolean(simpleXML4.getNode("insert-redirect").getValue()));
                            }
                            ((FileOption)object).setCustomKey(simpleXML4.getNode("custom-key").getValue(""));
                            if (simpleXML4.getNode("changed-name") != null) {
                                ((FileOption)object).setChangedName(simpleXML4.getNode("changed-name").getValue());
                            }
                            ((FileOption)object).setMimeType(simpleXML4.getNode("mime-type").getValue(""));
                            hashMap.put(string4, (FileOption)object);
                        }
                    }
                    project.setFileOptions(hashMap);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
        }
        return arrayList.toArray(new Project[arrayList.size()]);
    }

    public void setProjects(Project[] projectArray) {
        SimpleXML simpleXML = new SimpleXML("project-list");
        for (Project project : projectArray) {
            Object object;
            Map.Entry<String, FileOption> entry2;
            SimpleXML simpleXML2 = simpleXML.append("project");
            simpleXML2.append("edition", String.valueOf(project.getEdition()));
            simpleXML2.append("description", project.getDescription());
            simpleXML2.append("index-file", project.getIndexFile());
            simpleXML2.append("last-insertion-time", String.valueOf(project.getLastInsertionTime()));
            simpleXML2.append("local-path", project.getLocalPath());
            simpleXML2.append("name", project.getName());
            simpleXML2.append("path", project.getPath());
            simpleXML2.append("insert-uri", project.getInsertURI());
            simpleXML2.append("request-uri", project.getRequestURI());
            simpleXML2.append("ignore-hidden-files", String.valueOf(project.isIgnoreHiddenFiles()));
            SimpleXML simpleXML3 = simpleXML2.append("last-insert-hashes");
            for (Map.Entry<String, FileOption> entry2 : project.getFileOptions().entrySet()) {
                if (entry2.getValue().getLastInsertHash() == null || ((FileOption)entry2.getValue()).getLastInsertHash().length() == 0) continue;
                object = simpleXML3.append("file");
                ((SimpleXML)object).append("filename", (String)entry2.getKey());
                ((SimpleXML)object).append("last-insert-hash", ((FileOption)entry2.getValue()).getLastInsertHash());
                ((SimpleXML)object).append("last-insert-edition", String.valueOf(((FileOption)entry2.getValue()).getLastInsertEdition()));
                ((SimpleXML)object).append("last-insert-filename", ((FileOption)entry2.getValue()).getLastInsertFilename());
            }
            SimpleXML simpleXML4 = simpleXML2.append("file-options");
            entry2 = project.getFileOptions().entrySet().iterator();
            while (entry2.hasNext()) {
                object = (Map.Entry)entry2.next();
                FileOption fileOption = (FileOption)object.getValue();
                if (!fileOption.isCustom()) continue;
                SimpleXML simpleXML5 = simpleXML4.append("file-option");
                simpleXML5.append("filename", (String)object.getKey());
                simpleXML5.append("insert", String.valueOf(fileOption.isInsert()));
                simpleXML5.append("insert-redirect", String.valueOf(fileOption.isInsertRedirect()));
                simpleXML5.append("custom-key", fileOption.getCustomKey());
                simpleXML5.append("changed-name", fileOption.getChangedName());
                simpleXML5.append("mime-type", fileOption.getMimeType());
            }
        }
        this.rootNode.replace(simpleXML);
    }

    public Locale getLocale() {
        String string = this.getNodeValue(new String[]{"i18n", "language"}, "en");
        String string2 = this.getNodeValue(new String[]{"i18n", "country"}, null);
        if (string2 != null) {
            return new Locale(string, string2);
        }
        return new Locale(string);
    }

    public void setLocale(Locale locale) {
        SimpleXML simpleXML = new SimpleXML("i18n");
        if (locale.getCountry().length() != 0) {
            simpleXML.append("country", locale.getCountry());
        }
        simpleXML.append("language", locale.getLanguage());
        this.rootNode.replace(simpleXML);
    }

    public Node[] getNodes() {
        SimpleXML simpleXML = this.rootNode.getNode("nodes");
        if (simpleXML == null) {
            String string = this.getNodeAddress();
            int n = this.getNodePort();
            if (string == null) {
                string = "127.0.0.1";
                n = 9481;
            }
            return new Node[]{new Node(string, n, "Node")};
        }
        SimpleXML[] simpleXMLArray = simpleXML.getNodes("node");
        Node[] nodeArray = new Node[simpleXMLArray.length];
        int n = 0;
        for (SimpleXML simpleXML2 : simpleXMLArray) {
            String string = simpleXML2.getNode("name").getValue();
            String string2 = simpleXML2.getNode("hostname").getValue();
            int n2 = Integer.parseInt(simpleXML2.getNode("port").getValue());
            Node node = new Node(string2, n2, string);
            nodeArray[n++] = node;
        }
        return nodeArray;
    }

    public void setNodes(Node[] nodeArray) {
        SimpleXML simpleXML = new SimpleXML("nodes");
        for (Node node : nodeArray) {
            SimpleXML simpleXML2 = simpleXML.append("node");
            simpleXML2.append("name", node.getName());
            simpleXML2.append("hostname", node.getHostname());
            simpleXML2.append("port", String.valueOf(node.getPort()));
        }
        this.rootNode.replace(simpleXML);
        this.rootNode.remove("node-address");
        this.rootNode.remove("node-port");
    }

    public void setSelectedNode(Node node) {
        SimpleXML simpleXML = new SimpleXML("selected-node");
        simpleXML.append("name", node.getName());
        simpleXML.append("hostname", node.getHostname());
        simpleXML.append("port", String.valueOf(node.getPort()));
        this.rootNode.replace(simpleXML);
    }

    public Node getSelectedNode() {
        SimpleXML simpleXML = this.rootNode.getNode("selected-node");
        if (simpleXML == null) {
            String string = this.getNodeAddress();
            int n = this.getNodePort();
            if (string == null) {
                string = "127.0.0.1";
                n = 9481;
            }
            return new Node(string, n, "Node");
        }
        String string = simpleXML.getNode("name").getValue();
        String string2 = simpleXML.getNode("hostname").getValue();
        int n = Integer.valueOf(simpleXML.getNode("port").getValue());
        return new Node(string2, n, string);
    }

    public String getTempDirectory() {
        return this.getNodeValue(new String[]{"temp-directory"}, null);
    }

    public void setTempDirectory(String string) {
        if (string != null) {
            SimpleXML simpleXML = new SimpleXML("temp-directory");
            simpleXML.setValue(string);
            this.rootNode.replace(simpleXML);
        } else {
            this.rootNode.remove("temp-directory");
        }
    }

    public boolean useEarlyEncode() {
        return this.getNodeBooleanValue(new String[]{"use-early-encode"}, false);
    }

    public Configuration setUseEarlyEncode(boolean bl) {
        this.rootNode.replace("use-early-encode", String.valueOf(bl));
        return this;
    }

    public PriorityClass getPriority() {
        return PriorityClass.valueOf(this.getNodeValue(new String[]{"insert-priority"}, "interactive"));
    }

    public Configuration setPriority(PriorityClass priorityClass) {
        this.rootNode.replace("insert-priority", priorityClass.toString());
        return this;
    }

    public ClientPutDir.ManifestPutter getManifestPutter() {
        return ClientPutDir.ManifestPutter.valueOf(this.getNodeValue(new String[]{"manifest-putter"}, "simple").toUpperCase());
    }

    public Configuration setManifestPutter(ClientPutDir.ManifestPutter manifestPutter) {
        this.rootNode.replace("manifest-putter", manifestPutter.name().toLowerCase());
        return this;
    }
}

