/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application;

import de.todesbaum.jsite.application.AbortedException;
import de.todesbaum.jsite.application.FileOption;
import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.InsertListener;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.gui.FileScanner;
import de.todesbaum.jsite.gui.FileScannerListener;
import de.todesbaum.util.freenet.fcp2.Client;
import de.todesbaum.util.freenet.fcp2.ClientPutComplexDir;
import de.todesbaum.util.freenet.fcp2.ClientPutDir;
import de.todesbaum.util.freenet.fcp2.Command;
import de.todesbaum.util.freenet.fcp2.Connection;
import de.todesbaum.util.freenet.fcp2.DirectFileEntry;
import de.todesbaum.util.freenet.fcp2.FileEntry;
import de.todesbaum.util.freenet.fcp2.Message;
import de.todesbaum.util.freenet.fcp2.PriorityClass;
import de.todesbaum.util.freenet.fcp2.RedirectFileEntry;
import de.todesbaum.util.freenet.fcp2.Verbosity;
import de.todesbaum.util.io.StreamCopier;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProjectInserter
implements FileScannerListener,
Runnable {
    private static final Logger logger = Logger.getLogger(ProjectInserter.class.getName());
    private static final int random = (int)(Math.random() * 2.147483647E9);
    private static int counter = 0;
    private List<InsertListener> insertListeners = new ArrayList<InsertListener>();
    protected Freenet7Interface freenetInterface;
    protected Project project;
    private FileScanner fileScanner;
    protected final Object lockObject = new Object();
    private String tempDirectory;
    private Connection connection;
    private volatile boolean cancelled = false;
    private StreamCopier.ProgressListener progressListener;
    private boolean useEarlyEncode;
    private PriorityClass priority;
    private ClientPutDir.ManifestPutter manifestPutter;

    public void addInsertListener(InsertListener insertListener) {
        this.insertListeners.add(insertListener);
    }

    public void removeInsertListener(InsertListener insertListener) {
        this.insertListeners.remove(insertListener);
    }

    protected void fireProjectInsertStarted() {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectInsertStarted(this.project);
        }
    }

    protected void fireProjectURIGenerated(String string) {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectURIGenerated(this.project, string);
        }
    }

    protected void fireProjectUploadFinished() {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectUploadFinished(this.project);
        }
    }

    protected void fireProjectInsertProgress(int n, int n2, int n3, int n4, boolean bl) {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectInsertProgress(this.project, n, n2, n3, n4, bl);
        }
    }

    protected void fireProjectInsertFinished(boolean bl, Throwable throwable) {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectInsertFinished(this.project, bl, throwable);
        }
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setFreenetInterface(Freenet7Interface freenet7Interface) {
        this.freenetInterface = freenet7Interface;
    }

    public void setTempDirectory(String string) {
        this.tempDirectory = string;
    }

    public void setUseEarlyEncode(boolean bl) {
        this.useEarlyEncode = bl;
    }

    public void setPriority(PriorityClass priorityClass) {
        this.priority = priorityClass;
    }

    public void setManifestPutter(ClientPutDir.ManifestPutter manifestPutter) {
        this.manifestPutter = manifestPutter;
    }

    public void start(StreamCopier.ProgressListener progressListener) {
        this.cancelled = false;
        this.progressListener = progressListener;
        this.fileScanner = new FileScanner(this.project);
        this.fileScanner.addFileScannerListener(this);
        new Thread(this.fileScanner).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.cancelled = true;
        Object object = this.lockObject;
        synchronized (object) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    private InputStream createFileInputStream(String string, FileOption fileOption, int n, long[] lArray) throws IOException {
        File file = new File(this.project.getLocalPath(), string);
        lArray[0] = file.length();
        return new FileInputStream(file);
    }

    private FileEntry createFileEntry(FileScanner.ScannedFile scannedFile, int n) {
        FileEntry fileEntry = null;
        String string = scannedFile.getFilename();
        FileOption fileOption = this.project.getFileOption(string);
        if (fileOption.isInsert()) {
            fileOption.setCurrentHash(scannedFile.getHash());
            if (!fileOption.isForceInsert() && scannedFile.getHash().equals(fileOption.getLastInsertHash())) {
                logger.log(Level.FINE, String.format("Inserting redirect to edition %d for %s.", fileOption.getLastInsertEdition(), string));
                return new RedirectFileEntry(fileOption.hasChangedName() ? fileOption.getChangedName() : string, fileOption.getMimeType(), "SSK@" + this.project.getRequestURI() + "/" + this.project.getPath() + "-" + fileOption.getLastInsertEdition() + "/" + fileOption.getLastInsertFilename());
            }
            try {
                long[] lArray = new long[1];
                InputStream inputStream = this.createFileInputStream(string, fileOption, n, lArray);
                fileEntry = new DirectFileEntry(fileOption.hasChangedName() ? fileOption.getChangedName() : string, fileOption.getMimeType(), inputStream, lArray[0]);
            }
            catch (IOException iOException) {}
        } else if (fileOption.isInsertRedirect()) {
            fileEntry = new RedirectFileEntry(fileOption.hasChangedName() ? fileOption.getChangedName() : string, fileOption.getMimeType(), fileOption.getCustomKey());
        }
        return fileEntry;
    }

    public static CheckReport validateProject(Project project) {
        FileOption fileOption;
        Object object;
        CheckReport checkReport = new CheckReport();
        if (project.getLocalPath() == null || project.getLocalPath().trim().length() == 0) {
            checkReport.addIssue("error.no-local-path", true, new String[0]);
        }
        if (project.getPath() == null || project.getPath().trim().length() == 0) {
            checkReport.addIssue("error.no-path", true, new String[0]);
        }
        if (project.getIndexFile() == null || project.getIndexFile().length() == 0) {
            checkReport.addIssue("warning.empty-index", false, new String[0]);
        } else {
            object = new File(project.getLocalPath(), project.getIndexFile());
            if (!((File)object).exists()) {
                checkReport.addIssue("error.index-missing", true, new String[0]);
            }
        }
        object = project.getIndexFile();
        boolean bl = object != null && ((String)object).length() > 0;
        List<String> list = Arrays.asList("text/html", "application/xhtml+xml");
        if (bl && !list.contains(project.getFileOption((String)object).getMimeType())) {
            checkReport.addIssue("warning.index-not-html", false, new String[0]);
        }
        Map<String, FileOption> map = project.getFileOptions();
        Set<Map.Entry<String, FileOption>> set = map.entrySet();
        boolean bl2 = set.isEmpty();
        for (Map.Entry<String, FileOption> object2 : set) {
            String string = object2.getKey();
            fileOption = object2.getValue();
            bl2 |= fileOption.isInsert() || fileOption.isInsertRedirect();
            if (string.equals(project.getIndexFile()) && !fileOption.isInsert() && !fileOption.isInsertRedirect()) {
                checkReport.addIssue("error.index-not-inserted", true, new String[0]);
            }
            if (fileOption.isInsert() || !fileOption.isInsertRedirect() || fileOption.getCustomKey().length() != 0 && !"CHK@".equals(fileOption.getCustomKey())) continue;
            checkReport.addIssue("error.no-custom-key", true, string);
        }
        if (!bl2) {
            checkReport.addIssue("error.no-files-to-insert", true, new String[0]);
        }
        HashSet hashSet = new HashSet();
        for (Map.Entry<String, FileOption> entry : set) {
            fileOption = entry.getValue();
            if (!fileOption.isInsert() && !fileOption.isInsertRedirect()) {
                logger.log(Level.FINEST, "Ignoring {0}.", entry.getKey());
                continue;
            }
            String string = entry.getKey();
            if (fileOption.hasChangedName()) {
                string = fileOption.getChangedName();
            }
            logger.log(Level.FINEST, "Adding \u201a\u00c4\u00fa{0}\u201a\u00c4\u00f9 for {1}.", new Object[]{string, entry.getKey()});
            if (hashSet.add(string)) continue;
            checkReport.addIssue("error.duplicate-file", true, string);
        }
        return checkReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        this.fireProjectInsertStarted();
        List<FileScanner.ScannedFile> list = this.fileScanner.getFiles();
        Object object2 = this.lockObject;
        synchronized (object2) {
            this.connection = this.freenetInterface.getConnection("project-insert-" + random + counter++);
        }
        this.connection.setTempDirectory(this.tempDirectory);
        boolean bl = false;
        IOException iOException = null;
        try {
            bl = this.connection.connect();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (!bl || this.cancelled) {
            this.fireProjectInsertFinished(false, this.cancelled ? new AbortedException() : iOException);
            return;
        }
        Client client = new Client(this.connection);
        int n = this.project.getEdition();
        String string = "USK@" + this.project.getInsertURI() + "/" + this.project.getPath() + "/" + n + "/";
        ClientPutComplexDir clientPutComplexDir = new ClientPutComplexDir("dir-" + counter++, string, this.tempDirectory);
        if (this.project.getIndexFile() != null && this.project.getIndexFile().length() > 0) {
            clientPutComplexDir.setDefaultName(this.project.getIndexFile());
        }
        clientPutComplexDir.setVerbosity(Verbosity.ALL);
        clientPutComplexDir.setMaxRetries(-1);
        clientPutComplexDir.setEarlyEncode(this.useEarlyEncode);
        clientPutComplexDir.setPriorityClass(this.priority);
        clientPutComplexDir.setManifestPutter(this.manifestPutter);
        for (FileScanner.ScannedFile scannedFile : list) {
            FileEntry fileEntry = this.createFileEntry(scannedFile, n);
            if (fileEntry == null) continue;
            try {
                clientPutComplexDir.addFileEntry(fileEntry);
            }
            catch (IOException iOException3) {
                this.fireProjectInsertFinished(false, iOException3);
                return;
            }
        }
        try {
            client.execute((Command)clientPutComplexDir, this.progressListener);
            this.fireProjectUploadFinished();
        }
        catch (IOException iOException4) {
            this.fireProjectInsertFinished(false, iOException4);
            return;
        }
        Object object3 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        while (!bl3 && !this.cancelled) {
            object = client.readMessage();
            bl3 = object == null || (bl4 = client.isDisconnected());
            logger.log(Level.FINE, "Received message: " + object);
            if (bl3) continue;
            String string2 = ((Message)object).getName();
            if ("URIGenerated".equals(string2)) {
                object3 = ((Message)object).get("URI");
                this.fireProjectURIGenerated((String)object3);
            }
            if ("SimpleProgress".equals(string2)) {
                int n2 = Integer.parseInt(((Message)object).get("Total"));
                int n3 = Integer.parseInt(((Message)object).get("Succeeded"));
                int n4 = Integer.parseInt(((Message)object).get("FatallyFailed"));
                int n5 = Integer.parseInt(((Message)object).get("Failed"));
                boolean bl5 = Boolean.parseBoolean(((Message)object).get("FinalizedTotal"));
                this.fireProjectInsertProgress(n3, n5, n4, n2, bl5);
            }
            bl3 = (bl2 |= "PutSuccessful".equals(string2)) && object3 != null || "PutFailed".equals(string2) || string2.endsWith("Error");
        }
        if (bl2) {
            object = ((String)object3).substring(((String)object3).lastIndexOf(47) + 1);
            int n6 = Integer.parseInt((String)object);
            this.project.setEdition(n6);
            this.project.setLastInsertionTime(System.currentTimeMillis());
            this.project.onSuccessfulInsert();
        }
        this.fireProjectInsertFinished(bl2, this.cancelled ? new AbortedException() : (bl4 ? new IOException("Connection terminated") : null));
    }

    @Override
    public void fileScannerFinished(FileScanner fileScanner) {
        if (!fileScanner.isError()) {
            new Thread(this).start();
        } else {
            this.fireProjectInsertFinished(false, null);
        }
        fileScanner.removeFileScannerListener(this);
    }

    public static class Issue {
        private final String errorKey;
        private final boolean fatal;
        private String[] parameters;

        protected Issue(String string, boolean bl, String ... stringArray) {
            this.errorKey = string;
            this.fatal = bl;
            this.parameters = stringArray;
        }

        public String getErrorKey() {
            return this.errorKey;
        }

        public boolean isFatal() {
            return this.fatal;
        }

        public String[] getParameters() {
            return this.parameters;
        }
    }

    public static class CheckReport
    implements Iterable<Issue> {
        private final List<Issue> issues = new ArrayList<Issue>();

        public void addIssue(Issue issue) {
            this.issues.add(issue);
        }

        public void addIssue(String string, boolean bl, String ... stringArray) {
            this.addIssue(new Issue(string, bl, stringArray));
        }

        @Override
        public Iterator<Issue> iterator() {
            return this.issues.iterator();
        }

        public boolean isEmpty() {
            return this.issues.isEmpty();
        }

        public int size() {
            return this.issues.size();
        }
    }
}

