/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.util.swing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;

public class SortedListModel<T extends Comparable<T>>
extends AbstractListModel
implements List<T> {
    private List<T> elements = new ArrayList<T>();

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public Object getElementAt(int n) {
        return this.elements.get(n);
    }

    @Override
    public void add(int n, T t) {
        this.elements.add(n, t);
        Collections.sort(this.elements);
        this.fireContentsChanged(this, 0, this.size());
    }

    @Override
    public boolean add(T t) {
        boolean bl = this.elements.add(t);
        Collections.sort(this.elements);
        this.fireContentsChanged(this, 0, this.size());
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean bl = this.elements.addAll(collection);
        Collections.sort(this.elements);
        this.fireContentsChanged(this, 0, this.size());
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        boolean bl = this.elements.addAll(n, collection);
        Collections.sort(this.elements);
        this.fireContentsChanged(this, 0, this.size());
        return bl;
    }

    @Override
    public void clear() {
        this.elements.clear();
        this.fireContentsChanged(this, 0, this.size());
    }

    @Override
    public boolean contains(Object object) {
        return this.elements.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.elements.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.elements).equals(object);
    }

    @Override
    public T get(int n) {
        return (T)((Comparable)this.elements.get(n));
    }

    @Override
    public int hashCode() {
        return ((Object)this.elements).hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.elements.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.elements.lastIndexOf(object);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.elements.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        return this.elements.listIterator(n);
    }

    @Override
    public T remove(int n) {
        this.fireContentsChanged(this, 0, this.size());
        return (T)((Comparable)this.elements.remove(n));
    }

    @Override
    public boolean remove(Object object) {
        this.fireContentsChanged(this, 0, this.size());
        return this.elements.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.fireContentsChanged(this, 0, this.size());
        return this.elements.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        this.fireContentsChanged(this, 0, this.size());
        return this.elements.retainAll(collection);
    }

    @Override
    public T set(int n, T t) {
        Comparable comparable = (Comparable)this.elements.set(n, t);
        Collections.sort(this.elements);
        this.fireContentsChanged(this, 0, this.size());
        return (T)comparable;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public List<T> subList(int n, int n2) {
        return this.elements.subList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <U> U[] toArray(U[] UArray) {
        return this.elements.toArray(UArray);
    }
}

