/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application;

import de.todesbaum.jsite.application.Node;
import de.todesbaum.util.freenet.fcp2.Client;
import de.todesbaum.util.freenet.fcp2.Connection;
import de.todesbaum.util.freenet.fcp2.GenerateSSK;
import de.todesbaum.util.freenet.fcp2.Message;
import java.io.IOException;

public class Freenet7Interface {
    private static final int number = (int)(Math.random() * 2.147483647E9);
    private static int counter = 0;
    private de.todesbaum.util.freenet.fcp2.Node node;
    private Connection connection;

    public void setNodeAddress(String string) {
        this.node = new de.todesbaum.util.freenet.fcp2.Node(string);
        this.connection = new Connection(this.node, "jSite-" + number + "-connection-" + counter++);
    }

    public void setNodeAddress(String string, int n) {
        this.node = new de.todesbaum.util.freenet.fcp2.Node(string, n);
        this.connection = new Connection(this.node, "jSite-" + number + "-connection-" + counter++);
    }

    public void setNode(Node node) {
        if (node != null) {
            this.node = new de.todesbaum.util.freenet.fcp2.Node(node.getHostname(), node.getPort());
            this.connection = new Connection(node, "jSite-" + number + "-connection-" + counter++);
        } else {
            this.node = null;
            this.connection = null;
        }
    }

    public void removeNode() {
        this.node = null;
        this.connection = null;
    }

    public de.todesbaum.util.freenet.fcp2.Node getNode() {
        return this.node;
    }

    public Connection getConnection(String string) {
        return new Connection(this.node, string);
    }

    public boolean isNodePresent() throws IOException {
        if (!this.connection.isConnected()) {
            return this.connection.connect();
        }
        return true;
    }

    public String[] generateKeyPair() throws IOException {
        if (!this.isNodePresent()) {
            throw new IOException("Node is offline.");
        }
        GenerateSSK generateSSK = new GenerateSSK();
        Client client = new Client(this.connection, generateSSK);
        Message message = client.readMessage();
        return new String[]{message.get("InsertURI"), message.get("RequestURI")};
    }

    public boolean hasNode() {
        return this.node != null && this.connection != null;
    }
}

