/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.gui;

import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.gui.FileScannerListener;
import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.util.io.Closer;
import de.todesbaum.util.io.StreamCopier;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileScanner
implements Runnable {
    private static final Logger logger = Logger.getLogger(FileScanner.class.getName());
    private final List<FileScannerListener> fileScannerListeners = new ArrayList<FileScannerListener>();
    private final Project project;
    private List<ScannedFile> files;
    private boolean error = false;

    public FileScanner(Project project) {
        this.project = project;
    }

    public void addFileScannerListener(FileScannerListener fileScannerListener) {
        this.fileScannerListeners.add(fileScannerListener);
    }

    public void removeFileScannerListener(FileScannerListener fileScannerListener) {
        this.fileScannerListeners.remove(fileScannerListener);
    }

    protected void fireFileScannerFinished() {
        for (FileScannerListener fileScannerListener : new ArrayList<FileScannerListener>(this.fileScannerListeners)) {
            fileScannerListener.fileScannerFinished(this);
        }
    }

    @Override
    public void run() {
        this.files = new ArrayList<ScannedFile>();
        this.error = false;
        try {
            this.scanFiles(new File(this.project.getLocalPath()), this.files);
            Collections.sort(this.files);
        }
        catch (IOException iOException) {
            this.error = true;
        }
        this.fireFileScannerFinished();
    }

    public boolean isError() {
        return this.error;
    }

    public List<ScannedFile> getFiles() {
        return this.files;
    }

    private void scanFiles(File file, List<ScannedFile> list) throws IOException {
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !FileScanner.this.project.isIgnoreHiddenFiles() || !file.isHidden();
            }
        });
        if (fileArray == null) {
            throw new IOException(I18n.getMessage("jsite.file-scanner.can-not-read-directory"));
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                this.scanFiles(file2, list);
                continue;
            }
            String string = this.project.shortenFilename(file2).replace('\\', '/');
            String string2 = FileScanner.hashFile(this.project.getLocalPath(), string);
            list.add(new ScannedFile(string, string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String hashFile(String string, String string2) {
        block7: {
            String string3;
            FileInputStream fileInputStream = null;
            DigestOutputStream digestOutputStream = null;
            File file = new File(string, string2);
            try {
                fileInputStream = new FileInputStream(file);
                digestOutputStream = new DigestOutputStream(new NullOutputStream(), MessageDigest.getInstance("SHA-256"));
                StreamCopier.copy(fileInputStream, digestOutputStream, file.length());
                string3 = FileScanner.toHex(digestOutputStream.getMessageDigest().digest());
                Closer.close(digestOutputStream);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                logger.log(Level.WARNING, "Could not get SHA-256 digest!", noSuchAlgorithmException);
                break block7;
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, "Could not read file!", iOException);
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Closer.close(digestOutputStream);
                Closer.close(fileInputStream);
            }
            Closer.close(fileInputStream);
            return string3;
        }
        return FileScanner.toHex(new byte[32]);
    }

    private static String toHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            stringBuilder.append("0123456789abcdef".charAt(by >>> 4 & 0xF)).append("0123456789abcdef".charAt(by & 0xF));
        }
        return stringBuilder.toString();
    }

    public static class ScannedFile
    implements Comparable<ScannedFile> {
        private final String filename;
        private final String hash;

        public ScannedFile(String string, String string2) {
            this.filename = string;
            this.hash = string2;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getHash() {
            return this.hash;
        }

        public int hashCode() {
            return this.filename.hashCode();
        }

        public boolean equals(Object object) {
            return this.filename.equals(object);
        }

        public String toString() {
            return this.filename;
        }

        @Override
        public int compareTo(ScannedFile scannedFile) {
            return this.filename.compareTo(scannedFile.filename);
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int n) {
        }

        @Override
        public void write(byte[] byArray) {
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
        }
    }
}

