/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.main;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationLocator {
    private final Map<ConfigurationLocation, String> configurationFiles = new HashMap<ConfigurationLocation, String>();

    public ConfigurationLocator() {
        Object object;
        String string = this.getClass().getResource("/" + this.getClass().getName().replace(".", "/") + ".class").toString();
        if (string.startsWith("jar:")) {
            object = string.substring(9, string.indexOf(".jar!") + 4);
            String string2 = new File((String)object).getParent();
            File file = new File(string2, "jSite.conf");
            this.configurationFiles.put(ConfigurationLocation.NEXT_TO_JAR_FILE, file.getPath());
        }
        object = new File(System.getProperty("user.home"), ".jSite/config7");
        this.configurationFiles.put(ConfigurationLocation.HOME_DIRECTORY, ((File)object).getPath());
    }

    public void setCustomLocation(String string) {
        this.configurationFiles.put(ConfigurationLocation.CUSTOM, string);
    }

    public boolean isValidLocation(ConfigurationLocation configurationLocation) {
        return this.configurationFiles.containsKey((Object)configurationLocation);
    }

    public boolean hasFile(ConfigurationLocation configurationLocation) {
        if (!this.isValidLocation(configurationLocation)) {
            return false;
        }
        return new File(this.configurationFiles.get((Object)configurationLocation)).exists();
    }

    public String getFile(ConfigurationLocation configurationLocation) {
        return this.configurationFiles.get((Object)configurationLocation);
    }

    public ConfigurationLocation findPreferredLocation() {
        return this.findPreferredLocation(ConfigurationLocation.NEXT_TO_JAR_FILE);
    }

    public ConfigurationLocation findPreferredLocation(ConfigurationLocation configurationLocation) {
        if (this.hasFile(ConfigurationLocation.CUSTOM)) {
            return ConfigurationLocation.CUSTOM;
        }
        if (this.hasFile(ConfigurationLocation.NEXT_TO_JAR_FILE)) {
            return ConfigurationLocation.NEXT_TO_JAR_FILE;
        }
        if (this.hasFile(ConfigurationLocation.HOME_DIRECTORY)) {
            return ConfigurationLocation.HOME_DIRECTORY;
        }
        if (this.isValidLocation(configurationLocation)) {
            return configurationLocation;
        }
        return ConfigurationLocation.HOME_DIRECTORY;
    }

    public static enum ConfigurationLocation {
        NEXT_TO_JAR_FILE,
        HOME_DIRECTORY,
        CUSTOM;

    }
}

