/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application;

import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.util.freenet.fcp2.Client;
import de.todesbaum.util.freenet.fcp2.Connection;
import de.todesbaum.util.freenet.fcp2.FcpPluginMessage;
import de.todesbaum.util.freenet.fcp2.Message;
import de.todesbaum.util.freenet.fcp2.wot.DefaultOwnIdentity;
import de.todesbaum.util.freenet.fcp2.wot.OwnIdentity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.logging.Logging;

public class WebOfTrustInterface
implements Runnable {
    private static final Logger logger = Logging.getLogger(WebOfTrustInterface.class);
    private static final AtomicLong commandCounter = new AtomicLong(System.nanoTime());
    private final Object syncObject = new Object();
    private final Freenet7Interface freenetInterface;
    private boolean shouldStop;
    private final List<OwnIdentity> ownIdentities = new ArrayList<OwnIdentity>();

    public WebOfTrustInterface(Freenet7Interface freenetInterface) {
        this.freenetInterface = freenetInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OwnIdentity> getOwnIdentities() {
        List<OwnIdentity> list = this.ownIdentities;
        synchronized (list) {
            return new ArrayList<OwnIdentity>(this.ownIdentities);
        }
    }

    public void start() {
        Thread webOfTrustThread = new Thread((Runnable)this, "WebOfTrust Interface");
        webOfTrustThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.syncObject;
        synchronized (object) {
            this.shouldStop = true;
            this.syncObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldStop() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.shouldStop;
        }
    }

    private static String shortenUri(String uri) {
        String shortenedUri = uri;
        if (shortenedUri.charAt(3) == '@') {
            shortenedUri = shortenedUri.substring(4);
        }
        if (shortenedUri.indexOf(47) > -1) {
            shortenedUri = shortenedUri.substring(0, shortenedUri.indexOf(47));
        }
        return shortenedUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean waitBeforeReconnect = false;
        while (!this.shouldStop()) {
            if (waitBeforeReconnect) {
                logger.log(Level.FINE, "Waiting 60 seconds before reconnecting.");
                Object object = this.syncObject;
                synchronized (object) {
                    try {
                        this.syncObject.wait(60000L);
                    }
                    catch (InterruptedException ie1) {
                        // empty catch block
                    }
                }
                if (this.shouldStop()) {
                    continue;
                }
            } else {
                waitBeforeReconnect = true;
            }
            try {
                Connection connection = this.freenetInterface.getConnection("jSite-WoT-Connector");
                logger.log(Level.INFO, String.format("Trying to connect to node at %s...", this.freenetInterface.getNode()));
                if (!connection.connect()) {
                    logger.log(Level.WARNING, "Connection failed.");
                    continue;
                }
                Client client = new Client(connection);
                String messageIdentifier = "jSite-WoT-Command-" + commandCounter.getAndIncrement();
                FcpPluginMessage pluginMessage = new FcpPluginMessage(messageIdentifier);
                pluginMessage.setPluginName("plugins.WebOfTrust.WebOfTrust");
                pluginMessage.setParameter("Message", "GetOwnIdentities");
                client.execute(pluginMessage);
                Message message = null;
                while (!client.isDisconnected() && !this.shouldStop() && message == null) {
                    message = client.readMessage(1000L);
                }
                if (message == null) continue;
                if (message.getName().equals("FCPPluginReply")) {
                    logger.log(Level.FINE, "Got matching Reply from WebOfTrust.");
                    ArrayList<DefaultOwnIdentity> ownIdentities = new ArrayList<DefaultOwnIdentity>();
                    int identityCounter = -1;
                    while (message.get("Replies.Identity" + ++identityCounter) != null) {
                        String id = message.get("Replies.Identity" + identityCounter);
                        String nickname = message.get("Replies.Nickname" + identityCounter);
                        String requestUri = WebOfTrustInterface.shortenUri(message.get("Replies.RequestURI" + identityCounter));
                        String insertUri = WebOfTrustInterface.shortenUri(message.get("Replies.InsertURI" + identityCounter));
                        DefaultOwnIdentity ownIdentity = new DefaultOwnIdentity(id, nickname, requestUri, insertUri);
                        logger.log(Level.FINE, String.format("Parsed Own Identity %s.", ownIdentity));
                        ownIdentities.add(ownIdentity);
                    }
                    logger.log(Level.INFO, String.format("Parsed %d Own Identities.", ownIdentities.size()));
                    List<OwnIdentity> list = this.ownIdentities;
                    synchronized (list) {
                        this.ownIdentities.clear();
                        this.ownIdentities.addAll(ownIdentities);
                    }
                } else if ("ProtocolError".equals(message.getName())) {
                    logger.log(Level.WARNING, "WebOfTrust Plugin not found!");
                }
                logger.log(Level.INFO, "Disconnecting from Node.");
                connection.disconnect();
            }
            catch (IOException ioe1) {
                logger.log(Level.WARNING, String.format("Communication with node at %s failed.", this.freenetInterface.getNode()), ioe1);
            }
        }
    }
}

