/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.i18n;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class I18nContainer
implements Iterable<Runnable> {
    private static final I18nContainer singleton = new I18nContainer();
    private final List<Runnable> i18nRunnables = Collections.synchronizedList(new ArrayList());
    private final List<Runnable> i18nPostRunnables = Collections.synchronizedList(new ArrayList());

    public static I18nContainer getInstance() {
        return singleton;
    }

    public void registerRunnable(Runnable i18nRunnable) {
        this.i18nRunnables.add(i18nRunnable);
    }

    public void registerPostRunnable(Runnable i18nPostRunnable) {
        this.i18nPostRunnables.add(i18nPostRunnable);
    }

    @Override
    public Iterator<Runnable> iterator() {
        ArrayList<Runnable> allRunnables = new ArrayList<Runnable>();
        allRunnables.addAll(this.i18nRunnables);
        allRunnables.addAll(this.i18nPostRunnables);
        return allRunnables.iterator();
    }
}

