/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.main;

import de.todesbaum.jsite.application.FileOption;
import de.todesbaum.jsite.application.Node;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.main.ConfigurationLocator;
import de.todesbaum.util.freenet.fcp2.ClientPutDir;
import de.todesbaum.util.freenet.fcp2.PriorityClass;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.io.StreamCopier;
import net.pterodactylus.util.xml.SimpleXML;
import net.pterodactylus.util.xml.XML;

public class Configuration {
    private SimpleXML rootNode;
    private final ConfigurationLocator configurationLocator;
    private ConfigurationLocator.ConfigurationLocation configurationLocation;

    public Configuration(ConfigurationLocator configurationLocator, ConfigurationLocator.ConfigurationLocation configurationLocation) {
        this.configurationLocator = configurationLocator;
        this.configurationLocation = configurationLocation;
        this.readConfiguration(configurationLocator.getFile(configurationLocation));
    }

    public ConfigurationLocator getConfigurationLocator() {
        return this.configurationLocator;
    }

    public ConfigurationLocator.ConfigurationLocation getConfigurationDirectory() {
        return this.configurationLocation;
    }

    public void setConfigurationLocation(ConfigurationLocator.ConfigurationLocation configurationLocation) {
        this.configurationLocation = configurationLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readConfiguration(String filename) {
        File configurationFile;
        Logger.getLogger(Configuration.class.getName()).log(Level.CONFIG, "Reading configuration from: " + filename);
        if (filename != null && (configurationFile = new File(filename)).exists()) {
            ByteArrayOutputStream fileByteOutputStream = null;
            FileInputStream fileInputStream = null;
            try {
                fileByteOutputStream = new ByteArrayOutputStream();
                fileInputStream = new FileInputStream(configurationFile);
                StreamCopier.copy((InputStream)fileInputStream, (OutputStream)fileByteOutputStream, configurationFile.length());
                fileByteOutputStream.close();
                byte[] fileBytes = fileByteOutputStream.toByteArray();
                this.rootNode = SimpleXML.fromDocument(XML.transformToDocument(fileBytes));
            }
            catch (FileNotFoundException e) {
                Closer.close(fileInputStream);
                Closer.close(fileByteOutputStream);
            }
            catch (IOException e2) {
                Closer.close(fileInputStream);
                Closer.close(fileByteOutputStream);
                {
                    catch (Throwable throwable) {
                        Closer.close(fileInputStream);
                        Closer.close(fileByteOutputStream);
                        throw throwable;
                    }
                }
            }
            Closer.close(fileInputStream);
            Closer.close(fileByteOutputStream);
            return;
        }
        this.rootNode = new SimpleXML("configuration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public boolean save() {
        boolean bl;
        File configurationFilePath;
        Logger.getLogger(Configuration.class.getName()).log(Level.CONFIG, "Trying to save configuration to: " + (Object)((Object)this.configurationLocation));
        File configurationFile = new File(this.configurationLocator.getFile(this.configurationLocation));
        if (!(configurationFile.exists() || (configurationFilePath = configurationFile.getAbsoluteFile().getParentFile()).exists() || configurationFilePath.mkdirs())) {
            return false;
        }
        FileOutputStream fileOutputStream = null;
        ByteArrayInputStream configurationInputStream = null;
        try {
            byte[] configurationBytes = XML.transformToByteArray(this.rootNode.getDocument());
            configurationInputStream = new ByteArrayInputStream(configurationBytes);
            fileOutputStream = new FileOutputStream(configurationFile);
            StreamCopier.copy((InputStream)configurationInputStream, (OutputStream)fileOutputStream, configurationBytes.length);
            bl = true;
        }
        catch (IOException ioe1) {
            Closer.close(configurationInputStream);
            Closer.close(fileOutputStream);
            catch (Throwable throwable) {
                Closer.close(configurationInputStream);
                Closer.close(fileOutputStream);
                throw throwable;
            }
        }
        Closer.close(configurationInputStream);
        Closer.close(fileOutputStream);
        return bl;
        return false;
    }

    private String getNodeValue(String[] nodeNames, String defaultValue) {
        SimpleXML node;
        int nodeIndex = 0;
        for (node = this.rootNode; node != null && nodeIndex < nodeNames.length; node = node.getNode(nodeNames[nodeIndex++])) {
        }
        if (node == null) {
            return defaultValue;
        }
        return node.getValue();
    }

    private int getNodeIntValue(String[] nodeNames, int defaultValue) {
        try {
            return Integer.parseInt(this.getNodeValue(nodeNames, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private boolean getNodeBooleanValue(String[] nodeNames, boolean defaultValue) {
        String nodeValue = this.getNodeValue(nodeNames, null);
        if (nodeValue == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(nodeValue);
    }

    @Deprecated
    public String getNodeAddress() {
        return this.getNodeValue(new String[]{"node-address"}, "localhost");
    }

    @Deprecated
    public void setNodeAddress(String nodeAddress) {
        this.rootNode.replace("node-address", nodeAddress);
    }

    @Deprecated
    public int getNodePort() {
        return this.getNodeIntValue(new String[]{"node-port"}, 9481);
    }

    @Deprecated
    public void setNodePort(int nodePort) {
        this.rootNode.replace("node-port", String.valueOf(nodePort));
    }

    public boolean isSkipNodePage() {
        return this.getNodeBooleanValue(new String[]{"skip-node-page"}, false);
    }

    public void setSkipNodePage(boolean skipNodePage) {
        this.rootNode.replace("skip-node-page", String.valueOf(skipNodePage));
    }

    public Project[] getProjects() {
        ArrayList<Project> projects = new ArrayList<Project>();
        SimpleXML projectsNode = this.rootNode.getNode("project-list");
        if (projectsNode != null) {
            SimpleXML[] projectNodes;
            for (SimpleXML projectNode : projectNodes = projectsNode.getNodes("project")) {
                try {
                    SimpleXML fileOptionsNode;
                    Project project = new Project();
                    projects.add(project);
                    project.setDescription(projectNode.getValue("description", ""));
                    String indexFile = projectNode.getValue("index-file", "");
                    if (indexFile.indexOf(47) > -1) {
                        indexFile = "";
                    }
                    project.setIndexFile(indexFile);
                    project.setLastInsertionTime(Long.parseLong(projectNode.getValue("last-insertion-time", "0")));
                    project.setLocalPath(projectNode.getValue("local-path", ""));
                    project.setName(projectNode.getValue("name", ""));
                    project.setPath(projectNode.getValue("path", ""));
                    if (project.getPath() != null && project.getPath().indexOf("/") != -1) {
                        project.setPath(project.getPath().replaceAll("/", ""));
                    }
                    project.setEdition(Integer.parseInt(projectNode.getValue("edition", "0")));
                    project.setInsertURI(projectNode.getValue("insert-uri", ""));
                    project.setRequestURI(projectNode.getValue("request-uri", ""));
                    if (projectNode.getNode("ignore-hidden-files") != null) {
                        project.setIgnoreHiddenFiles(Boolean.parseBoolean(projectNode.getValue("ignore-hidden-files", "true")));
                    } else {
                        project.setIgnoreHiddenFiles(true);
                    }
                    project.setAlwaysForceInsert(Boolean.parseBoolean(projectNode.getValue("always-force-insert", "false")));
                    HashMap<String, FileOption> fileOptions = new HashMap<String, FileOption>();
                    SimpleXML lastInsertHashesNode = projectNode.getNode("last-insert-hashes");
                    if (lastInsertHashesNode != null) {
                        for (SimpleXML fileNode : lastInsertHashesNode.getNodes("file")) {
                            String filename = fileNode.getNode("filename").getValue();
                            String lastInsertHash = fileNode.getNode("last-insert-hash").getValue();
                            int lastInsertEdition = Integer.valueOf(fileNode.getNode("last-insert-edition").getValue());
                            String lastInsertFilename = filename;
                            if (fileNode.getNode("last-insert-filename") != null) {
                                lastInsertFilename = fileNode.getNode("last-insert-filename").getValue();
                            }
                            FileOption fileOption = project.getFileOption(filename);
                            fileOption.setLastInsertHash(lastInsertHash).setLastInsertEdition(lastInsertEdition).setLastInsertFilename(lastInsertFilename);
                            fileOptions.put(filename, fileOption);
                        }
                    }
                    if ((fileOptionsNode = projectNode.getNode("file-options")) != null) {
                        SimpleXML[] fileOptionNodes;
                        for (SimpleXML fileOptionNode : fileOptionNodes = fileOptionsNode.getNodes("file-option")) {
                            String filename = fileOptionNode.getNode("filename").getValue();
                            FileOption fileOption = project.getFileOption(filename);
                            fileOption.setInsert(Boolean.parseBoolean(fileOptionNode.getNode("insert").getValue()));
                            if (fileOptionNode.getNode("insert-redirect") != null) {
                                fileOption.setInsertRedirect(Boolean.parseBoolean(fileOptionNode.getNode("insert-redirect").getValue()));
                            }
                            fileOption.setCustomKey(fileOptionNode.getValue("custom-key", ""));
                            if (fileOptionNode.getNode("changed-name") != null) {
                                fileOption.setChangedName(fileOptionNode.getNode("changed-name").getValue());
                            }
                            fileOption.setMimeType(fileOptionNode.getValue("mime-type", ""));
                            fileOptions.put(filename, fileOption);
                        }
                    }
                    project.setFileOptions(fileOptions);
                }
                catch (NumberFormatException nfe1) {
                    nfe1.printStackTrace();
                }
            }
        }
        return projects.toArray(new Project[projects.size()]);
    }

    public void setProjects(Project[] projects) {
        SimpleXML projectsNode = new SimpleXML("project-list");
        for (Project project : projects) {
            SimpleXML projectNode = projectsNode.append("project");
            projectNode.append("edition", String.valueOf(project.getEdition()));
            projectNode.append("description", project.getDescription());
            projectNode.append("index-file", project.getIndexFile());
            projectNode.append("last-insertion-time", String.valueOf(project.getLastInsertionTime()));
            projectNode.append("local-path", project.getLocalPath());
            projectNode.append("name", project.getName());
            projectNode.append("path", project.getPath());
            projectNode.append("insert-uri", project.getInsertURI());
            projectNode.append("request-uri", project.getRequestURI());
            projectNode.append("ignore-hidden-files", String.valueOf(project.isIgnoreHiddenFiles()));
            projectNode.append("always-force-insert", String.valueOf(project.isAlwaysForceInsert()));
            SimpleXML lastInsertHashesNode = projectNode.append("last-insert-hashes");
            for (Map.Entry<String, FileOption> fileOption : project.getFileOptions().entrySet()) {
                if (fileOption.getValue().getLastInsertHash() == null || fileOption.getValue().getLastInsertHash().length() == 0) continue;
                SimpleXML fileNode = lastInsertHashesNode.append("file");
                fileNode.append("filename", fileOption.getKey());
                fileNode.append("last-insert-hash", fileOption.getValue().getLastInsertHash());
                fileNode.append("last-insert-edition", String.valueOf(fileOption.getValue().getLastInsertEdition()));
                fileNode.append("last-insert-filename", fileOption.getValue().getLastInsertFilename());
            }
            SimpleXML fileOptionsNode = projectNode.append("file-options");
            for (Map.Entry<String, FileOption> entry : project.getFileOptions().entrySet()) {
                FileOption fileOption = entry.getValue();
                if (!fileOption.isCustom()) continue;
                SimpleXML fileOptionNode = fileOptionsNode.append("file-option");
                fileOptionNode.append("filename", entry.getKey());
                fileOptionNode.append("insert", String.valueOf(fileOption.isInsert()));
                fileOptionNode.append("insert-redirect", String.valueOf(fileOption.isInsertRedirect()));
                fileOptionNode.append("custom-key", fileOption.getCustomKey());
                fileOptionNode.append("changed-name", fileOption.getChangedName());
                fileOptionNode.append("mime-type", fileOption.getMimeType());
            }
        }
        this.rootNode.replace(projectsNode);
    }

    public Locale getLocale() {
        String language = this.getNodeValue(new String[]{"i18n", "language"}, "en");
        String country = this.getNodeValue(new String[]{"i18n", "country"}, null);
        if (country != null) {
            return new Locale(language, country);
        }
        return new Locale(language);
    }

    public void setLocale(Locale locale) {
        SimpleXML i18nNode = new SimpleXML("i18n");
        if (locale.getCountry().length() != 0) {
            i18nNode.append("country", locale.getCountry());
        }
        i18nNode.append("language", locale.getLanguage());
        this.rootNode.replace(i18nNode);
    }

    public Node[] getNodes() {
        SimpleXML nodesNode = this.rootNode.getNode("nodes");
        if (nodesNode == null) {
            String hostname = this.getNodeAddress();
            int port = this.getNodePort();
            if (hostname == null) {
                hostname = "127.0.0.1";
                port = 9481;
            }
            return new Node[]{new Node(hostname, port, "Node")};
        }
        SimpleXML[] nodeNodes = nodesNode.getNodes("node");
        Node[] returnNodes = new Node[nodeNodes.length];
        int nodeIndex = 0;
        for (SimpleXML nodeNode : nodeNodes) {
            String name = nodeNode.getNode("name").getValue();
            String hostname = nodeNode.getNode("hostname").getValue();
            int port = Integer.parseInt(nodeNode.getNode("port").getValue());
            Node node = new Node(hostname, port, name);
            returnNodes[nodeIndex++] = node;
        }
        return returnNodes;
    }

    public void setNodes(Node[] nodes) {
        SimpleXML nodesNode = new SimpleXML("nodes");
        for (Node node : nodes) {
            SimpleXML nodeNode = nodesNode.append("node");
            nodeNode.append("name", node.getName());
            nodeNode.append("hostname", node.getHostname());
            nodeNode.append("port", String.valueOf(node.getPort()));
        }
        this.rootNode.replace(nodesNode);
        this.rootNode.remove("node-address");
        this.rootNode.remove("node-port");
    }

    public void setSelectedNode(Node selectedNode) {
        SimpleXML selectedNodeNode = new SimpleXML("selected-node");
        selectedNodeNode.append("name", selectedNode.getName());
        selectedNodeNode.append("hostname", selectedNode.getHostname());
        selectedNodeNode.append("port", String.valueOf(selectedNode.getPort()));
        this.rootNode.replace(selectedNodeNode);
    }

    public Node getSelectedNode() {
        SimpleXML selectedNodeNode = this.rootNode.getNode("selected-node");
        if (selectedNodeNode == null) {
            String hostname = this.getNodeAddress();
            int port = this.getNodePort();
            if (hostname == null) {
                hostname = "127.0.0.1";
                port = 9481;
            }
            return new Node(hostname, port, "Node");
        }
        String name = selectedNodeNode.getNode("name").getValue();
        String hostname = selectedNodeNode.getNode("hostname").getValue();
        int port = Integer.valueOf(selectedNodeNode.getNode("port").getValue());
        return new Node(hostname, port, name);
    }

    public String getTempDirectory() {
        return this.getNodeValue(new String[]{"temp-directory"}, null);
    }

    public void setTempDirectory(String tempDirectory) {
        if (tempDirectory != null) {
            SimpleXML tempDirectoryNode = new SimpleXML("temp-directory");
            tempDirectoryNode.setValue(tempDirectory);
            this.rootNode.replace(tempDirectoryNode);
        } else {
            this.rootNode.remove("temp-directory");
        }
    }

    public boolean useEarlyEncode() {
        return this.getNodeBooleanValue(new String[]{"use-early-encode"}, false);
    }

    public Configuration setUseEarlyEncode(boolean useEarlyEncode) {
        this.rootNode.replace("use-early-encode", String.valueOf(useEarlyEncode));
        return this;
    }

    public PriorityClass getPriority() {
        return PriorityClass.valueOf(this.getNodeValue(new String[]{"insert-priority"}, "interactive"));
    }

    public Configuration setPriority(PriorityClass priority) {
        this.rootNode.replace("insert-priority", priority.toString());
        return this;
    }

    public ClientPutDir.ManifestPutter getManifestPutter() {
        return ClientPutDir.ManifestPutter.valueOf(this.getNodeValue(new String[]{"manifest-putter"}, "simple").toUpperCase());
    }

    public Configuration setManifestPutter(ClientPutDir.ManifestPutter manifestPutter) {
        this.rootNode.replace("manifest-putter", manifestPutter.name().toLowerCase());
        return this;
    }
}

