/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.main;

import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.Node;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.application.ProjectInserter;
import de.todesbaum.jsite.application.UpdateChecker;
import de.todesbaum.jsite.application.UpdateListener;
import de.todesbaum.jsite.application.WebOfTrustInterface;
import de.todesbaum.jsite.gui.NodeManagerListener;
import de.todesbaum.jsite.gui.NodeManagerPage;
import de.todesbaum.jsite.gui.PreferencesPage;
import de.todesbaum.jsite.gui.ProjectFilesPage;
import de.todesbaum.jsite.gui.ProjectInsertPage;
import de.todesbaum.jsite.gui.ProjectPage;
import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import de.todesbaum.jsite.main.Configuration;
import de.todesbaum.jsite.main.ConfigurationLocator;
import de.todesbaum.jsite.main.Version;
import de.todesbaum.util.swing.TWizard;
import de.todesbaum.util.swing.TWizardPage;
import de.todesbaum.util.swing.WizardListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.pterodactylus.util.image.IconLoader;

public class Main
implements ActionListener,
ListSelectionListener,
WizardListener,
NodeManagerListener,
UpdateListener {
    private static final Logger logger = Logger.getLogger(Main.class.getName());
    private static final Version VERSION = new Version(0, 11);
    private Configuration configuration;
    private Freenet7Interface freenetInterface = new Freenet7Interface();
    private final UpdateChecker updateChecker;
    private final WebOfTrustInterface webOfTrustInterface;
    private Icon jSiteIcon;
    private static final Locale[] SUPPORTED_LOCALES = new Locale[]{Locale.ENGLISH, Locale.GERMAN, Locale.FRENCH};
    private Map<Locale, Action> languageActions = new HashMap<Locale, Action>();
    private Action manageNodeAction;
    private Action optionsPreferencesAction;
    private Action checkForUpdatesAction;
    private Action aboutAction;
    private TWizard wizard;
    private JMenu nodeMenu;
    private Node selectedNode;
    private final Map<PageType, TWizardPage> pages = new HashMap<PageType, TWizardPage>();
    private ConfigurationLocator.ConfigurationLocation originalLocation;

    private Main() {
        this(null);
    }

    private Main(String configFilename) {
        ConfigurationLocator configurationLocator = new ConfigurationLocator();
        if (configFilename != null) {
            configurationLocator.setCustomLocation(configFilename);
        }
        this.originalLocation = configurationLocator.findPreferredLocation();
        logger.log(Level.CONFIG, "Using configuration from " + (Object)((Object)this.originalLocation) + ".");
        this.configuration = new Configuration(configurationLocator, this.originalLocation);
        Locale.setDefault(this.configuration.getLocale());
        I18n.setLocale(this.configuration.getLocale());
        this.wizard = new TWizard();
        this.createActions();
        this.wizard.setJMenuBar(this.createMenuBar());
        this.wizard.setQuitName(I18n.getMessage("jsite.wizard.quit"));
        this.wizard.setPreviousEnabled(false);
        this.wizard.setNextEnabled(true);
        this.wizard.addWizardListener(this);
        this.jSiteIcon = IconLoader.loadIcon("/jsite-icon.png");
        this.wizard.setIcon(this.jSiteIcon);
        this.updateChecker = new UpdateChecker(this.freenetInterface);
        this.updateChecker.addUpdateListener(this);
        this.updateChecker.start();
        this.webOfTrustInterface = new WebOfTrustInterface(this.freenetInterface);
        this.webOfTrustInterface.start();
        this.initPages();
        this.showPage(PageType.PAGE_PROJECTS);
    }

    private void createActions() {
        for (final Locale locale : SUPPORTED_LOCALES) {
            this.languageActions.put(locale, new AbstractAction(I18n.getMessage("jsite.menu.language." + locale.getLanguage()), IconLoader.loadIcon("/flag-" + locale.getLanguage() + ".png")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Main.this.switchLanguage(locale);
                }
            });
        }
        this.manageNodeAction = new AbstractAction(I18n.getMessage("jsite.menu.nodes.manage-nodes")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.showPage(PageType.PAGE_NODE_MANAGER);
                Main.this.optionsPreferencesAction.setEnabled(true);
                Main.this.wizard.setPreviousName(I18n.getMessage("jsite.wizard.previous"));
                Main.this.wizard.setNextName(I18n.getMessage("jsite.wizard.next"));
            }
        };
        this.optionsPreferencesAction = new AbstractAction(I18n.getMessage("jsite.menu.options.preferences")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.optionsPreferences();
            }
        };
        this.checkForUpdatesAction = new AbstractAction(I18n.getMessage("jsite.menu.help.check-for-updates")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.showLatestUpdate();
            }
        };
        this.aboutAction = new AbstractAction(I18n.getMessage("jsite.menu.help.about")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(Main.this.wizard, MessageFormat.format(I18n.getMessage("jsite.about.message"), Main.getVersion().toString()), null, 1, Main.this.jSiteIcon);
            }
        };
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                Main.this.manageNodeAction.putValue("Name", I18n.getMessage("jsite.menu.nodes.manage-nodes"));
                Main.this.optionsPreferencesAction.putValue("Name", I18n.getMessage("jsite.menu.options.preferences"));
                Main.this.checkForUpdatesAction.putValue("Name", I18n.getMessage("jsite.menu.help.check-for-updates"));
                Main.this.aboutAction.putValue("Name", I18n.getMessage("jsite.menu.help.about"));
            }
        });
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        final JMenu languageMenu = new JMenu(I18n.getMessage("jsite.menu.languages"));
        menuBar.add(languageMenu);
        ButtonGroup languageButtonGroup = new ButtonGroup();
        for (Locale locale : SUPPORTED_LOCALES) {
            Action languageAction = this.languageActions.get(locale);
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(this.languageActions.get(locale));
            if (locale.equals(Locale.getDefault())) {
                menuItem.setSelected(true);
            }
            languageAction.putValue("menuItem", menuItem);
            languageButtonGroup.add(menuItem);
            languageMenu.add(menuItem);
        }
        this.nodeMenu = new JMenu(I18n.getMessage("jsite.menu.nodes"));
        menuBar.add(this.nodeMenu);
        this.selectedNode = this.configuration.getSelectedNode();
        this.nodesUpdated(this.configuration.getNodes());
        final JMenu optionsMenu = new JMenu(I18n.getMessage("jsite.menu.options"));
        menuBar.add(optionsMenu);
        optionsMenu.add(this.optionsPreferencesAction);
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        menuBar.add(panel);
        final JMenu helpMenu = new JMenu(I18n.getMessage("jsite.menu.help"));
        menuBar.add(helpMenu);
        helpMenu.add(this.checkForUpdatesAction);
        helpMenu.add(this.aboutAction);
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                languageMenu.setText(I18n.getMessage("jsite.menu.languages"));
                Main.this.nodeMenu.setText(I18n.getMessage("jsite.menu.nodes"));
                optionsMenu.setText(I18n.getMessage("jsite.menu.options"));
                helpMenu.setText(I18n.getMessage("jsite.menu.help"));
                for (Map.Entry languageActionEntry : Main.this.languageActions.entrySet()) {
                    ((Action)languageActionEntry.getValue()).putValue("Name", I18n.getMessage("jsite.menu.language." + ((Locale)languageActionEntry.getKey()).getLanguage()));
                }
            }
        });
        return menuBar;
    }

    private void initPages() {
        NodeManagerPage nodeManagerPage = new NodeManagerPage(this.wizard);
        nodeManagerPage.setName("page.node-manager");
        nodeManagerPage.addNodeManagerListener(this);
        nodeManagerPage.setNodes(this.configuration.getNodes());
        this.pages.put(PageType.PAGE_NODE_MANAGER, nodeManagerPage);
        ProjectPage projectPage = new ProjectPage(this.wizard);
        projectPage.setName("page.project");
        projectPage.setProjects(this.configuration.getProjects());
        projectPage.setFreenetInterface(this.freenetInterface);
        projectPage.setWebOfTrustInterface(this.webOfTrustInterface);
        projectPage.addListSelectionListener(this);
        this.pages.put(PageType.PAGE_PROJECTS, projectPage);
        ProjectFilesPage projectFilesPage = new ProjectFilesPage(this.wizard);
        projectFilesPage.setName("page.project.files");
        this.pages.put(PageType.PAGE_PROJECT_FILES, projectFilesPage);
        ProjectInsertPage projectInsertPage = new ProjectInsertPage(this.wizard);
        projectInsertPage.setName("page.project.insert");
        projectInsertPage.setFreenetInterface(this.freenetInterface);
        this.pages.put(PageType.PAGE_INSERT_PROJECT, projectInsertPage);
        PreferencesPage preferencesPage = new PreferencesPage(this.wizard);
        preferencesPage.setName("page.preferences");
        preferencesPage.setTempDirectory(this.configuration.getTempDirectory());
        this.pages.put(PageType.PAGE_PREFERENCES, preferencesPage);
    }

    private void showPage(PageType pageType) {
        this.wizard.setPreviousEnabled(pageType.ordinal() > 0);
        this.wizard.setNextEnabled(pageType.ordinal() < this.pages.size() - 1);
        this.wizard.setPage(this.pages.get((Object)pageType));
        this.wizard.setTitle(this.pages.get((Object)pageType).getHeading() + " - jSite");
    }

    private boolean isOverwritingConfiguration() {
        return this.configuration.getConfigurationLocator().hasFile(this.configuration.getConfigurationDirectory());
    }

    private boolean saveConfiguration() {
        NodeManagerPage nodeManagerPage = (NodeManagerPage)this.pages.get((Object)PageType.PAGE_NODE_MANAGER);
        this.configuration.setNodes(nodeManagerPage.getNodes());
        if (this.selectedNode != null) {
            this.configuration.setSelectedNode(this.selectedNode);
        }
        ProjectPage projectPage = (ProjectPage)this.pages.get((Object)PageType.PAGE_PROJECTS);
        this.configuration.setProjects(projectPage.getProjects());
        PreferencesPage preferencesPage = (PreferencesPage)this.pages.get((Object)PageType.PAGE_PREFERENCES);
        this.configuration.setTempDirectory(preferencesPage.getTempDirectory());
        return this.configuration.save();
    }

    private static Locale findSupportedLocale(Locale forLocale) {
        for (Locale locale : SUPPORTED_LOCALES) {
            if (!locale.equals(forLocale)) continue;
            return locale;
        }
        for (Locale locale : SUPPORTED_LOCALES) {
            if (!locale.getCountry().equals(forLocale.getCountry()) || !locale.getLanguage().equals(forLocale.getLanguage())) continue;
            return locale;
        }
        for (Locale locale : SUPPORTED_LOCALES) {
            if (!locale.getLanguage().equals(forLocale.getLanguage())) continue;
            return locale;
        }
        return SUPPORTED_LOCALES[0];
    }

    public static final Version getVersion() {
        return VERSION;
    }

    private void switchLanguage(Locale locale) {
        Locale supportedLocale = Main.findSupportedLocale(locale);
        Action languageAction = this.languageActions.get(supportedLocale);
        JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem)languageAction.getValue("menuItem");
        menuItem.setSelected(true);
        I18n.setLocale(supportedLocale);
        for (Runnable i18nRunnable : I18nContainer.getInstance()) {
            try {
                i18nRunnable.run();
            }
            catch (Throwable t) {}
        }
        this.wizard.setPage(this.wizard.getPage());
        this.configuration.setLocale(supportedLocale);
    }

    private void optionsPreferences() {
        ((PreferencesPage)this.pages.get((Object)PageType.PAGE_PREFERENCES)).setConfigurationLocation(this.configuration.getConfigurationDirectory());
        ((PreferencesPage)this.pages.get((Object)PageType.PAGE_PREFERENCES)).setHasNextToJarConfiguration(this.configuration.getConfigurationLocator().isValidLocation(ConfigurationLocator.ConfigurationLocation.NEXT_TO_JAR_FILE));
        ((PreferencesPage)this.pages.get((Object)PageType.PAGE_PREFERENCES)).setHasCustomConfiguration(this.configuration.getConfigurationLocator().isValidLocation(ConfigurationLocator.ConfigurationLocation.CUSTOM));
        ((PreferencesPage)this.pages.get((Object)PageType.PAGE_PREFERENCES)).setUseEarlyEncode(this.configuration.useEarlyEncode());
        ((PreferencesPage)this.pages.get((Object)PageType.PAGE_PREFERENCES)).setPriority(this.configuration.getPriority());
        ((PreferencesPage)this.pages.get((Object)PageType.PAGE_PREFERENCES)).setManifestPutter(this.configuration.getManifestPutter());
        this.showPage(PageType.PAGE_PREFERENCES);
        this.optionsPreferencesAction.setEnabled(false);
        this.wizard.setNextEnabled(true);
        this.wizard.setNextName(I18n.getMessage("jsite.wizard.next"));
    }

    private void showLatestUpdate() {
        Version latestVersion = this.updateChecker.getLatestVersion();
        int versionDifference = latestVersion.compareTo(VERSION);
        if (versionDifference > 0) {
            JOptionPane.showMessageDialog(this.wizard, MessageFormat.format(I18n.getMessage("jsite.update-checker.latest-version.newer.message"), VERSION, latestVersion), I18n.getMessage("jsite.update-checker.latest-version.title"), 1);
        } else if (versionDifference < 0) {
            JOptionPane.showMessageDialog(this.wizard, MessageFormat.format(I18n.getMessage("jsite.update-checker.latest-version.older.message"), VERSION, latestVersion), I18n.getMessage("jsite.update-checker.latest-version.title"), 1);
        } else {
            JOptionPane.showMessageDialog(this.wizard, MessageFormat.format(I18n.getMessage("jsite.update-checker.latest-version.okay.message"), VERSION, latestVersion), I18n.getMessage("jsite.update-checker.latest-version.title"), 1);
        }
    }

    private void quit() {
        this.updateChecker.stop();
        this.webOfTrustInterface.stop();
        System.exit(0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        JList list = (JList)e.getSource();
        int selectedRow = list.getSelectedIndex();
        this.wizard.setNextEnabled(selectedRow > -1);
    }

    @Override
    public void wizardNextPressed(TWizard wizard) {
        String pageName = wizard.getPage().getName();
        if ("page.node-manager".equals(pageName)) {
            this.showPage(PageType.PAGE_PROJECTS);
        } else if ("page.project".equals(pageName)) {
            ProjectPage projectPage = (ProjectPage)wizard.getPage();
            Project project = projectPage.getSelectedProject();
            if (project.getLocalPath() == null || project.getLocalPath().trim().length() == 0) {
                JOptionPane.showMessageDialog(wizard, I18n.getMessage("jsite.warning.no-local-path"), null, 0);
                return;
            }
            if (project.getPath() == null || project.getPath().trim().length() == 0) {
                JOptionPane.showMessageDialog(wizard, I18n.getMessage("jsite.warning.no-path"), null, 0);
                return;
            }
            ((ProjectFilesPage)this.pages.get((Object)PageType.PAGE_PROJECT_FILES)).setProject(project);
            ((ProjectInsertPage)this.pages.get((Object)PageType.PAGE_INSERT_PROJECT)).setProject(project);
            this.showPage(PageType.PAGE_PROJECT_FILES);
        } else if ("page.project.files".equals(pageName)) {
            ProjectPage projectPage = (ProjectPage)this.pages.get((Object)PageType.PAGE_PROJECTS);
            Project project = projectPage.getSelectedProject();
            if (this.selectedNode == null) {
                JOptionPane.showMessageDialog(wizard, I18n.getMessage("jsite.error.no-node-selected"), null, 0);
                return;
            }
            ProjectInserter.CheckReport checkReport = ProjectInserter.validateProject(project);
            for (ProjectInserter.Issue issue : checkReport) {
                if (issue.isFatal()) {
                    JOptionPane.showMessageDialog(wizard, MessageFormat.format(I18n.getMessage("jsite." + issue.getErrorKey()), issue.getParameters()), null, 0);
                    return;
                }
                if (JOptionPane.showConfirmDialog(wizard, MessageFormat.format(I18n.getMessage("jsite." + issue.getErrorKey()), issue.getParameters()), null, 2, 2) == 0) continue;
                return;
            }
            boolean nodeRunning = false;
            try {
                nodeRunning = this.freenetInterface.isNodePresent();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (!nodeRunning) {
                JOptionPane.showMessageDialog(wizard, I18n.getMessage("jsite.error.no-node-running"), null, 0);
                return;
            }
            this.configuration.save();
            this.showPage(PageType.PAGE_INSERT_PROJECT);
            ProjectInsertPage projectInsertPage = (ProjectInsertPage)this.pages.get((Object)PageType.PAGE_INSERT_PROJECT);
            String tempDirectory = ((PreferencesPage)this.pages.get((Object)PageType.PAGE_PREFERENCES)).getTempDirectory();
            projectInsertPage.setTempDirectory(tempDirectory);
            projectInsertPage.setUseEarlyEncode(this.configuration.useEarlyEncode());
            projectInsertPage.setPriority(this.configuration.getPriority());
            projectInsertPage.setManifestPutter(this.configuration.getManifestPutter());
            projectInsertPage.startInsert();
            this.nodeMenu.setEnabled(false);
            this.optionsPreferencesAction.setEnabled(false);
        } else if ("page.project.insert".equals(pageName)) {
            ProjectInsertPage projectInsertPage = (ProjectInsertPage)this.pages.get((Object)PageType.PAGE_INSERT_PROJECT);
            if (projectInsertPage.isRunning()) {
                projectInsertPage.stopInsert();
            } else {
                this.showPage(PageType.PAGE_PROJECTS);
                this.nodeMenu.setEnabled(true);
                this.optionsPreferencesAction.setEnabled(true);
            }
        } else if ("page.preferences".equals(pageName)) {
            PreferencesPage preferencesPage = (PreferencesPage)this.pages.get((Object)PageType.PAGE_PREFERENCES);
            this.showPage(PageType.PAGE_PROJECTS);
            this.optionsPreferencesAction.setEnabled(true);
            this.configuration.setUseEarlyEncode(preferencesPage.useEarlyEncode());
            this.configuration.setPriority(preferencesPage.getPriority());
            this.configuration.setManifestPutter(preferencesPage.getManifestPutter());
            this.configuration.setConfigurationLocation(preferencesPage.getConfigurationLocation());
        }
    }

    @Override
    public void wizardPreviousPressed(TWizard wizard) {
        String pageName = wizard.getPage().getName();
        if ("page.project".equals(pageName) || "page.preferences".equals(pageName)) {
            this.showPage(PageType.PAGE_NODE_MANAGER);
            this.optionsPreferencesAction.setEnabled(true);
        } else if ("page.project.files".equals(pageName)) {
            this.showPage(PageType.PAGE_PROJECTS);
        } else if ("page.project.insert".equals(pageName)) {
            this.showPage(PageType.PAGE_PROJECT_FILES);
        }
    }

    @Override
    public void wizardQuitPressed(TWizard wizard) {
        if (((ProjectPage)this.pages.get((Object)PageType.PAGE_PROJECTS)).wasUriCopied() || ((ProjectInsertPage)this.pages.get((Object)PageType.PAGE_INSERT_PROJECT)).wasUriCopied()) {
            JOptionPane.showMessageDialog(wizard, I18n.getMessage("jsite.project.warning.use-clipboard-now"));
        }
        if (JOptionPane.showConfirmDialog(wizard, I18n.getMessage("jsite.quit.question"), I18n.getMessage("jsite.quit.question.title"), 2, 3) == 0) {
            if (this.isOverwritingConfiguration() && !this.originalLocation.equals((Object)this.configuration.getConfigurationDirectory())) {
                int overwriteConfigurationAnswer = JOptionPane.showConfirmDialog(wizard, MessageFormat.format(I18n.getMessage("jsite.quit.overwrite-configuration"), this.configuration.getConfigurationLocator().getFile(this.configuration.getConfigurationDirectory())), I18n.getMessage("jsite.quit.overwrite-configuration.title"), 1, 2);
                if (overwriteConfigurationAnswer == 0) {
                    if (this.saveConfiguration()) {
                        this.quit();
                    }
                } else if (overwriteConfigurationAnswer == 2) {
                    return;
                }
                if (overwriteConfigurationAnswer == 1) {
                    this.quit();
                }
            } else if (this.saveConfiguration()) {
                this.quit();
            }
            if (JOptionPane.showConfirmDialog(wizard, I18n.getMessage("jsite.quit.config-not-saved"), null, 2, 2) == 0) {
                this.quit();
            }
        }
    }

    @Override
    public void nodesUpdated(Node[] nodes) {
        this.nodeMenu.removeAll();
        ButtonGroup nodeButtonGroup = new ButtonGroup();
        Node newSelectedNode = null;
        for (Node node : nodes) {
            JRadioButtonMenuItem nodeMenuItem = new JRadioButtonMenuItem(node.getName());
            nodeMenuItem.putClientProperty("Node", node);
            nodeMenuItem.addActionListener(this);
            nodeButtonGroup.add(nodeMenuItem);
            if (node.equals(this.selectedNode)) {
                newSelectedNode = node;
                nodeMenuItem.setSelected(true);
            }
            this.nodeMenu.add(nodeMenuItem);
        }
        this.nodeMenu.addSeparator();
        this.nodeMenu.add(this.manageNodeAction);
        this.selectedNode = newSelectedNode;
        this.freenetInterface.setNode(this.selectedNode);
    }

    @Override
    public void nodeSelected(Node node) {
        for (Component menuItem : this.nodeMenu.getMenuComponents()) {
            if (!(menuItem instanceof JMenuItem) || !node.equals(((JMenuItem)menuItem).getClientProperty("Node"))) continue;
            ((JMenuItem)menuItem).setSelected(true);
        }
        this.freenetInterface.setNode(node);
        this.selectedNode = node;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JRadioButtonMenuItem) {
            Node node;
            JRadioButtonMenuItem menuItem = (JRadioButtonMenuItem)source;
            this.selectedNode = node = (Node)menuItem.getClientProperty("Node");
            this.freenetInterface.setNode(this.selectedNode);
        }
    }

    @Override
    public void foundUpdateData(Version foundVersion, long versionTimestamp) {
        logger.log(Level.FINEST, "Found version {0} from {1,date}.", new Object[]{foundVersion, versionTimestamp});
        if (foundVersion.compareTo(VERSION) > 0) {
            JOptionPane.showMessageDialog(this.wizard, MessageFormat.format(I18n.getMessage("jsite.update-checker.found-version.message"), foundVersion.toString(), new Date(versionTimestamp)), I18n.getMessage("jsite.update-checker.found-version.title"), 1);
        }
    }

    public static void main(String[] args) {
        Logger logger = Logger.getLogger("de.todesbaum");
        ConsoleHandler handler = new ConsoleHandler();
        logger.addHandler(handler);
        String configFilename = null;
        boolean nextIsConfigFilename = false;
        for (String argument : args) {
            if (nextIsConfigFilename) {
                configFilename = argument;
                nextIsConfigFilename = false;
            }
            if ("--help".equals(argument)) {
                Main.printHelp();
                return;
            }
            if ("--debug".equals(argument)) {
                logger.setLevel(Level.ALL);
                handler.setLevel(Level.ALL);
                continue;
            }
            if (!"--config-file".equals(argument)) continue;
            nextIsConfigFilename = true;
        }
        if (nextIsConfigFilename) {
            System.out.println("--config-file needs parameter!");
            return;
        }
        new Main(configFilename);
    }

    private static void printHelp() {
        System.out.println("--help\tshows this cruft");
        System.out.println("--debug\tenables some debug output");
        System.out.println("--config-file <file>\tuse specified configuration file");
    }

    private static enum PageType {
        PAGE_NODE_MANAGER,
        PAGE_PROJECTS,
        PAGE_PROJECT_FILES,
        PAGE_INSERT_PROJECT,
        PAGE_PREFERENCES;

    }
}

