/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.util.freenet.fcp2;

import de.todesbaum.util.freenet.fcp2.Command;
import de.todesbaum.util.freenet.fcp2.Connection;
import de.todesbaum.util.freenet.fcp2.ConnectionListener;
import de.todesbaum.util.freenet.fcp2.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.pterodactylus.util.io.StreamCopier;

public class Client
implements ConnectionListener {
    private final Connection connection;
    private List<String> identifiers = new ArrayList<String>();
    private final List<Message> messageQueue = new ArrayList<Message>();
    private boolean disconnected = false;
    private boolean catchAll = false;

    public Client(Connection connection) {
        this.connection = connection;
        connection.addConnectionListener(this);
    }

    public Client(Connection connection, Command command) throws IOException {
        this(connection);
        this.execute(command);
    }

    public boolean isCatchAll() {
        return this.catchAll;
    }

    public void setCatchAll(boolean catchAll) {
        this.catchAll = catchAll;
    }

    public void execute(Command command) throws IOException {
        this.execute(command, true);
    }

    public void execute(Command command, StreamCopier.ProgressListener progressListener) throws IOException {
        this.execute(command, true, progressListener);
    }

    public void execute(Command command, boolean removeExistingIdentifiers) throws IOException {
        this.execute(command, removeExistingIdentifiers, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command, boolean removeExistingIdentifiers, StreamCopier.ProgressListener progressListener) throws IOException {
        List<Message> list = this.messageQueue;
        synchronized (list) {
            this.messageQueue.clear();
            if (removeExistingIdentifiers) {
                this.identifiers.clear();
            }
            this.identifiers.add(command.getIdentifier());
        }
        this.connection.execute(command, progressListener);
    }

    public Message readMessage() {
        return this.readMessage(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message readMessage(long maxWaitTime) {
        List<Message> list = this.messageQueue;
        synchronized (list) {
            if (this.disconnected) {
                return null;
            }
            if (this.messageQueue.size() == 0) {
                try {
                    this.messageQueue.wait(maxWaitTime);
                }
                catch (InterruptedException ie1) {
                    // empty catch block
                }
            }
            if (this.messageQueue.size() > 0) {
                return this.messageQueue.remove(0);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnected() {
        List<Message> list = this.messageQueue;
        synchronized (list) {
            return this.disconnected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(Connection connection, Message message) {
        List<Message> list = this.messageQueue;
        synchronized (list) {
            if (this.catchAll || message.getIdentifier().length() == 0 || this.identifiers.contains(message.getIdentifier())) {
                this.messageQueue.add(message);
                this.messageQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionTerminated(Connection connection) {
        List<Message> list = this.messageQueue;
        synchronized (list) {
            this.disconnected = true;
            this.messageQueue.notify();
        }
    }
}

