/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.util.freenet.fcp2;

import de.todesbaum.util.freenet.fcp2.Command;
import de.todesbaum.util.freenet.fcp2.Persistence;
import de.todesbaum.util.freenet.fcp2.PriorityClass;
import de.todesbaum.util.freenet.fcp2.ReturnType;
import de.todesbaum.util.freenet.fcp2.Verbosity;
import java.io.IOException;
import java.io.Writer;

public class ClientGet
extends Command {
    private boolean ignoreDataStore;
    private boolean dataStoreOnly;
    private String uri;
    private Verbosity verbosity = Verbosity.NONE;
    private long maxSize = -1L;
    private long maxTempSize = -1L;
    private int maxRetries = -1;
    private PriorityClass priorityClass = PriorityClass.INTERACTIVE;
    private Persistence persistence = Persistence.CONNECTION;
    private String clientToken;
    private boolean global = false;
    private ReturnType returnType = ReturnType.direct;
    private boolean binaryBlob = false;
    private String allowedMimeTypes = null;
    private String filename = null;
    private String tempFilename = null;

    public ClientGet(String identifier) {
        super("ClientGet", identifier);
    }

    public boolean isIgnoreDataStore() {
        return this.ignoreDataStore;
    }

    public void setIgnoreDataStore(boolean ignoreDataStore) {
        this.ignoreDataStore = ignoreDataStore;
    }

    public boolean isDataStoreOnly() {
        return this.dataStoreOnly;
    }

    public void setDataStoreOnly(boolean dataStoreOnly) {
        this.dataStoreOnly = dataStoreOnly;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Verbosity getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(Verbosity verbosity) {
        this.verbosity = verbosity;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public long getMaxTempSize() {
        return this.maxTempSize;
    }

    public void setMaxTempSize(long maxTempSize) {
        this.maxTempSize = maxTempSize;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public PriorityClass getPriorityClass() {
        return this.priorityClass;
    }

    public void setPriorityClass(PriorityClass priorityClass) {
        this.priorityClass = priorityClass;
    }

    public Persistence getPersistence() {
        return this.persistence;
    }

    public void setPersistence(Persistence persistence) {
        this.persistence = persistence;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public ReturnType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ReturnType returnType) {
        this.returnType = returnType;
    }

    public boolean isBinaryBlob() {
        return this.binaryBlob;
    }

    public void setBinaryBlob(boolean binaryBlob) {
        this.binaryBlob = binaryBlob;
    }

    public String getAllowedMimeTypes() {
        return this.allowedMimeTypes;
    }

    public void setAllowedMimeTypes(String allowedMimeTypes) {
        this.allowedMimeTypes = allowedMimeTypes;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getTempFilename() {
        return this.tempFilename;
    }

    public void setTempFilename(String tempFilename) {
        this.tempFilename = tempFilename;
    }

    @Override
    protected void write(Writer writer) throws IOException {
        super.write(writer);
        writer.write("IgnoreDS=" + this.ignoreDataStore + "\r\n");
        writer.write("DSonly=" + this.dataStoreOnly + "\r\n");
        writer.write("URI=" + this.uri + "\r\n");
        writer.write("Verbosity=" + this.verbosity.getValue() + "\r\n");
        if (this.maxSize > -1L) {
            writer.write("MaxSize=" + this.maxSize + "\r\n");
        }
        if (this.maxTempSize > -1L) {
            writer.write("MaxTempSize=" + this.maxTempSize + "\r\n");
        }
        if (this.maxRetries >= -1) {
            writer.write("MaxRetries=" + this.maxRetries + "\r\n");
        }
        writer.write("PriorityClass=" + this.priorityClass.getValue() + "\r\n");
        writer.write("Persistence=" + this.persistence.getName() + "\r\n");
        if (this.clientToken != null) {
            writer.write("ClientToken=" + this.clientToken + "\r\n");
        }
        writer.write("Global=" + this.global + "\r\n");
        writer.write("BinaryBlob=" + this.binaryBlob + "\r\n");
        if (this.allowedMimeTypes != null) {
            writer.write("AllowedMIMETypes=" + this.allowedMimeTypes + "\r\n");
        }
        if (this.returnType == ReturnType.disk) {
            writer.write("Filename=" + this.filename + "\r\n");
            if (this.tempFilename != null) {
                writer.write("TempFilename=" + this.tempFilename + "\r\n");
            }
        }
    }
}

