/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.collection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.logging.Logging;
import net.pterodactylus.util.number.Hex;

public class MapWriter {
    private static final Logger logger = Logging.getLogger(MapWriter.class.getName());

    public static void write(Writer writer, Map<String, String> map) throws IOException {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getValue() == null) continue;
            writer.write(MapWriter.encode(entry.getKey()));
            writer.write(61);
            writer.write(MapWriter.encode(entry.getValue()));
            writer.write(10);
        }
    }

    public static Map<String, String> read(Reader reader) throws IOException {
        logger.log(Level.FINE, "MapWriter.read(reader=" + reader + ")");
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                logger.log(Level.FINEST, "Read line: \u201c" + line + "\u201d");
                if (line.startsWith("#") || line.length() == 0) continue;
                if (line.indexOf(61) == -1) {
                    break;
                }
                int split = line.indexOf(61);
                String key = MapWriter.decode(line.substring(0, split));
                String value = MapWriter.decode(line.substring(split + 1));
                map.put(key, value);
            }
        }
        finally {
            Closer.close(bufferedReader);
        }
        return map;
    }

    static String encode(String value) {
        StringBuilder encodedString = new StringBuilder();
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char character = cArray[n2];
            if (character == '\r') {
                encodedString.append("\\r");
            } else if (character == '\n') {
                encodedString.append("\\n");
            } else if (character == '\\') {
                encodedString.append("\\\\");
            } else if (character < ' ' || character == '=' || character > '\u007f') {
                encodedString.append("\\u").append(Hex.toHex(character, 4));
            } else {
                encodedString.append(character);
            }
            ++n2;
        }
        return encodedString.toString();
    }

    static String decode(String value) {
        StringBuilder decodedString = new StringBuilder();
        boolean backslash = false;
        int hexDigit = 0;
        char[] hexDigits = new char[4];
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char character = cArray[n2];
            if (hexDigit > 0) {
                hexDigits[hexDigit - 1] = character;
                if (++hexDigit > 4) {
                    decodedString.append((char)Integer.parseInt(new String(hexDigits), 16));
                    hexDigit = 0;
                }
            } else if (backslash) {
                if (character == '\\') {
                    decodedString.append('\\');
                } else if (character == 'r') {
                    decodedString.append('\r');
                } else if (character == 'n') {
                    decodedString.append('\n');
                } else if (character == 'u') {
                    hexDigit = 1;
                }
                backslash = false;
            } else if (character == '\\') {
                backslash = true;
            } else {
                decodedString.append(character);
            }
            ++n2;
        }
        return decodedString.toString();
    }
}

