/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.config;

import java.util.HashMap;
import java.util.Map;
import net.pterodactylus.util.config.BooleanValue;
import net.pterodactylus.util.config.ConfigurationBackend;
import net.pterodactylus.util.config.ConfigurationException;
import net.pterodactylus.util.config.DoubleValue;
import net.pterodactylus.util.config.IntegerValue;
import net.pterodactylus.util.config.LongValue;
import net.pterodactylus.util.config.StringValue;
import net.pterodactylus.util.config.Value;

public class Configuration {
    final ConfigurationBackend configurationBackend;
    private final Map<String, BooleanValue> booleanCache = new HashMap<String, BooleanValue>();
    private final Map<String, DoubleValue> doubleCache = new HashMap<String, DoubleValue>();
    private final Map<String, StringValue> stringCache = new HashMap<String, StringValue>();
    private final Map<String, IntegerValue> integerCache = new HashMap<String, IntegerValue>();
    private final Map<String, LongValue> longCache = new HashMap<String, LongValue>();

    public Configuration(ConfigurationBackend configurationBackend) {
        this.configurationBackend = configurationBackend;
    }

    public Value<Boolean> getBooleanValue(String attribute) {
        BooleanValue booleanValue = this.booleanCache.get(attribute);
        if (booleanValue == null) {
            booleanValue = new BooleanValue(this, attribute);
            this.booleanCache.put(attribute, booleanValue);
        }
        return booleanValue;
    }

    public Value<Double> getDoubleValue(String attribute) {
        DoubleValue doubleValue = this.doubleCache.get(attribute);
        if (doubleValue == null) {
            doubleValue = new DoubleValue(this, attribute);
            this.doubleCache.put(attribute, doubleValue);
        }
        return doubleValue;
    }

    public Value<Integer> getIntValue(String attribute) {
        IntegerValue integerValue = this.integerCache.get(attribute);
        if (integerValue == null) {
            integerValue = new IntegerValue(this, attribute);
            this.integerCache.put(attribute, integerValue);
        }
        return integerValue;
    }

    public Value<Long> getLongValue(String attribute) {
        LongValue longValue = this.longCache.get(attribute);
        if (longValue == null) {
            longValue = new LongValue(this, attribute);
            this.longCache.put(attribute, longValue);
        }
        return longValue;
    }

    public Value<String> getStringValue(String attribute) {
        StringValue stringValue = this.stringCache.get(attribute);
        if (stringValue == null) {
            stringValue = new StringValue(this, attribute);
            this.stringCache.put(attribute, stringValue);
        }
        return stringValue;
    }

    public void save() throws ConfigurationException {
        this.configurationBackend.save();
    }
}

