/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.config;

import net.pterodactylus.util.config.AbstractValue;
import net.pterodactylus.util.config.Configuration;
import net.pterodactylus.util.config.ConfigurationException;
import net.pterodactylus.util.config.ExtendedConfigurationBackend;
import net.pterodactylus.util.config.ValueFormatException;

public class DoubleValue
extends AbstractValue<Double> {
    public DoubleValue(Configuration configuration, String attribute) {
        super(configuration, attribute);
    }

    @Override
    public Double getValue() throws ConfigurationException {
        if (this.configuration.configurationBackend instanceof ExtendedConfigurationBackend) {
            return ((ExtendedConfigurationBackend)this.configuration.configurationBackend).getDoubleValue(this.attribute);
        }
        String value = null;
        try {
            value = this.configuration.configurationBackend.getValue(this.attribute);
            double doubleValue = Double.valueOf(value);
            return doubleValue;
        }
        catch (NumberFormatException nfe1) {
            throw new ValueFormatException("could not parse attribute \"" + value + "\".", nfe1);
        }
    }

    @Override
    public Double getValue(Double defaultValue) {
        String value = null;
        try {
            if (this.configuration.configurationBackend instanceof ExtendedConfigurationBackend) {
                return ((ExtendedConfigurationBackend)this.configuration.configurationBackend).getDoubleValue(this.attribute);
            }
            value = this.configuration.configurationBackend.getValue(this.attribute);
            double doubleValue = Double.valueOf(value);
            return doubleValue;
        }
        catch (NumberFormatException nfe1) {
            return defaultValue;
        }
        catch (ConfigurationException ce1) {
            return defaultValue;
        }
    }

    @Override
    public void setValue(Double newValue) throws ConfigurationException {
        if (this.configuration.configurationBackend instanceof ExtendedConfigurationBackend) {
            ((ExtendedConfigurationBackend)this.configuration.configurationBackend).setDoubleValue(this.attribute, newValue);
        }
        this.configuration.configurationBackend.putValue(this.attribute, newValue != null ? String.valueOf(newValue) : null);
    }
}

