/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.config.AttributeNotFoundException;
import net.pterodactylus.util.config.ConfigurationBackend;
import net.pterodactylus.util.config.ConfigurationException;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.logging.Logging;
import net.pterodactylus.util.xml.SimpleXML;
import net.pterodactylus.util.xml.XML;
import org.w3c.dom.Document;

public class XMLConfigurationBackend
implements ConfigurationBackend {
    private static final Logger logger = Logging.getLogger(XMLConfigurationBackend.class.getName());
    private final Map<String, SimpleXML> nodeCache = new HashMap<String, SimpleXML>();
    private final File configurationFile;
    private long lastModified;
    private final SimpleXML rootNode;

    public XMLConfigurationBackend(File configurationFile) throws ConfigurationException {
        this(configurationFile, false);
    }

    public XMLConfigurationBackend(File configurationFile, boolean create) throws ConfigurationException {
        this.configurationFile = configurationFile;
        this.rootNode = this.readConfigurationFile(create);
    }

    private synchronized SimpleXML readConfigurationFile(boolean create) throws ConfigurationException {
        SimpleXML simpleXML;
        FileInputStream configFileInputStream = null;
        try {
            configFileInputStream = new FileInputStream(this.configurationFile);
            Document configurationDocument = XML.transformToDocument(configFileInputStream);
            if (configurationDocument == null) {
                if (!create) {
                    throw new ConfigurationException("can not parse XML document");
                }
                configurationDocument = new SimpleXML("config").getDocument();
            }
            this.nodeCache.clear();
            simpleXML = SimpleXML.fromDocument(configurationDocument);
        }
        catch (FileNotFoundException fnfe1) {
            SimpleXML simpleXML2;
            try {
                if (!create) {
                    throw new ConfigurationException(fnfe1);
                }
                simpleXML2 = new SimpleXML("config");
            }
            catch (Throwable throwable) {
                Closer.close(configFileInputStream);
                throw throwable;
            }
            Closer.close(configFileInputStream);
            return simpleXML2;
        }
        Closer.close(configFileInputStream);
        return simpleXML;
    }

    private synchronized void writeConfigurationFile() throws ConfigurationException {
        FileOutputStream configurationFileOutputStream = null;
        OutputStreamWriter configurationOutputStreamWriter = null;
        try {
            try {
                configurationFileOutputStream = new FileOutputStream(this.configurationFile);
                configurationOutputStreamWriter = new OutputStreamWriter((OutputStream)configurationFileOutputStream, "UTF-8");
                XML.writeToOutputStream(this.rootNode.getDocument(), configurationOutputStreamWriter);
            }
            catch (IOException ioe1) {
                throw new ConfigurationException(ioe1.getMessage(), ioe1);
            }
        }
        catch (Throwable throwable) {
            Closer.close(configurationOutputStreamWriter);
            Closer.close(configurationFileOutputStream);
            throw throwable;
        }
        Closer.close(configurationOutputStreamWriter);
        Closer.close(configurationFileOutputStream);
    }

    @Override
    public String getValue(String attribute) throws ConfigurationException {
        if (this.configurationFile.lastModified() > this.lastModified) {
            logger.info("reloading configuration file " + this.configurationFile.getAbsolutePath());
            this.readConfigurationFile(false);
            this.lastModified = this.configurationFile.lastModified();
        }
        SimpleXML node = this.getNode(attribute);
        String value = node.getValue();
        logger.log(Level.FINEST, "attribute: \u201c%1$s\u201d, value: \u201c%2$s\u201d", new Object[]{attribute, value});
        return value;
    }

    @Override
    public void putValue(String attribute, String value) throws ConfigurationException {
        SimpleXML node = this.getNode(attribute, true);
        node.setValue(value);
        this.writeConfigurationFile();
    }

    @Override
    public void save() throws ConfigurationException {
        this.writeConfigurationFile();
    }

    private SimpleXML getNode(String attribute) throws ConfigurationException {
        return this.getNode(attribute, false);
    }

    private SimpleXML getNode(String attribute, boolean create) throws ConfigurationException {
        if (this.nodeCache.containsKey(attribute)) {
            return this.nodeCache.get(attribute);
        }
        StringTokenizer attributes = new StringTokenizer(attribute, "|/");
        SimpleXML node = this.rootNode;
        while (attributes.hasMoreTokens()) {
            String nodeName = attributes.nextToken();
            if (node.hasNode(nodeName)) {
                node = node.getNode(nodeName);
                continue;
            }
            if (!create) {
                throw new AttributeNotFoundException(attribute);
            }
            node = node.append(nodeName);
        }
        this.nodeCache.put(attribute, node);
        return node;
    }
}

