/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import net.pterodactylus.util.database.Database;
import net.pterodactylus.util.database.DatabaseException;
import net.pterodactylus.util.database.ObjectCreator;
import net.pterodactylus.util.database.Query;
import net.pterodactylus.util.database.ResultProcessor;
import net.pterodactylus.util.io.Closer;

public abstract class AbstractDatabase
implements Database {
    @Override
    public <T> T getSingle(Query query, ObjectCreator<T> objectCreator) throws DatabaseException {
        return new SingleDatabaseWorker<T>(query, objectCreator).work();
    }

    @Override
    public <T> List<T> getMultiple(Query query, ObjectCreator<T> objectCreator) throws DatabaseException {
        return (List)new MultipleDatabaseWorker<T>(query, objectCreator).work();
    }

    @Override
    public long insert(Query query) throws DatabaseException {
        return (Long)new InsertDatabaseWorker(query).work();
    }

    @Override
    public int update(Query query) throws DatabaseException {
        return (Integer)new UpdateDatabaseWorker(query).work();
    }

    @Override
    public void process(Query query, ResultProcessor resultProcessor) throws DatabaseException {
        new ProcessWorker(query, resultProcessor).work();
    }

    public static Database fromDataSource(final DataSource dataSource) {
        return new AbstractDatabase(){

            @Override
            protected void returnConnection(Connection connection) {
                Closer.close(connection);
            }

            @Override
            protected Connection getConnection() throws SQLException {
                return dataSource.getConnection();
            }
        };
    }

    protected abstract Connection getConnection() throws SQLException;

    protected abstract void returnConnection(Connection var1);

    private abstract class AbstractDatabaseWorker<T> {
        protected final Query query;

        protected AbstractDatabaseWorker(Query query) {
            this.query = query;
        }

        protected T run(ResultSet resultSet) throws SQLException {
            return null;
        }

        protected T run(PreparedStatement preparedStatement) throws SQLException {
            ResultSet resultSet = null;
            try {
                resultSet = preparedStatement.executeQuery();
                T t = this.run(resultSet);
                return t;
            }
            finally {
                Closer.close(resultSet);
            }
        }

        protected T run(Connection connection) throws SQLException {
            T t;
            PreparedStatement preparedStatement = null;
            try {
                preparedStatement = this.query.createStatement(connection);
                t = this.run(preparedStatement);
            }
            catch (Throwable throwable) {
                Closer.close(preparedStatement);
                throw throwable;
            }
            Closer.close(preparedStatement);
            return t;
        }

        public T work() throws DatabaseException {
            Connection connection = null;
            try {
                connection = AbstractDatabase.this.getConnection();
                T t = this.run(connection);
                return t;
            }
            catch (SQLException sqle1) {
                throw new DatabaseException(sqle1);
            }
            finally {
                AbstractDatabase.this.returnConnection(connection);
            }
        }
    }

    private class InsertDatabaseWorker
    extends AbstractDatabaseWorker<Long> {
        public InsertDatabaseWorker(Query query) {
            super(query);
        }

        @Override
        protected Long run(PreparedStatement preparedStatement) throws SQLException {
            preparedStatement.executeUpdate();
            ResultSet generatedKeys = null;
            try {
                generatedKeys = preparedStatement.getGeneratedKeys();
                if (generatedKeys.next()) {
                    Long l = generatedKeys.getLong(1);
                    return l;
                }
                Long l = -1L;
                return l;
            }
            finally {
                Closer.close(generatedKeys);
            }
        }
    }

    private class MultipleDatabaseWorker<T>
    extends AbstractDatabaseWorker<List<T>> {
        private final ObjectCreator<T> objectCreator;

        public MultipleDatabaseWorker(Query query, ObjectCreator<T> objectCreator) {
            super(query);
            this.objectCreator = objectCreator;
        }

        @Override
        protected List<T> run(ResultSet resultSet) throws SQLException {
            ArrayList<T> results = new ArrayList<T>();
            while (resultSet.next()) {
                T object = this.objectCreator.createObject(resultSet);
                results.add(object);
            }
            return results;
        }
    }

    private class ProcessWorker
    extends AbstractDatabaseWorker<Void> {
        private final ResultProcessor resultProcessor;

        public ProcessWorker(Query query, ResultProcessor resultProcessor) {
            super(query);
            this.resultProcessor = resultProcessor;
        }

        @Override
        protected Void run(ResultSet resultSet) throws SQLException {
            while (resultSet.next()) {
                this.resultProcessor.processResult(resultSet);
            }
            return null;
        }
    }

    private class SingleDatabaseWorker<T>
    extends AbstractDatabaseWorker<T> {
        private final ObjectCreator<T> objectCreator;

        public SingleDatabaseWorker(Query query, ObjectCreator<T> objectCreator) {
            super(query);
            this.objectCreator = objectCreator;
        }

        @Override
        protected T run(ResultSet resultSet) throws SQLException {
            if (resultSet.next()) {
                return this.objectCreator.createObject(resultSet);
            }
            return null;
        }
    }

    private class UpdateDatabaseWorker
    extends AbstractDatabaseWorker<Integer> {
        public UpdateDatabaseWorker(Query query) {
            super(query);
        }

        @Override
        protected Integer run(PreparedStatement preparedStatement) throws SQLException {
            return preparedStatement.executeUpdate();
        }
    }
}

