/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.database;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.pterodactylus.util.database.DataObjectFactory;
import net.pterodactylus.util.database.Database;
import net.pterodactylus.util.database.DatabaseException;
import net.pterodactylus.util.database.OrderField;
import net.pterodactylus.util.database.Parameter;
import net.pterodactylus.util.database.Query;
import net.pterodactylus.util.database.ValueField;
import net.pterodactylus.util.database.ValueFieldWhereClause;
import net.pterodactylus.util.database.WhereClause;

public abstract class DataObject<D extends DataObject<D>> {
    private final DataObjectFactory<D> dataObjectFactory;
    private long id;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private boolean dirty;

    protected DataObject(DataObjectFactory<D> dataObjectFactory, long id) {
        this.dataObjectFactory = dataObjectFactory;
        this.id = id;
    }

    public final long getId() {
        return this.id;
    }

    protected void setProperty(String name, Object value) {
        this.properties.put(name, value);
        this.dirty = true;
    }

    protected Object getProperty(String name) {
        return this.properties.get(name);
    }

    protected void clearDirtyFlag() {
        this.dirty = false;
    }

    protected abstract Set<ValueField> getSaveFields();

    public void save(Database database) throws DatabaseException {
        this.save(database, false);
    }

    public void save(Database database, boolean force) throws DatabaseException {
        if (this.id != -1L && !this.dirty && !force) {
            return;
        }
        if (this.id == -1L) {
            Query query = new Query(Query.Type.INSERT, this.dataObjectFactory.getTable());
            for (ValueField saveField : this.getSaveFields()) {
                query.addValueField(saveField);
            }
            this.id = database.insert(query);
            this.clearDirtyFlag();
            return;
        }
        Query query = new Query(Query.Type.UPDATE, this.dataObjectFactory.getTable());
        for (ValueField saveField : this.getSaveFields()) {
            query.addValueField(saveField);
        }
        query.addWhereClause(new ValueFieldWhereClause(new ValueField(this.dataObjectFactory.getIdentityColumn(), new Parameter.LongParameter(this.id))));
        database.update(query);
        this.clearDirtyFlag();
    }

    public boolean delete(Database database) throws DatabaseException {
        return DataObject.deleteById(database, this.dataObjectFactory, this.getId());
    }

    public static <D extends DataObject<D>> D loadById(Database database, DataObjectFactory<D> dataObjectFactory, long id) throws DatabaseException {
        return DataObject.loadByWhereClause(database, dataObjectFactory, new ValueFieldWhereClause(new ValueField(dataObjectFactory.getIdentityColumn(), new Parameter.LongParameter(id))), new OrderField[0]);
    }

    public static <D extends DataObject<D>> D loadByWhereClause(Database database, DataObjectFactory<D> dataObjectFactory, WhereClause whereClause, OrderField ... orderFields) throws DatabaseException {
        Query query = new Query(Query.Type.SELECT, dataObjectFactory.getTable());
        query.addWhereClause(whereClause);
        OrderField[] orderFieldArray = orderFields;
        int n = orderFields.length;
        int n2 = 0;
        while (n2 < n) {
            OrderField orderField = orderFieldArray[n2];
            query.addOrderField(orderField);
            ++n2;
        }
        return (D)((DataObject)database.getSingle(query, dataObjectFactory));
    }

    public static <D extends DataObject<D>> List<D> loadAllByWhereClause(Database database, DataObjectFactory<D> dataObjectFactory, WhereClause whereClause, OrderField ... orderFields) throws DatabaseException {
        Query query = new Query(Query.Type.SELECT, dataObjectFactory.getTable());
        query.addWhereClause(whereClause);
        query.addOrderField(orderFields);
        return database.getMultiple(query, dataObjectFactory);
    }

    public static <D extends DataObject<D>> D create(Database database, DataObjectFactory<D> dataObjectFactory, ValueField ... valueFields) throws DatabaseException {
        Query query = new Query(Query.Type.INSERT, dataObjectFactory.getTable());
        query.addValueField(valueFields);
        long id = database.insert(query);
        return DataObject.loadById(database, dataObjectFactory, id);
    }

    public static <D extends DataObject<D>> boolean deleteById(Database database, DataObjectFactory<D> dataObjectFactory, long id) throws DatabaseException {
        return DataObject.deleteByWhereClause(database, dataObjectFactory, new ValueFieldWhereClause(new ValueField(dataObjectFactory.getIdentityColumn(), new Parameter.LongParameter(id)))) == 1;
    }

    public static <D extends DataObject<D>> int deleteByWhereClause(Database database, DataObjectFactory<D> dataObjectFactory, WhereClause whereClause) throws DatabaseException {
        Query query = new Query(Query.Type.DELETE, dataObjectFactory.getTable());
        query.addWhereClause(whereClause);
        return database.update(query);
    }
}

