/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.database;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.pterodactylus.util.database.ObjectCreator;

public class MapCreator
implements ObjectCreator<Map<String, Object>> {
    @Override
    public Map<String, Object> createObject(ResultSet resultSet) throws SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ResultSetMetaData metadata = resultSet.getMetaData();
        int column = 1;
        while (column <= metadata.getColumnCount()) {
            int columnType = metadata.getColumnType(column);
            String columnLabel = metadata.getColumnLabel(column);
            if (columnType == 4) {
                result.put(columnLabel, resultSet.getInt(column));
            } else if (columnType == -5) {
                result.put(columnLabel, resultSet.getLong(column));
            } else if (columnType == 3) {
                result.put(columnLabel, resultSet.getDouble(column));
            } else if (columnType == 16) {
                result.put(columnLabel, resultSet.getBoolean(column));
            } else if (columnType == 12) {
                result.put(columnLabel, resultSet.getString(column));
            } else if (columnType == -1) {
                result.put(columnLabel, resultSet.getString(column));
            } else if (columnType == 91) {
                result.put(columnLabel, resultSet.getDate(column));
            } else {
                System.out.println("unknown type (" + columnType + ") for column \u201c" + columnLabel + "\u201d.");
            }
            ++column;
        }
        return result;
    }
}

