/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.database;

import java.sql.ResultSet;
import java.sql.SQLException;

public interface ObjectCreator<T> {
    public static final IntegerCreator INTEGER_CREATOR = new IntegerCreator();
    public static final StringCreator STRING_CREATOR = new StringCreator();

    public T createObject(ResultSet var1) throws SQLException;

    public static class IntegerCreator
    implements ObjectCreator<Integer> {
        private final int index;

        public IntegerCreator() {
            this(1);
        }

        public IntegerCreator(int index) {
            this.index = index;
        }

        @Override
        public Integer createObject(ResultSet resultSet) throws SQLException {
            Integer result = resultSet.getInt(this.index);
            if (resultSet.wasNull()) {
                return null;
            }
            return result;
        }
    }

    public static class StringCreator
    implements ObjectCreator<String> {
        private final int index;
        private final String fieldName;

        public StringCreator() {
            this(1);
        }

        public StringCreator(int index) {
            this(index, null);
        }

        public StringCreator(String fieldName) {
            this(-1, fieldName);
        }

        private StringCreator(int index, String fieldName) {
            this.index = index;
            this.fieldName = fieldName;
        }

        @Override
        public String createObject(ResultSet resultSet) throws SQLException {
            return this.fieldName == null ? resultSet.getString(this.index) : resultSet.getString(this.fieldName);
        }
    }
}

