/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.database;

import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class Parameter<T> {
    protected final T value;

    protected Parameter(T value) {
        this.value = value;
    }

    public abstract void set(PreparedStatement var1, int var2) throws SQLException;

    public static class BooleanParameter
    extends Parameter<Boolean> {
        public BooleanParameter(Boolean value) {
            super(value);
        }

        @Override
        public void set(PreparedStatement preparedStatement, int index) throws SQLException {
            if (this.value == null) {
                preparedStatement.setNull(index, 16);
            } else {
                preparedStatement.setBoolean(index, (Boolean)this.value);
            }
        }
    }

    public static class IntegerParameter
    extends Parameter<Integer> {
        public IntegerParameter(Integer value) {
            super(value);
        }

        @Override
        public void set(PreparedStatement preparedStatement, int index) throws SQLException {
            if (this.value == null) {
                preparedStatement.setNull(index, 4);
            } else {
                preparedStatement.setInt(index, (Integer)this.value);
            }
        }
    }

    public static class LongParameter
    extends Parameter<Long> {
        public LongParameter(Long value) {
            super(value);
        }

        @Override
        public void set(PreparedStatement preparedStatement, int index) throws SQLException {
            if (this.value == null) {
                preparedStatement.setNull(index, -5);
            } else {
                preparedStatement.setLong(index, (Long)this.value);
            }
        }
    }

    public static class StringParameter
    extends Parameter<String> {
        public StringParameter(String value) {
            super(value);
        }

        @Override
        public void set(PreparedStatement preparedStatement, int index) throws SQLException {
            if (this.value == null) {
                preparedStatement.setNull(index, 12);
            } else {
                preparedStatement.setString(index, (String)this.value);
            }
        }
    }
}

