/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.pterodactylus.util.database.AndWhereClause;
import net.pterodactylus.util.database.Field;
import net.pterodactylus.util.database.Join;
import net.pterodactylus.util.database.Limit;
import net.pterodactylus.util.database.OrderField;
import net.pterodactylus.util.database.Parameter;
import net.pterodactylus.util.database.ValueField;
import net.pterodactylus.util.database.WhereClause;

public class Query {
    private final Type type;
    private final List<Field> fields = new ArrayList<Field>();
    private final List<ValueField> valueFields = new ArrayList<ValueField>();
    private final String table;
    private final List<Join> joins = new ArrayList<Join>();
    private final List<WhereClause> whereClauses = new ArrayList<WhereClause>();
    private final List<OrderField> orderFields = new ArrayList<OrderField>();
    private Limit limit;

    public Query(Type type, String table) {
        this.type = type;
        this.table = table;
    }

    public void addField(Field ... fields) {
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            this.fields.add(field);
            ++n2;
        }
    }

    public void addValueField(ValueField ... valueFields) {
        ValueField[] valueFieldArray = valueFields;
        int n = valueFields.length;
        int n2 = 0;
        while (n2 < n) {
            ValueField valueField = valueFieldArray[n2];
            this.valueFields.add(valueField);
            ++n2;
        }
    }

    public void addJoin(Join ... joins) {
        Join[] joinArray = joins;
        int n = joins.length;
        int n2 = 0;
        while (n2 < n) {
            Join join = joinArray[n2];
            this.joins.add(join);
            ++n2;
        }
    }

    public void addWhereClause(WhereClause ... whereClauses) {
        WhereClause[] whereClauseArray = whereClauses;
        int n = whereClauses.length;
        int n2 = 0;
        while (n2 < n) {
            WhereClause whereClause = whereClauseArray[n2];
            this.whereClauses.add(whereClause);
            ++n2;
        }
    }

    public void addOrderField(OrderField ... orderFields) {
        if (this.type != Type.SELECT) {
            throw new IllegalStateException("Order fields are only allowed in SELECT queries.");
        }
        OrderField[] orderFieldArray = orderFields;
        int n = orderFields.length;
        int n2 = 0;
        while (n2 < n) {
            OrderField orderField = orderFieldArray[n2];
            this.orderFields.add(orderField);
            ++n2;
        }
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public PreparedStatement createStatement(Connection connection) throws SQLException {
        StringWriter queryWriter = new StringWriter();
        try {
            this.render(queryWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String query = queryWriter.toString();
        PreparedStatement preparedStatement = connection.prepareStatement(query, 1);
        int index = 0;
        if (this.type == Type.UPDATE || this.type == Type.INSERT) {
            for (ValueField valueField : this.valueFields) {
                valueField.getParameter().set(preparedStatement, ++index);
            }
        }
        if (this.type == Type.SELECT || this.type == Type.UPDATE || this.type == Type.DELETE) {
            for (WhereClause whereClause : this.whereClauses) {
                for (Parameter<?> parameter : whereClause.getParameters()) {
                    parameter.set(preparedStatement, ++index);
                }
            }
        }
        return preparedStatement;
    }

    /*
     * WARNING - void declaration
     */
    public void render(Writer writer) throws IOException {
        writer.write(this.type.name());
        if (this.type == Type.SELECT) {
            writer.write(32);
            if (this.fields.isEmpty()) {
                writer.write(42);
            } else {
                boolean first = true;
                for (Field field : this.fields) {
                    if (!first) {
                        writer.write(", ");
                    }
                    writer.write(field.getName());
                    first = false;
                }
            }
            writer.write(" FROM ");
            writer.write(this.table);
            for (Join join : this.joins) {
                writer.write(" ");
                writer.write(join.getType().name());
                writer.write(" JOIN ");
                writer.write(join.getTable());
                writer.write(" ON (");
                writer.write(join.getLeftField().getName());
                writer.write(" = ");
                writer.write(join.getRightField().getName());
                writer.write(")");
            }
            this.renderWhereClauses(writer);
            if (!this.orderFields.isEmpty()) {
                writer.write(" ORDER BY ");
                boolean first = true;
                for (OrderField orderField : this.orderFields) {
                    if (!first) {
                        writer.write(", ");
                    }
                    writer.write(orderField.getField().getName());
                    writer.write(orderField.getOrder() == OrderField.Order.ASCENDING ? " ASC" : " DESC");
                    first = false;
                }
            }
            if (this.limit != null) {
                writer.write(" LIMIT ");
                if (this.limit.getStart() != 0L) {
                    writer.write(String.valueOf(this.limit.getStart()));
                    writer.write(", ");
                }
                writer.write(String.valueOf(this.limit.getNumber()));
            }
        } else if (this.type == Type.UPDATE) {
            writer.write(32);
            writer.write(this.table);
            writer.write(" SET ");
            boolean first = true;
            for (ValueField valueField : this.valueFields) {
                if (!first) {
                    writer.write(", ");
                }
                writer.write(valueField.getName());
                writer.write(" = ?");
                first = false;
            }
            this.renderWhereClauses(writer);
        } else if (this.type == Type.INSERT) {
            void var3_17;
            writer.write(" INTO ");
            writer.write(this.table);
            writer.write(" (");
            boolean first = true;
            for (ValueField valueField : this.valueFields) {
                if (!first) {
                    writer.write(", ");
                }
                writer.write(valueField.getName());
                first = false;
            }
            writer.write(") VALUES (");
            first = true;
            boolean bl = false;
            while (var3_17 < this.valueFields.size()) {
                if (!first) {
                    writer.write(", ");
                }
                writer.write(63);
                first = false;
                ++var3_17;
            }
            writer.write(41);
        } else if (this.type == Type.DELETE) {
            writer.write(" FROM ");
            writer.write(this.table);
            this.renderWhereClauses(writer);
        }
    }

    private void renderWhereClauses(Writer writer) throws IOException {
        if (this.whereClauses.isEmpty()) {
            return;
        }
        writer.write(" WHERE ");
        if (this.whereClauses.size() == 1) {
            this.whereClauses.get(0).render(writer);
            return;
        }
        AndWhereClause whereClause = new AndWhereClause(this.whereClauses);
        whereClause.render(writer);
    }

    public static enum Type {
        SELECT,
        INSERT,
        UPDATE,
        DELETE;

    }
}

