/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.i18n.gui;

import javax.swing.AbstractAction;
import javax.swing.Icon;
import net.pterodactylus.util.i18n.I18n;
import net.pterodactylus.util.i18n.I18nable;

public abstract class I18nAction
extends AbstractAction
implements I18nable {
    protected final I18n i18n;
    private final String i18nName;

    public I18nAction(I18n i18n, String i18nName) {
        this(i18n, null, i18nName);
    }

    public I18nAction(I18n i18n, I18n.RemovalReference removalReference, String i18nName) {
        this(i18n, removalReference, i18nName, null);
    }

    public I18nAction(I18n i18n, String i18nName, Icon icon) {
        this(i18n, null, i18nName, icon);
    }

    public I18nAction(I18n i18n, I18n.RemovalReference removalReference, String i18nName, Icon icon) {
        this(i18n, removalReference, i18nName, true, icon);
    }

    public I18nAction(I18n i18n, String i18nName, boolean enabled) {
        this(i18n, null, i18nName, enabled);
    }

    public I18nAction(I18n i18n, I18n.RemovalReference removalReference, String i18nName, boolean enabled) {
        this(i18n, removalReference, i18nName, enabled, null);
    }

    public I18nAction(I18n i18n, String i18nName, boolean enabled, Icon icon) {
        this(i18n, null, i18nName, enabled, icon);
    }

    public I18nAction(I18n i18n, I18n.RemovalReference removalReference, String i18nName, boolean enabled, Icon icon) {
        this.i18n = i18n;
        this.i18nName = i18nName;
        if (icon != null) {
            this.putValue("SmallIcon", icon);
        }
        this.setEnabled(enabled);
        i18n.addI18nable(this, removalReference);
        this.updateI18n();
    }

    String getI18nBasename() {
        return this.i18nName;
    }

    @Override
    public void updateI18n() {
        this.putValue("Name", this.i18n.get(String.valueOf(this.i18nName) + ".name", new Object[0]));
        this.putValue("MnemonicKey", this.i18n.getKey(String.valueOf(this.i18nName) + ".mnemonic"));
        this.putValue("AcceleratorKey", this.i18n.getKeyStroke(String.valueOf(this.i18nName) + ".accelerator"));
        this.putValue("ShortDescription", this.i18n.get(String.valueOf(this.i18nName) + ".shortDescription", new Object[0]));
        if (this.i18n.has(String.valueOf(this.i18nName) + ".longDescription")) {
            this.putValue("LongDescription", this.i18n.get(String.valueOf(this.i18nName) + ".longDescription", new Object[0]));
        } else {
            this.putValue("LongDescription", this.i18n.get(String.valueOf(this.i18nName) + ".shortDescription", new Object[0]));
        }
    }
}

