/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.i18n.gui;

import java.awt.Component;
import javax.swing.JLabel;
import net.pterodactylus.util.i18n.I18n;
import net.pterodactylus.util.i18n.I18nable;

public class I18nLabel
extends JLabel
implements I18nable {
    private final I18n i18n;
    private final String i18nBasename;
    private final Object[] arguments;

    public I18nLabel(I18n i18n, String i18nBasename) {
        this(i18n, null, i18nBasename);
    }

    public I18nLabel(I18n i18n, I18n.RemovalReference removalReference, String i18nBasename) {
        this(i18n, removalReference, i18nBasename, null);
    }

    public I18nLabel(I18n i18n, String i18nBasename, Component component) {
        this(i18n, null, i18nBasename, component);
    }

    public I18nLabel(I18n i18n, I18n.RemovalReference removalReference, String i18nBasename, Component component) {
        this(i18n, removalReference, i18nBasename, component, null);
    }

    public I18nLabel(I18n i18n, String i18nBasename, Object ... arguments) {
        this(i18n, null, i18nBasename, arguments);
    }

    public I18nLabel(I18n i18n, I18n.RemovalReference removalReference, String i18nBasename, Object ... arguments) {
        this(i18n, removalReference, i18nBasename, null, arguments);
    }

    public I18nLabel(I18n i18n, String i18nBasename, Component component, Object ... arguments) {
        this(i18n, null, i18nBasename, component, arguments);
    }

    public I18nLabel(I18n i18n, I18n.RemovalReference removalReference, String i18nBasename, Component component, Object ... arguments) {
        this.i18n = i18n;
        this.i18nBasename = i18nBasename;
        i18n.addI18nable(this, removalReference);
        this.arguments = arguments;
        if (component != null) {
            this.setLabelFor(component);
        }
        this.updateI18n();
    }

    @Override
    public void updateI18n() {
        this.setText(this.i18n.get(String.valueOf(this.i18nBasename) + ".name", this.arguments));
        if (this.getLabelFor() != null) {
            this.setDisplayedMnemonic(this.i18n.getKey(String.valueOf(this.i18nBasename) + ".mnemonic"));
        }
    }
}

