/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.pterodactylus.util.number.Bits;

public class BitShiftedOutputStream
extends FilterOutputStream {
    private final int valueSize;
    private int currentBitPosition;
    private int currentValue;

    public BitShiftedOutputStream(OutputStream outputStream, int valueSize) throws IllegalArgumentException {
        super(outputStream);
        if (valueSize < 1 || valueSize > 32) {
            throw new IllegalArgumentException("valueSize out of range [1-32]");
        }
        this.valueSize = valueSize;
        this.currentBitPosition = 0;
        this.currentValue = 0;
    }

    @Override
    public void write(int value) throws IOException {
        int valueLeft = value;
        int bitsLeft = this.valueSize;
        while (bitsLeft > 0) {
            int bitsToEncode = Math.min(8, Math.min(bitsLeft, 8 - this.currentBitPosition));
            this.currentValue = Bits.encodeBits(this.currentValue, this.currentBitPosition, bitsToEncode, valueLeft);
            valueLeft >>>= bitsToEncode;
            this.currentBitPosition += bitsToEncode;
            bitsLeft -= bitsToEncode;
            if (this.currentBitPosition != 8) continue;
            super.write(this.currentValue & 0xFF);
            this.currentBitPosition = 0;
            this.currentValue = -1;
        }
    }

    public void writePadding(int numberOfBits) throws IOException {
        this.writePadding(numberOfBits, 0);
    }

    public void writePadding(int numberOfBits, int fillBit) throws IOException {
        int bitsLeft = numberOfBits;
        while (bitsLeft > 0) {
            this.currentValue = Bits.encodeBits(this.currentValue, this.currentBitPosition, 1, fillBit);
            ++this.currentBitPosition;
            --bitsLeft;
            if (this.currentBitPosition != 8) continue;
            super.write(this.currentValue & 0xFF);
            this.currentBitPosition = 0;
            this.currentValue = -1;
        }
    }

    @Override
    public void flush() throws IOException {
        this.flush(0);
    }

    public void flush(int fillBit) throws IOException {
        if (this.currentBitPosition != 0) {
            this.currentValue &= 255 >> 8 - this.currentBitPosition;
            int bit = this.currentBitPosition;
            while (bit < 8) {
                this.currentValue = Bits.encodeBits(this.currentValue, bit, 1, fillBit & 1);
                ++bit;
            }
            this.currentBitPosition = 0;
            super.write(this.currentValue);
            this.currentValue = -1;
        }
        super.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }
}

