/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class StreamReader {
    public static byte read(InputStream inputStream) throws IOException {
        int result = inputStream.read();
        if (result == -1) {
            throw new EOFException();
        }
        return (byte)result;
    }

    public static void readFully(InputStream inputStream, byte[] buffer) throws IOException {
        StreamReader.readFully(inputStream, buffer, 0, buffer.length);
    }

    public static void readFully(InputStream inputStream, byte[] buffer, int position, int length) throws IOException {
        int totalRead = 0;
        while (totalRead < length) {
            int read = inputStream.read(buffer, position + totalRead, length - totalRead);
            if (read == -1) {
                throw new EOFException();
            }
            totalRead += read;
        }
    }
}

