/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.io;

import java.io.IOException;
import java.io.OutputStream;

public class TeeOutputStream
extends OutputStream {
    private final OutputStream[] outputStreams;

    public TeeOutputStream(OutputStream ... outputStreams) {
        this.outputStreams = outputStreams;
    }

    @Override
    public void write(int data) throws IOException {
        OutputStream[] outputStreamArray = this.outputStreams;
        int n = this.outputStreams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream outputStream = outputStreamArray[n2];
            outputStream.write(data);
            ++n2;
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        OutputStream[] outputStreamArray = this.outputStreams;
        int n = this.outputStreams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream outputStream = outputStreamArray[n2];
            outputStream.write(buffer);
            ++n2;
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        OutputStream[] outputStreamArray = this.outputStreams;
        int n = this.outputStreams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream outputStream = outputStreamArray[n2];
            outputStream.write(buffer, offset, length);
            ++n2;
        }
    }

    @Override
    public void flush() throws IOException {
        IOException occuredException = null;
        OutputStream[] outputStreamArray = this.outputStreams;
        int n = this.outputStreams.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                OutputStream outputStream = outputStreamArray[n2];
                try {
                    outputStream.flush();
                }
                catch (IOException ioe1) {
                    if (occuredException != null) break block4;
                    occuredException = ioe1;
                }
            }
            ++n2;
        }
        if (occuredException != null) {
            throw occuredException;
        }
    }

    @Override
    public void close() throws IOException {
        IOException occuredException = null;
        OutputStream[] outputStreamArray = this.outputStreams;
        int n = this.outputStreams.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                OutputStream outputStream = outputStreamArray[n2];
                try {
                    outputStream.flush();
                }
                catch (IOException ioe1) {
                    if (occuredException != null) break block4;
                    occuredException = ioe1;
                }
            }
            ++n2;
        }
        if (occuredException != null) {
            throw occuredException;
        }
    }
}

