/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.logging;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.pterodactylus.util.logging.LoggingListener;

public class Logging {
    private static final LogHandler logHandler = new LogHandler();
    private static ConsoleHandler consoleHandler = new ConsoleHandler();
    private static final Map<String, Class<?>> classCache = new HashMap();
    private static String hierarchyRootName;

    static {
        logHandler.setLevel(Level.ALL);
        hierarchyRootName = "default";
    }

    public static void addLoggingListener(LoggingListener loggingListener) {
        logHandler.addLoggingListener(loggingListener);
    }

    public static void removeLoggingListener(LoggingListener loggingListener) {
        logHandler.removeLoggingListener(loggingListener);
    }

    public static void setup(String hierarchyName) {
        hierarchyRootName = hierarchyName;
        Logger rootLogger = Logging.getRootLogger();
        rootLogger.addHandler(logHandler);
        rootLogger.setUseParentHandlers(false);
        if (rootLogger.getLevel() == null) {
            rootLogger.setLevel(Level.ALL);
        }
    }

    public static void setupConsoleLogging() {
        Logger rootLogger = Logging.getRootLogger();
        consoleHandler.setLevel(Level.ALL);
        consoleHandler.setFormatter(new Formatter(){
            private StringBuffer recordBuffer = new StringBuffer();
            private DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");

            @Override
            public synchronized String format(LogRecord record) {
                this.recordBuffer.setLength(0);
                String linePrefix = String.valueOf(this.dateFormatter.format(new Date(record.getMillis()))) + " [" + record.getLevel() + "] [" + Thread.currentThread().getName() + "] [" + record.getSourceClassName() + "." + record.getSourceMethodName() + "] ";
                this.recordBuffer.append(linePrefix).append(String.format(record.getMessage(), record.getParameters())).append('\n');
                if (record.getThrown() != null) {
                    Throwable throwable = record.getThrown();
                    boolean causedBy = false;
                    while (throwable != null) {
                        StackTraceElement[] stackTraceElements;
                        this.recordBuffer.append(linePrefix);
                        if (causedBy) {
                            this.recordBuffer.append("caused by: ");
                        }
                        this.recordBuffer.append(throwable.getClass().getName());
                        if (throwable.getMessage() != null) {
                            this.recordBuffer.append(": ").append(throwable.getMessage());
                        }
                        this.recordBuffer.append("\n");
                        StackTraceElement[] stackTraceElementArray = stackTraceElements = throwable.getStackTrace();
                        int n = stackTraceElements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                            this.recordBuffer.append(linePrefix).append("  at ").append(stackTraceElement.getClassName()).append('.').append(stackTraceElement.getMethodName()).append("(").append(stackTraceElement.getFileName()).append(':').append(stackTraceElement.getLineNumber()).append(')').append("\n");
                            ++n2;
                        }
                        throwable = throwable.getCause();
                        causedBy = true;
                    }
                }
                return this.recordBuffer.toString();
            }
        });
        rootLogger.addHandler(consoleHandler);
    }

    public static void shutdown() {
        Logging.getRootLogger().removeHandler(logHandler);
        Logging.getRootLogger().removeHandler(consoleHandler);
    }

    public static Logger getLogger(String name) {
        Logger logger = Logger.getLogger(String.valueOf(hierarchyRootName) + "." + name);
        return logger;
    }

    public static Logger getLogger(Class<?> loggerClass) {
        classCache.put(String.valueOf(hierarchyRootName) + "." + loggerClass.getName(), loggerClass);
        return Logging.getLogger(loggerClass.getName());
    }

    public static void setRootLevel(Level rootLevel) {
        Logging.getRootLogger().setLevel(rootLevel);
    }

    private static Logger getRootLogger() {
        return Logger.getLogger(hierarchyRootName);
    }

    public static Class<?> getLoggerClass(String loggerName) {
        return classCache.get(loggerName);
    }

    private static class LogHandler
    extends Handler {
        private final List<LoggingListener> loggingListeners = Collections.synchronizedList(new ArrayList());

        LogHandler() {
        }

        public void addLoggingListener(LoggingListener loggingListener) {
            this.loggingListeners.add(loggingListener);
        }

        public void removeLoggingListener(LoggingListener loggingListener) {
            this.loggingListeners.remove(loggingListener);
        }

        private void fireLogged(LogRecord logRecord) {
            for (LoggingListener loggingListener : this.loggingListeners) {
                loggingListener.logged(logRecord);
            }
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord logRecord) {
            this.fireLogged(logRecord);
        }
    }
}

