/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.logging.Logging;
import net.pterodactylus.util.service.Service;
import net.pterodactylus.util.service.ServiceListener;
import net.pterodactylus.util.service.ServiceListenerManager;
import net.pterodactylus.util.service.State;
import net.pterodactylus.util.thread.DumpingThreadFactory;
import net.pterodactylus.util.validation.Validation;

public abstract class AbstractService
implements Service,
Runnable {
    private static final Logger logger = Logging.getLogger(AbstractService.class.getName());
    private final ServiceListenerManager serviceListenerSupport = new ServiceListenerManager(this);
    private final ShutdownHook shutdownHook = new ShutdownHook();
    private static int counter = 0;
    protected final Object syncObject = new Object();
    private boolean shouldStop = false;
    private final String name;
    private State state = State.offline;
    private String action = "";
    private ThreadFactory threadFactory;
    private final Map<String, Object> serviceAttributes = new HashMap<String, Object>();
    private final boolean registerShutdownHook;

    protected AbstractService() {
        this("AbstractService-" + counter++);
    }

    protected AbstractService(String name) {
        this(name, true);
    }

    protected AbstractService(String name, ThreadFactory threadFactory) {
        this(name, true, threadFactory);
    }

    protected AbstractService(String name, boolean registerShutdownHook) {
        this(name, registerShutdownHook, new DumpingThreadFactory(String.valueOf(name) + " ", false));
    }

    protected AbstractService(String name, boolean registerShutdownHook, ThreadFactory threadFactory) {
        this.registerShutdownHook = registerShutdownHook;
        Validation.begin().isNotNull("name", name).isNotNull("threadFactory", threadFactory).check();
        this.name = name;
        this.threadFactory = threadFactory;
    }

    @Override
    public void addServiceListener(ServiceListener serviceListener) {
        this.serviceListenerSupport.addListener(serviceListener);
    }

    @Override
    public void removeServiceListener(ServiceListener serviceListener) {
        this.serviceListenerSupport.removeListener(serviceListener);
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        Validation.begin().isNotNull("threadFactory", threadFactory).check();
        this.threadFactory = threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State getState() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String getStateReason() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.action;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAction() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.action;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getServiceAttribute(String attributeName) {
        Object object = this.syncObject;
        synchronized (object) {
            return this.serviceAttributes.get(attributeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasServiceAttribute(String attributeName) {
        Object object = this.syncObject;
        synchronized (object) {
            return this.serviceAttributes.containsKey(attributeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServiceAttribute(String attributeName, Object attributeValue) {
        Object object = this.syncObject;
        synchronized (object) {
            this.serviceAttributes.put(attributeName, attributeValue);
        }
    }

    protected void setState(State newState) {
        this.setState(newState, null);
    }

    @Deprecated
    protected void setStateReason(String action) {
        this.setAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAction(String action) {
        if (action != null) {
            Object object = this.syncObject;
            synchronized (object) {
                this.action = action;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(State newState, String action) {
        State oldState = null;
        Object object = this.syncObject;
        synchronized (object) {
            oldState = this.state;
            this.state = newState;
            if (action != null) {
                this.action = action;
            }
        }
        if (oldState != newState) {
            this.serviceListenerSupport.fireServiceStateChanged(oldState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean shouldStop() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.shouldStop;
        }
    }

    protected void serviceInit() {
    }

    @Override
    public final void init() {
        if (this.state.getBasicState() != State.offline) {
            logger.log(Level.WARNING, "will not init " + this.name + ", state is " + this.getState());
            return;
        }
        this.serviceInit();
    }

    protected void serviceStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void start() {
        if (this.getState() != State.offline) {
            logger.log(Level.WARNING, "will not start " + this.name + ", state is " + this.getState());
            return;
        }
        if (this.registerShutdownHook) {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        this.serviceStart();
        Object object = this.syncObject;
        synchronized (object) {
            this.shouldStop = false;
        }
        this.setState(State.starting, "");
        Thread serviceThread = this.threadFactory.newThread(this);
        serviceThread.setName(this.name);
        serviceThread.start();
    }

    protected void serviceRun() {
        while (!this.shouldStop()) {
            this.sleep(0L);
        }
    }

    @Override
    public final void run() {
        block5: {
            Throwable cause = null;
            try {
                try {
                    this.setState(State.online);
                    this.serviceListenerSupport.fireServiceStarted();
                    this.serviceRun();
                }
                catch (Throwable t) {
                    cause = t;
                    this.setState(State.offline, cause != null ? cause.getMessage() : null);
                    this.serviceListenerSupport.fireServiceStopped(cause);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.setState(State.offline, cause != null ? cause.getMessage() : null);
                this.serviceListenerSupport.fireServiceStopped(cause);
                throw throwable;
            }
            this.setState(State.offline, cause != null ? cause.getMessage() : null);
            this.serviceListenerSupport.fireServiceStopped(cause);
        }
    }

    protected void serviceStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop() {
        Object object = this.syncObject;
        synchronized (object) {
            this.shouldStop = true;
            this.syncObject.notify();
        }
        if (this.registerShutdownHook) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.serviceStop();
    }

    protected void serviceDestroy() {
    }

    @Override
    public final void destroy() {
        this.serviceDestroy();
    }

    protected void sleep() {
        this.sleep(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sleep(long timeout) {
        Object object = this.syncObject;
        synchronized (object) {
            if (!this.shouldStop) {
                try {
                    this.syncObject.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySyncObject() {
        Object object = this.syncObject;
        synchronized (object) {
            this.syncObject.notify();
        }
    }

    private class ShutdownHook
    extends Thread
    implements ServiceListener {
        private final Object syncObject;
        private boolean stopped;

        public ShutdownHook() {
            super("Shutdown Hook for " + AbstractService.this);
            this.syncObject = new Object();
            this.stopped = true;
            AbstractService.this.addServiceListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.log(Level.INFO, "shutdown hook for " + AbstractService.this + " started.");
            Object object = this.syncObject;
            synchronized (object) {
                if (!this.stopped) {
                    AbstractService.this.stop();
                }
                while (!this.stopped) {
                    logger.log(Level.FINER, "waiting for " + AbstractService.this + " to stop...");
                    try {
                        this.syncObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            logger.log(Level.INFO, "shutdown hook for " + AbstractService.this + " finished.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceStarted(Service service) {
            logger.log(Level.FINER, AbstractService.this + " started.");
            Object object = this.syncObject;
            synchronized (object) {
                this.stopped = false;
            }
        }

        @Override
        public void serviceStateChanged(Service service, State oldState, State newState) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceStopped(Service service, Throwable cause) {
            logger.log(Level.FINE, AbstractService.this + " stopped.", cause);
            Object object = this.syncObject;
            synchronized (object) {
                this.stopped = true;
                this.syncObject.notify();
            }
        }
    }
}

