/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.service;

public class State
implements Comparable<State> {
    public static final State offline = new State("offline", 0);
    public static final State starting = new State("starting", 1);
    public static final State online = new State("online", 2);
    public static final State stopping = new State("stopping", 3);
    public static final State unknown = new State("unknown", 4);
    private final State basicState;
    private final String name;
    private final int ordinal;

    private State(String name, int ordinal) {
        this.basicState = this;
        this.name = name;
        this.ordinal = ordinal;
    }

    public State(State basicState, String name) {
        if (basicState == null) {
            throw new IllegalArgumentException("basic state must not be null");
        }
        this.basicState = basicState;
        this.name = name;
        this.ordinal = basicState.ordinal;
    }

    public State getBasicState() {
        return this.basicState;
    }

    public String getName() {
        return this.name;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int compareTo(State state) {
        return this.basicState.ordinal - state.basicState.ordinal;
    }

    public String toString() {
        if (this != this.basicState) {
            return String.valueOf(this.name) + " (" + this.basicState + ")";
        }
        return this.name;
    }
}

