/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.swing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class SortableTreeNode
implements MutableTreeNode {
    private MutableTreeNode parentNode;
    private Object userObject;
    private boolean allowsChildren;
    private List<MutableTreeNode> children = new ArrayList<MutableTreeNode>();

    public SortableTreeNode(boolean allowsChildren) {
        this(null, allowsChildren);
    }

    public SortableTreeNode(Object userObject) {
        this(userObject, true);
    }

    public SortableTreeNode(Object userObject, boolean allowsChildren) {
        this.allowsChildren = allowsChildren;
        this.userObject = userObject;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this.parentNode;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Enumeration<?> children() {
        return Collections.enumeration(this.children);
    }

    public void add(MutableTreeNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        this.children.add(index, child);
        child.setParent(this);
    }

    @Override
    public void remove(int index) {
        this.children.remove(index).setParent(null);
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.children.remove(node);
        node.setParent(null);
    }

    @Override
    public void removeFromParent() {
        if (this.parentNode != null) {
            this.parentNode.remove(this);
            this.parentNode = null;
        }
    }

    public void removeAll() {
        for (MutableTreeNode childNode : this.children) {
            childNode.setParent(null);
        }
        this.children.clear();
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this.parentNode = newParent;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void sort() {
        Collections.sort(this.children, new Comparator<MutableTreeNode>(){

            @Override
            public int compare(MutableTreeNode firstNode, MutableTreeNode secondNode) {
                if (!(firstNode instanceof SortableTreeNode) || !(secondNode instanceof SortableTreeNode)) {
                    return 0;
                }
                SortableTreeNode firstSortableNode = (SortableTreeNode)firstNode;
                SortableTreeNode secondSortableNode = (SortableTreeNode)secondNode;
                if (firstSortableNode.userObject == null && secondSortableNode.userObject == null) {
                    return 0;
                }
                if (firstSortableNode.userObject == null && secondSortableNode.userObject != null) {
                    return -1;
                }
                if (firstSortableNode.userObject != null && secondSortableNode.userObject == null) {
                    return 1;
                }
                if (!(firstSortableNode.userObject instanceof Comparable) || !(secondSortableNode.userObject instanceof Comparable)) {
                    return 0;
                }
                return ((Comparable)firstSortableNode.userObject).compareTo(secondSortableNode.userObject);
            }
        });
    }

    public String toString() {
        return this.userObject != null ? this.userObject.toString() : null;
    }
}

