/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.telnet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.logging.Logging;
import net.pterodactylus.util.service.AbstractService;
import net.pterodactylus.util.telnet.Command;
import net.pterodactylus.util.telnet.HelpCommand;
import net.pterodactylus.util.telnet.QuitCommand;
import net.pterodactylus.util.text.StringEscaper;
import net.pterodactylus.util.text.TextException;

public class ControlConnection
extends AbstractService {
    private static final Logger logger = Logging.getLogger(ControlConnection.class.getName());
    private static final String LINEFEED = "\r\n";
    private final InputStream clientInputStream;
    private final OutputStream clientOutputStream;
    private final PrintWriter outputStreamWriter;
    Map<String, Command> commands = new HashMap<String, Command>();
    Map<String, Command> internalCommands = new HashMap<String, Command>();

    public ControlConnection(InputStream clientInputStream, OutputStream clientOutputStream) {
        this.clientInputStream = clientInputStream;
        this.clientOutputStream = clientOutputStream;
        this.outputStreamWriter = new PrintWriter(clientOutputStream);
        this.addCommand(new QuitCommand());
    }

    public void addCommand(Command command) {
        this.commands.put(command.getName().toLowerCase(), command);
        this.internalCommands.put("help", new HelpCommand(this.commands.values()));
    }

    public void addOutputLine(String line) {
        this.addOutputLines(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutputLines(String ... lines) {
        PrintWriter printWriter = this.outputStreamWriter;
        synchronized (printWriter) {
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.outputStreamWriter.println(line);
                ++n2;
            }
            this.outputStreamWriter.flush();
        }
    }

    @Override
    protected void serviceRun() {
        block14: {
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            try {
                try {
                    String line;
                    inputStreamReader = new InputStreamReader(this.clientInputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    boolean finished = false;
                    while (!finished && (line = bufferedReader.readLine()) != null) {
                        List<String> words;
                        if ((line = line.trim()).length() == 0) continue;
                        try {
                            words = StringEscaper.parseLine(line);
                        }
                        catch (TextException te1) {
                            this.writeReply(new Command.Reply(400).addLine("Syntax error."));
                            continue;
                        }
                        if (words.isEmpty()) continue;
                        String commandName = words.remove(0).toLowerCase();
                        List<Command> foundCommands = this.findCommand(commandName);
                        if (foundCommands.isEmpty()) {
                            this.writeReply(new Command.Reply(404).addLine("Command not found."));
                            continue;
                        }
                        if (foundCommands.size() == 1) {
                            Command command = foundCommands.get(0);
                            try {
                                Command.Reply commandReply = command.execute(words);
                                this.writeReply(commandReply);
                            }
                            catch (IOException ioe1) {
                                throw ioe1;
                            }
                            catch (Throwable t1) {
                                this.writeReply(new Command.Reply(500).addLine("Internal server error: " + t1.getMessage()));
                            }
                            if (!(command instanceof QuitCommand)) continue;
                            finished = true;
                            continue;
                        }
                        Command.Reply reply = new Command.Reply(300, "Multiple choices found:");
                        for (Command command : foundCommands) {
                            reply.addLine(command.getName());
                        }
                        this.writeReply(reply);
                    }
                }
                catch (IOException ioe1) {
                    logger.log(Level.INFO, "could not handle connection", ioe1);
                    Closer.close(this.outputStreamWriter);
                    Closer.close(bufferedReader);
                    Closer.close(inputStreamReader);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                Closer.close(this.outputStreamWriter);
                Closer.close(bufferedReader);
                Closer.close(inputStreamReader);
                throw throwable;
            }
            Closer.close(this.outputStreamWriter);
            Closer.close(bufferedReader);
            Closer.close(inputStreamReader);
        }
    }

    @Override
    protected void serviceStop() {
        Closer.close(this.clientInputStream);
        Closer.close(this.clientOutputStream);
    }

    private List<Command> findCommand(String name) {
        ArrayList<Command> foundCommands = new ArrayList<Command>();
        for (Command command : this.internalCommands.values()) {
            if (!command.getName().toLowerCase().startsWith(name.toLowerCase())) continue;
            foundCommands.add(command);
        }
        for (Command command : this.commands.values()) {
            if (!command.getName().toLowerCase().startsWith(name.toLowerCase())) continue;
            foundCommands.add(command);
        }
        return foundCommands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReply(Command.Reply reply) throws IOException {
        PrintWriter printWriter = this.outputStreamWriter;
        synchronized (printWriter) {
            if (reply == null) {
                this.outputStreamWriter.write("500 Internal server error.\r\n");
                this.outputStreamWriter.flush();
                return;
            }
            int status = reply.getStatus();
            List<String> lines = reply.getLines();
            int lineIndex = 0;
            int lineCount = lines.size();
            while (lineIndex < lineCount) {
                this.outputStreamWriter.write(String.valueOf(status) + (lineIndex < lineCount - 1 ? "-" : " ") + lines.get(lineIndex) + LINEFEED);
                ++lineIndex;
            }
            if (lines.size() == 0) {
                this.outputStreamWriter.write("200 OK.\r\n");
            }
            this.outputStreamWriter.flush();
        }
    }
}

