/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.telnet;

import java.util.Collection;
import java.util.List;
import net.pterodactylus.util.telnet.AbstractCommand;
import net.pterodactylus.util.telnet.Command;

public class HelpCommand
extends AbstractCommand {
    private final Collection<Command> commands;

    public HelpCommand(Collection<Command> commands) {
        super("HELP", "outputs help of all commands");
        this.commands = commands;
    }

    @Override
    public Command.Reply execute(List<String> parameters) {
        Command.Reply reply = new Command.Reply(200);
        if (parameters.isEmpty()) {
            for (Command command : this.commands) {
                reply.addLine(String.valueOf(command.getName().toUpperCase()) + ": " + command.getBriefDescription());
            }
        } else {
            String commandName = parameters.get(0).toLowerCase();
            for (Command command : this.commands) {
                if (!command.getName().toLowerCase().startsWith(commandName)) continue;
                reply.addLine(String.valueOf(command.getName().toUpperCase()) + ": " + command.getBriefDescription());
                for (String detailDescription : command.getDetailedDescription()) {
                    reply.addLine("  " + detailDescription);
                }
            }
        }
        return reply;
    }
}

