/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.telnet;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.logging.Logging;
import net.pterodactylus.util.service.AbstractService;
import net.pterodactylus.util.telnet.Command;
import net.pterodactylus.util.telnet.ControlConnection;
import net.pterodactylus.util.telnet.GarbageCollectionCommand;
import net.pterodactylus.util.telnet.MemoryCommand;

public class TelnetControl
extends AbstractService {
    private static final Logger logger = Logging.getLogger(TelnetControl.class.getName());
    private ServerSocket serverSocket;
    private int listenPort = 20013;
    private final Map<String, Command> commands = new HashMap<String, Command>();

    public TelnetControl() {
        super("Telnet Control");
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public void addCommand(Command command) {
        this.commands.put(command.getName().toLowerCase(), command);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void serviceRun() {
        TelnetControl.logger.log(Level.INFO, "starting telnet control main loop");
        try {
            this.serverSocket = new ServerSocket(this.listenPort);
            if (true) ** GOTO lbl21
        }
        catch (IOException ioe1) {
            TelnetControl.logger.log(Level.SEVERE, "could not create server socket on port " + this.listenPort, ioe1);
            return;
        }
        do {
            try {
                clientSocket = this.serverSocket.accept();
                TelnetControl.logger.log(Level.INFO, "acception client connection on " + clientSocket.getRemoteSocketAddress());
                controlConnection = new ControlConnection(clientSocket.getInputStream(), clientSocket.getOutputStream());
                for (Command command : this.commands.values()) {
                    controlConnection.addCommand(command);
                }
                controlConnection.start();
            }
            catch (IOException ioe1) {
                if (this.shouldStop()) continue;
                TelnetControl.logger.log(Level.WARNING, "could not accept client connection", ioe1);
            }
lbl21:
            // 4 sources

        } while (!this.shouldStop());
        TelnetControl.logger.log(Level.INFO, "stopped telnet control main loop.");
    }

    @Override
    protected void serviceStop() {
        Closer.close(this.serverSocket);
    }

    public static void main(String ... arguments) throws InterruptedException {
        TelnetControl telnetControl = new TelnetControl();
        telnetControl.init();
        telnetControl.addCommand(new MemoryCommand());
        telnetControl.addCommand(new GarbageCollectionCommand());
        telnetControl.start();
        Thread.sleep(120000L);
    }
}

