/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import net.pterodactylus.util.template.ContainerPart;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateException;
import net.pterodactylus.util.template.TemplateParser;

class ConditionalPart
extends ContainerPart {
    private final Condition condition;

    public ConditionalPart(int line, int column, Condition condition) {
        super(line, column);
        this.condition = condition;
        if (condition instanceof AbstractCondition) {
            ((AbstractCondition)condition).setConditionalPart(this);
        }
    }

    @Override
    public void render(TemplateContext templateContext, Writer writer) throws TemplateException {
        if (this.condition.isAllowed(templateContext)) {
            super.render(templateContext, writer);
        }
    }

    private static abstract class AbstractCondition
    implements Condition {
        private ConditionalPart conditionalPart;

        protected AbstractCondition() {
        }

        protected ConditionalPart getConditionalPart() {
            return this.conditionalPart;
        }

        protected void setConditionalPart(ConditionalPart conditionalPart) {
            this.conditionalPart = conditionalPart;
        }
    }

    public static class AndCondition
    extends AbstractCondition {
        private final Collection<Condition> conditions;

        public AndCondition(Condition ... conditions) {
            this(Arrays.asList(conditions));
        }

        public AndCondition(Collection<Condition> conditions) {
            this.conditions = conditions;
        }

        @Override
        public boolean isAllowed(TemplateContext templateContext) throws TemplateException {
            for (Condition condition : this.conditions) {
                if (condition.isAllowed(templateContext)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected void setConditionalPart(ConditionalPart conditionalPart) {
            super.setConditionalPart(conditionalPart);
            for (Condition condition : this.conditions) {
                if (!(condition instanceof AbstractCondition)) continue;
                ((AbstractCondition)condition).setConditionalPart(conditionalPart);
            }
        }
    }

    public static interface Condition {
        public boolean isAllowed(TemplateContext var1) throws TemplateException;
    }

    public static class DataCondition
    extends AbstractCondition {
        private final boolean invert;
        private final String itemName;
        private final TemplateParser.Filters filters;

        public DataCondition(String itemName) {
            this(itemName, new TemplateParser.Filters(), false);
        }

        public DataCondition(String itemName, boolean invert) {
            this(itemName, new TemplateParser.Filters(), invert);
        }

        public DataCondition(String itemName, TemplateParser.Filters filters, boolean invert) {
            this.invert = invert;
            this.itemName = itemName;
            this.filters = filters;
        }

        @Override
        public boolean isAllowed(TemplateContext templateContext) throws TemplateException {
            return Boolean.valueOf(String.valueOf(this.filters.filter(this.getConditionalPart().getLine(), this.getConditionalPart().getColumn(), templateContext, templateContext.get(this.itemName)))) ^ this.invert;
        }
    }

    public static class DataTextCondition
    extends AbstractCondition {
        private final boolean invert;
        private final String text;
        private final TemplateParser.Filters filters;

        public DataTextCondition(String text) {
            this(text, new TemplateParser.Filters(), false);
        }

        public DataTextCondition(String text, TemplateParser.Filters filters, boolean invert) {
            this.invert = invert;
            this.text = text;
            this.filters = filters;
        }

        @Override
        public boolean isAllowed(TemplateContext templateContext) throws TemplateException {
            return Boolean.valueOf(String.valueOf(this.filters.filter(this.getConditionalPart().getLine(), this.getConditionalPart().getColumn(), templateContext, this.text))) ^ this.invert;
        }

        public String toString() {
            return "(" + this.text + " = " + !this.invert + ")";
        }
    }

    public static class NotCondition
    extends AbstractCondition {
        private final Condition condition;

        public NotCondition(Condition condition) {
            this.condition = condition;
        }

        @Override
        public boolean isAllowed(TemplateContext templateContext) throws TemplateException {
            return !this.condition.isAllowed(templateContext);
        }

        @Override
        protected void setConditionalPart(ConditionalPart conditionalPart) {
            super.setConditionalPart(conditionalPart);
            if (this.condition instanceof AbstractCondition) {
                ((AbstractCondition)this.condition).setConditionalPart(conditionalPart);
            }
        }
    }

    public static class NullDataCondition
    extends AbstractCondition {
        private final boolean invert;
        private final String itemName;

        public NullDataCondition(String itemName) {
            this(itemName, false);
        }

        public NullDataCondition(String itemName, boolean invert) {
            this.invert = invert;
            this.itemName = itemName;
        }

        @Override
        public boolean isAllowed(TemplateContext templateContext) throws TemplateException {
            return templateContext.get(this.itemName) == null ^ this.invert;
        }
    }

    public static class OrCondition
    extends AbstractCondition {
        private final Collection<Condition> conditions;

        public OrCondition(Condition ... conditions) {
            this(Arrays.asList(conditions));
        }

        public OrCondition(Collection<Condition> conditions) {
            this.conditions = conditions;
        }

        @Override
        public boolean isAllowed(TemplateContext templateContext) throws TemplateException {
            for (Condition condition : this.conditions) {
                if (!condition.isAllowed(templateContext)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void setConditionalPart(ConditionalPart conditionalPart) {
            super.setConditionalPart(conditionalPart);
            for (Condition condition : this.conditions) {
                if (!(condition instanceof AbstractCondition)) continue;
                ((AbstractCondition)condition).setConditionalPart(conditionalPart);
            }
        }
    }
}

