/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.pterodactylus.util.collection.Pagination;
import net.pterodactylus.util.template.Plugin;
import net.pterodactylus.util.template.TemplateContext;

public class PaginationPlugin
implements Plugin {
    @Override
    public void execute(TemplateContext templateContext, Map<String, String> parameters) {
        String listKey = parameters.get("list");
        String pageSizeString = parameters.get("pagesize");
        String pageKey = parameters.get("page");
        String paginationKey = parameters.get("key");
        if (pageKey == null) {
            pageKey = "page";
        }
        if (paginationKey == null) {
            paginationKey = "pagination";
        }
        String pageString = String.valueOf(templateContext.get(pageKey));
        int page = 0;
        try {
            page = Integer.parseInt(pageString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int pageSize = 25;
        try {
            pageSize = Integer.parseInt(pageSizeString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        List list = (List)templateContext.get(listKey);
        Pagination pagination = new Pagination(list == null ? Collections.emptyList() : list, pageSize).setPage(page);
        templateContext.set(paginationKey, pagination);
    }
}

