/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

public class TemplateException
extends RuntimeException {
    private final int line;
    private final int column;

    public TemplateException() {
        this(0, 0);
    }

    public TemplateException(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public TemplateException(String message) {
        this(0, 0, message);
    }

    public TemplateException(int line, int column, String message) {
        super(String.valueOf(message) + " (line " + line + ", column " + column + ")");
        this.line = line;
        this.column = column;
    }

    public TemplateException(Throwable cause) {
        this(0, 0, cause);
    }

    public TemplateException(int line, int column, Throwable cause) {
        super(cause);
        this.line = line;
        this.column = column;
    }

    public TemplateException(String message, Throwable cause) {
        this(0, 0, message, cause);
    }

    public TemplateException(int line, int column, String message, Throwable cause) {
        super(String.valueOf(message) + " (line " + line + ", column " + column + ")", cause);
        this.line = line;
        this.column = column;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }
}

