/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.pterodactylus.util.template.ConditionalPart;
import net.pterodactylus.util.template.ContainerPart;
import net.pterodactylus.util.template.EmptyLoopPart;
import net.pterodactylus.util.template.Filter;
import net.pterodactylus.util.template.FilteredPart;
import net.pterodactylus.util.template.FilteredTextPart;
import net.pterodactylus.util.template.LoopPart;
import net.pterodactylus.util.template.Part;
import net.pterodactylus.util.template.PluginPart;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateException;
import net.pterodactylus.util.template.TemplatePart;
import net.pterodactylus.util.template.TextPart;
import net.pterodactylus.util.template.WhitespaceRemover;

public class TemplateParser {
    public static Template parse(Reader input) throws TemplateException {
        return TemplateParser.parse(input, new WhitespaceRemover.NoWhitespaceRemover());
    }

    public static Template parse(Reader input, WhitespaceRemover whitespaceRemover) throws TemplateException {
        Template template = new Template();
        template.add(TemplateParser.extractParts(input, whitespaceRemover));
        return template;
    }

    private static Part extractParts(Reader input, WhitespaceRemover whitespaceRemover) throws TemplateException {
        BufferedReader bufferedInputReader = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        Stack<String> commandStack = new Stack<String>();
        Stack<ContainerPart> partsStack = new Stack<ContainerPart>();
        Stack<String> lastCollectionName = new Stack<String>();
        Stack<String> lastLoopName = new Stack<String>();
        Stack<ConditionalPart.AbstractCondition> lastCondition = new Stack<ConditionalPart.AbstractCondition>();
        Stack<ArrayList<ConditionalPart.Condition>> lastConditions = new Stack<ArrayList<ConditionalPart.Condition>>();
        Stack<String> lastIfCommand = new Stack<String>();
        ContainerPart parts = new ContainerPart(1, 1);
        StringBuilder currentTextPart = new StringBuilder();
        boolean gotLeftAngleBracket = false;
        boolean inAngleBracket = false;
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        int line = 1;
        int column = 1;
        int startOfTagLine = 1;
        int startOfTagColumn = 1;
        while (true) {
            int nextCharacter;
            try {
                nextCharacter = bufferedInputReader.read();
                ++column;
            }
            catch (IOException ioe1) {
                throw new TemplateException(line, column, "Can not read template.", ioe1);
            }
            if (nextCharacter == -1) break;
            if (nextCharacter == 10) {
                ++line;
                column = 1;
            }
            if (inAngleBracket) {
                if (inSingleQuotes) {
                    if (nextCharacter == 39) {
                        inSingleQuotes = false;
                    }
                    currentTextPart.append((char)nextCharacter);
                    continue;
                }
                if (inDoubleQuotes) {
                    if (nextCharacter == 34) {
                        inDoubleQuotes = false;
                    }
                    currentTextPart.append((char)nextCharacter);
                    continue;
                }
                if (nextCharacter == 39) {
                    inSingleQuotes = true;
                    currentTextPart.append((char)nextCharacter);
                    continue;
                }
                if (nextCharacter == 34) {
                    inDoubleQuotes = true;
                    currentTextPart.append((char)nextCharacter);
                    continue;
                }
                if (nextCharacter == 62) {
                    inAngleBracket = false;
                    String tagContent = currentTextPart.toString().trim();
                    currentTextPart.setLength(0);
                    Iterator<String> tokens = TemplateParser.parseTag(tagContent).iterator();
                    if (!tokens.hasNext()) {
                        throw new TemplateException(startOfTagLine, startOfTagColumn, "empty tag found");
                    }
                    String function = tokens.next();
                    if (function.startsWith("/")) {
                        String lastFunction = (String)commandStack.pop();
                        if (!("/" + lastFunction).equals(function)) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "unbalanced template, /" + lastFunction + " expected, " + function + " found");
                        }
                        if (lastFunction.equals("foreach")) {
                            ContainerPart innerParts = parts;
                            parts = (ContainerPart)partsStack.pop();
                            lastCollectionName.pop();
                            lastLoopName.pop();
                            parts.add(innerParts);
                            continue;
                        }
                        if (lastFunction.equals("first") || lastFunction.equals("notfirst") || lastFunction.equals("last") || lastFunction.equals("notlast") || lastFunction.equals("odd") || lastFunction.equals("even")) {
                            ContainerPart innerParts = parts;
                            parts = (ContainerPart)partsStack.pop();
                            parts.add(innerParts);
                            continue;
                        }
                        if (!lastFunction.equals("if")) continue;
                        ContainerPart innerParts = parts;
                        parts = (ContainerPart)partsStack.pop();
                        lastCondition.pop();
                        lastConditions.pop();
                        parts.add(innerParts);
                        lastIfCommand.pop();
                        continue;
                    }
                    if (function.equals("foreach")) {
                        Filters filters;
                        if (!tokens.hasNext()) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "foreach requires at least one parameter");
                        }
                        String collectionName = tokens.next();
                        String itemName = null;
                        if (tokens.hasNext()) {
                            itemName = tokens.next();
                        }
                        String loopName = "loop";
                        if (tokens.hasNext()) {
                            loopName = tokens.next();
                        }
                        if (loopName == null) {
                            loopName = "loop";
                            filters = TemplateParser.parseFilters(startOfTagLine, startOfTagColumn, tokens, true);
                        } else {
                            filters = TemplateParser.parseFilters(startOfTagLine, startOfTagColumn, tokens);
                        }
                        partsStack.push(parts);
                        parts = new LoopPart(startOfTagLine, startOfTagColumn, collectionName, itemName, loopName, filters);
                        commandStack.push("foreach");
                        lastCollectionName.push(collectionName);
                        lastLoopName.push(loopName);
                        continue;
                    }
                    if (function.equals("foreachelse")) {
                        if (!"foreach".equals(commandStack.peek())) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "foreachelse is only allowed in foreach");
                        }
                        ((ContainerPart)partsStack.peek()).add(parts);
                        parts = new EmptyLoopPart(startOfTagLine, startOfTagColumn, (String)lastCollectionName.peek());
                        continue;
                    }
                    if (function.equals("first")) {
                        if (!commandStack.contains("foreach")) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "first is only allowed in foreach");
                        }
                        partsStack.push(parts);
                        String loopName = (String)lastLoopName.peek();
                        parts = new ConditionalPart(startOfTagLine, startOfTagColumn, new ConditionalPart.DataCondition(String.valueOf(loopName) + ".first"));
                        commandStack.push("first");
                        continue;
                    }
                    if (function.equals("notfirst")) {
                        if (!commandStack.contains("foreach")) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "notfirst is only allowed in foreach");
                        }
                        partsStack.push(parts);
                        String loopName = (String)lastLoopName.peek();
                        parts = new ConditionalPart(startOfTagLine, startOfTagColumn, new ConditionalPart.DataCondition(String.valueOf(loopName) + ".first", true));
                        commandStack.push("notfirst");
                        continue;
                    }
                    if (function.equals("last")) {
                        if (!commandStack.contains("foreach")) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "last is only allowed in foreach");
                        }
                        partsStack.push(parts);
                        String loopName = (String)lastLoopName.peek();
                        parts = new ConditionalPart(startOfTagLine, startOfTagColumn, new ConditionalPart.DataCondition(String.valueOf(loopName) + ".last"));
                        commandStack.push("last");
                        continue;
                    }
                    if (function.equals("notlast")) {
                        if (!commandStack.contains("foreach")) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "notlast is only allowed in foreach");
                        }
                        partsStack.push(parts);
                        String loopName = (String)lastLoopName.peek();
                        parts = new ConditionalPart(startOfTagLine, startOfTagColumn, new ConditionalPart.DataCondition(String.valueOf(loopName) + ".last", true));
                        commandStack.push("notlast");
                        continue;
                    }
                    if (function.equals("odd")) {
                        if (!commandStack.contains("foreach")) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "odd is only allowed in foreach");
                        }
                        partsStack.push(parts);
                        String loopName = (String)lastLoopName.peek();
                        parts = new ConditionalPart(startOfTagLine, startOfTagColumn, new ConditionalPart.DataCondition(String.valueOf(loopName) + ".odd"));
                        commandStack.push("odd");
                        continue;
                    }
                    if (function.equals("even")) {
                        if (!commandStack.contains("foreach")) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "even is only allowed in foreach");
                        }
                        partsStack.push(parts);
                        String loopName = (String)lastLoopName.peek();
                        parts = new ConditionalPart(startOfTagLine, startOfTagColumn, new ConditionalPart.DataCondition(String.valueOf(loopName) + ".even"));
                        commandStack.push("even");
                        continue;
                    }
                    if (function.equals("if") || function.equals("ifnull")) {
                        if (!tokens.hasNext()) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "if requires one or two parameters");
                        }
                        String itemName = tokens.next();
                        boolean checkForNull = function.equals("ifnull");
                        boolean invert = false;
                        if (itemName.equals("!")) {
                            invert = true;
                            if (!tokens.hasNext()) {
                                throw new TemplateException(startOfTagLine, startOfTagColumn, "if ! requires one parameter");
                            }
                            itemName = tokens.next();
                        } else if (itemName.startsWith("!")) {
                            invert = true;
                            itemName = itemName.substring(1);
                        }
                        boolean directText = false;
                        if (itemName.startsWith("=")) {
                            if (checkForNull) {
                                throw new TemplateException(startOfTagLine, startOfTagColumn, "direct text ('=') with ifnull is not allowed");
                            }
                            itemName = itemName.substring(1);
                            directText = true;
                        }
                        Filters filters = TemplateParser.parseFilters(startOfTagLine, startOfTagColumn, tokens);
                        partsStack.push(parts);
                        ConditionalPart.AbstractCondition condition = checkForNull ? new ConditionalPart.NullDataCondition(itemName, invert) : (directText ? new ConditionalPart.DataTextCondition(itemName, filters, invert) : new ConditionalPart.DataCondition(itemName, filters, invert));
                        parts = new ConditionalPart(startOfTagLine, startOfTagColumn, condition);
                        commandStack.push("if");
                        lastCondition.push(condition);
                        lastConditions.push(new ArrayList<ConditionalPart.Condition>(Arrays.asList(condition)));
                        lastIfCommand.push("if");
                        continue;
                    }
                    if (function.equals("else")) {
                        if (!"if".equals(commandStack.peek())) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "else is only allowed in if");
                        }
                        if (!"if".equals(lastIfCommand.peek()) && !"elseif".equals(lastIfCommand.peek())) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "else may only follow if or elseif");
                        }
                        ((ContainerPart)partsStack.peek()).add(parts);
                        ConditionalPart.NotCondition condition = new ConditionalPart.NotCondition(new ConditionalPart.OrCondition((Collection)lastConditions.peek()));
                        parts = new ConditionalPart(startOfTagLine, startOfTagColumn, condition);
                        lastIfCommand.pop();
                        lastIfCommand.push("else");
                        continue;
                    }
                    if (function.equals("elseif") || function.equals("elseifnull")) {
                        if (!"if".equals(commandStack.peek())) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "elseif is only allowed in if");
                        }
                        if (!"if".equals(lastIfCommand.peek()) && !"elseif".equals(lastIfCommand.peek())) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "elseif is only allowed after if or elseif");
                        }
                        if (!tokens.hasNext()) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "elseif requires one or two parameters");
                        }
                        String itemName = tokens.next();
                        boolean checkForNull = function.equals("elseifnull");
                        boolean invert = false;
                        if (itemName.equals("!")) {
                            invert = true;
                            if (!tokens.hasNext()) {
                                throw new TemplateException(startOfTagLine, startOfTagColumn, "if ! requires one parameter");
                            }
                            itemName = tokens.next();
                        } else if (itemName.startsWith("!")) {
                            invert = true;
                            itemName = itemName.substring(1);
                        }
                        Filters filters = TemplateParser.parseFilters(startOfTagLine, startOfTagColumn, tokens);
                        ((ContainerPart)partsStack.peek()).add(parts);
                        ConditionalPart.AndCondition condition = new ConditionalPart.AndCondition(new ConditionalPart.NotCondition((ConditionalPart.Condition)lastCondition.pop()), checkForNull ? new ConditionalPart.NullDataCondition(itemName, invert) : new ConditionalPart.DataCondition(itemName, filters, invert));
                        parts = new ConditionalPart(startOfTagLine, startOfTagColumn, condition);
                        lastCondition.push(condition);
                        ((List)lastConditions.peek()).add(condition);
                        lastIfCommand.pop();
                        lastIfCommand.push("elseif");
                        continue;
                    }
                    if (function.equals("include")) {
                        if (!tokens.hasNext()) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "include requires one parameter");
                        }
                        String templateName = tokens.next();
                        Map<String, String> parameters = TemplateParser.parseParameters(startOfTagLine, startOfTagColumn, tokens);
                        parts.add(new TemplatePart(startOfTagLine, startOfTagColumn, templateName, parameters));
                        continue;
                    }
                    boolean directText = false;
                    boolean plugin = false;
                    String itemName = function;
                    if (function.equals("=")) {
                        if (!tokens.hasNext()) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "empty tag found");
                        }
                        itemName = tokens.next();
                        directText = true;
                    } else if (function.equals(":")) {
                        if (!tokens.hasNext()) {
                            throw new TemplateException(startOfTagLine, startOfTagColumn, "missing plugin name");
                        }
                        itemName = tokens.next();
                        plugin = true;
                    } else if (function.startsWith(":")) {
                        itemName = function.substring(1);
                        plugin = true;
                    } else if (function.startsWith("=")) {
                        itemName = function.substring(1);
                        directText = true;
                    }
                    if (plugin) {
                        Map<String, String> pluginParameters = null;
                        pluginParameters = TemplateParser.parseParameters(startOfTagLine, startOfTagColumn, tokens);
                        parts.add(new PluginPart(startOfTagLine, startOfTagColumn, itemName, pluginParameters));
                        continue;
                    }
                    Filters filterDefinitions = TemplateParser.parseFilters(startOfTagLine, startOfTagColumn, tokens);
                    if (directText) {
                        parts.add(new FilteredTextPart(startOfTagLine, startOfTagColumn, itemName, filterDefinitions));
                        continue;
                    }
                    parts.add(new FilteredPart(startOfTagLine, startOfTagColumn, itemName, filterDefinitions));
                    continue;
                }
                currentTextPart.append((char)nextCharacter);
                continue;
            }
            if (gotLeftAngleBracket) {
                if (nextCharacter == 37) {
                    startOfTagLine = line;
                    startOfTagColumn = column;
                    inAngleBracket = true;
                    if (currentTextPart.length() > 0) {
                        parts.add(new TextPart(startOfTagLine, startOfTagColumn, whitespaceRemover.removeWhitespace(currentTextPart.toString())));
                        currentTextPart.setLength(0);
                    }
                } else {
                    currentTextPart.append('<').append((char)nextCharacter);
                }
                gotLeftAngleBracket = false;
                continue;
            }
            if (nextCharacter == 60) {
                gotLeftAngleBracket = true;
                continue;
            }
            currentTextPart.append((char)nextCharacter);
        }
        if (currentTextPart.length() > 0) {
            parts.add(new TextPart(startOfTagLine, startOfTagColumn, currentTextPart.toString()));
        }
        if (!partsStack.isEmpty()) {
            throw new TemplateException(line, column, "Unbalanced template.");
        }
        return parts;
    }

    private static Filters parseFilters(int line, int column, Iterator<String> tokens) {
        return TemplateParser.parseFilters(line, column, tokens, false);
    }

    /*
     * Unable to fully structure code
     */
    private static Filters parseFilters(int line, int column, Iterator<String> tokens, boolean pipeTokenPresent) {
        filterDefinitions = new Filters();
        if (pipeTokenPresent || !tokens.hasNext() || tokens.next() == null) ** GOTO lbl10
        throw new TemplateException(line, column, "expected \"|\" token");
lbl-1000:
        // 1 sources

        {
            filterName = tokens.next();
            if (filterName == null) {
                throw new TemplateException(line, column, "missing filter name");
            }
            filterParameters = TemplateParser.parseParameters(line, column, tokens);
            filterDefinitions.add(new FilterDefinition(filterName, filterParameters));
lbl10:
            // 2 sources

            ** while (tokens.hasNext())
        }
lbl11:
        // 1 sources

        return filterDefinitions;
    }

    private static Map<String, String> parseParameters(int line, int column, Iterator<String> tokens) throws TemplateException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        while (tokens.hasNext()) {
            String parameterToken = tokens.next();
            if (parameterToken == null) break;
            int equals = parameterToken.indexOf(61);
            if (equals == -1) {
                throw new TemplateException(line, column, "found parameter without \"=\" sign");
            }
            String key = parameterToken.substring(0, equals).trim();
            String value = parameterToken.substring(equals + 1);
            parameters.put(key, value);
        }
        return parameters;
    }

    static List<String> parseTag(String tagContent) {
        ArrayList<String> expressions = new ArrayList<String>();
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        boolean inBackslash = false;
        StringBuilder currentExpression = new StringBuilder();
        char[] cArray = tagContent.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (inSingleQuotes) {
                if (c == '\'') {
                    inSingleQuotes = false;
                } else {
                    currentExpression.append(c);
                }
            } else if (inBackslash) {
                currentExpression.append(c);
                inBackslash = false;
            } else if (inDoubleQuotes) {
                if (c == '\"') {
                    inDoubleQuotes = false;
                } else if (c == '\\') {
                    inBackslash = true;
                } else {
                    currentExpression.append(c);
                }
            } else if (c == '\'') {
                inSingleQuotes = true;
            } else if (c == '\"') {
                inDoubleQuotes = true;
            } else if (c == '\\') {
                inBackslash = true;
            } else if (c == '|') {
                if (currentExpression.toString().trim().length() > 0) {
                    expressions.add(currentExpression.toString());
                    currentExpression.setLength(0);
                }
                expressions.add(null);
            } else if (c == ' ') {
                if (currentExpression.length() > 0) {
                    expressions.add(currentExpression.toString());
                    currentExpression.setLength(0);
                }
            } else {
                currentExpression.append(c);
            }
            ++n2;
        }
        if (currentExpression.length() > 0) {
            expressions.add(currentExpression.toString());
        }
        return expressions;
    }

    public static class FilterDefinition {
        private final String name;
        private final Map<String, String> parameters;

        public FilterDefinition(String name, Map<String, String> parameters) {
            this.name = name;
            this.parameters = parameters;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }
    }

    public static class Filters
    extends ArrayList<FilterDefinition> {
        public Object filter(int line, int column, TemplateContext templateContext, Object data) {
            Object output = data;
            for (FilterDefinition filterDefinition : this) {
                Filter filter = templateContext.getFilter(filterDefinition.getName());
                if (filter == null) {
                    throw new TemplateException(line, column, "Filter \u201c" + filterDefinition.getName() + "\u201d not found.");
                }
                TemplateContext filterTemplateContext = new TemplateContext(templateContext, true);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                for (Map.Entry<String, String> parameter : filterDefinition.getParameters().entrySet()) {
                    if (parameter.getValue().startsWith("=")) {
                        parameters.put(parameter.getKey(), parameter.getValue().substring(1));
                        continue;
                    }
                    parameters.put(parameter.getKey(), templateContext.get(parameter.getValue()));
                }
                try {
                    output = filter.format(filterTemplateContext, output, parameters);
                }
                catch (Exception e1) {
                    throw new TemplateException(line, column, "Error while applying filter.", e1);
                }
            }
            return output;
        }
    }
}

