/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.thread;

public class StoppableDelay
implements Runnable {
    private final long startTime = System.currentTimeMillis();
    private final long delay;
    private final Runnable startRunnable;
    private final Runnable stopRunnable;
    private volatile boolean finished;

    public StoppableDelay(Runnable startRunnable, Runnable stopRunnable) {
        this(startRunnable, stopRunnable, 500L);
    }

    public StoppableDelay(Runnable startRunnable, Runnable stopRunnable, long delay) {
        this.startRunnable = startRunnable;
        this.stopRunnable = stopRunnable;
        this.delay = delay;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void finish() {
        this.finished = true;
        this.stopRunnable.run();
    }

    @Override
    public void run() {
        while (!this.finished && System.currentTimeMillis() - this.startTime < this.delay) {
            try {
                Thread.sleep(this.startTime + this.delay - System.currentTimeMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.finished) {
            return;
        }
        this.startRunnable.run();
    }
}

