/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.validation;

import net.pterodactylus.util.validation.Validator;

public class LongRangeValidator
implements Validator<Long> {
    private final long lowerBound;
    private final long upperBound;

    public LongRangeValidator(long lowerBound, long upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public boolean validate(Long value) {
        return this.lowerBound <= value && this.upperBound >= value;
    }

    public String toString() {
        return "((x >= " + this.lowerBound + ") && (x <= " + this.upperBound + "))";
    }
}

