/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application;

import de.todesbaum.jsite.application.FileOption;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.pterodactylus.util.io.MimeTypes;

public class Project
implements Comparable<Project> {
    protected String name;
    protected String description;
    protected String insertURI;
    protected String requestURI;
    protected String indexFile;
    protected String localPath;
    protected String path;
    protected long lastInsertionTime;
    protected int edition;
    private boolean alwaysForceInserts;
    private boolean ignoreHiddenFiles;
    protected Map<String, FileOption> fileOptions = new HashMap<String, FileOption>();

    public Project() {
    }

    public Project(Project project) {
        this.name = project.name;
        this.description = project.description;
        this.insertURI = project.insertURI;
        this.requestURI = project.requestURI;
        this.path = project.path;
        this.edition = project.edition;
        this.localPath = project.localPath;
        this.indexFile = project.indexFile;
        this.lastInsertionTime = project.lastInsertionTime;
        this.alwaysForceInserts = project.alwaysForceInserts;
        this.ignoreHiddenFiles = project.ignoreHiddenFiles;
        this.fileOptions = new HashMap<String, FileOption>(project.fileOptions);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getIndexFile() {
        return this.indexFile;
    }

    public void setIndexFile(String indexFile) {
        this.indexFile = indexFile;
    }

    public long getLastInsertionTime() {
        return this.lastInsertionTime;
    }

    public void setLastInsertionTime(long lastInserted) {
        this.lastInsertionTime = lastInserted;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getInsertURI() {
        return this.insertURI;
    }

    public void setInsertURI(String insertURI) {
        this.insertURI = Project.shortenURI(insertURI);
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = Project.shortenURI(requestURI);
    }

    public boolean isAlwaysForceInsert() {
        return this.alwaysForceInserts;
    }

    public void setAlwaysForceInsert(boolean alwaysForceInsert) {
        this.alwaysForceInserts = alwaysForceInsert;
    }

    public boolean isIgnoreHiddenFiles() {
        return this.ignoreHiddenFiles;
    }

    public void setIgnoreHiddenFiles(boolean ignoreHiddenFiles) {
        this.ignoreHiddenFiles = ignoreHiddenFiles;
    }

    public String toString() {
        return this.name;
    }

    private static String shortenURI(String uri) {
        String shortUri = uri;
        if (shortUri.startsWith("freenet:")) {
            shortUri = shortUri.substring("freenet:".length());
        }
        if (shortUri.startsWith("SSK@")) {
            shortUri = shortUri.substring("SSK@".length());
        }
        if (shortUri.startsWith("USK@")) {
            shortUri = shortUri.substring("USK@".length());
        }
        if (shortUri.endsWith("/")) {
            shortUri = shortUri.substring(0, shortUri.length() - 1);
        }
        return shortUri;
    }

    public String shortenFilename(File file) {
        String filename = file.getPath();
        if (filename.startsWith(this.localPath) && (filename = filename.substring(this.localPath.length())).startsWith(File.separator)) {
            filename = filename.substring(1);
        }
        return filename;
    }

    public FileOption getFileOption(String filename) {
        FileOption fileOption = this.fileOptions.get(filename);
        if (fileOption == null) {
            fileOption = new FileOption(MimeTypes.getMimeType(filename.substring(filename.lastIndexOf(46) + 1)));
            this.fileOptions.put(filename, fileOption);
        }
        return fileOption;
    }

    public void setFileOption(String filename, FileOption fileOption) {
        if (fileOption != null) {
            this.fileOptions.put(filename, fileOption);
        } else {
            this.fileOptions.remove(filename);
        }
    }

    public Map<String, FileOption> getFileOptions() {
        return Collections.unmodifiableMap(this.fileOptions);
    }

    public void setFileOptions(Map<String, FileOption> fileOptions) {
        this.fileOptions.clear();
        this.fileOptions.putAll(fileOptions);
    }

    @Override
    public int compareTo(Project project) {
        return this.name.compareToIgnoreCase(project.name);
    }

    public int getEdition() {
        return this.edition;
    }

    public void setEdition(int edition) {
        this.edition = edition;
    }

    public String getFinalRequestURI(int offset) {
        return "USK@" + this.requestURI + "/" + this.path + "/" + (this.edition + offset) + "/";
    }

    public void onSuccessfulInsert() {
        for (Map.Entry<String, FileOption> fileOptionEntry : this.fileOptions.entrySet()) {
            FileOption fileOption = fileOptionEntry.getValue();
            if (fileOption.getCurrentHash() != null && fileOption.getCurrentHash().length() > 0 && (!fileOption.getCurrentHash().equals(fileOption.getLastInsertHash()) || fileOption.isForceInsert())) {
                fileOption.setLastInsertEdition(this.edition);
                fileOption.setLastInsertHash(fileOption.getCurrentHash());
                fileOption.setLastInsertFilename(fileOption.hasChangedName() ? fileOption.getChangedName() : fileOptionEntry.getKey());
            }
            fileOption.setForceInsert(false);
        }
    }
}

