/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application;

import de.todesbaum.jsite.application.AbortedException;
import de.todesbaum.jsite.application.FileOption;
import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.InsertListener;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.gui.FileScanner;
import de.todesbaum.jsite.gui.FileScannerListener;
import de.todesbaum.util.freenet.fcp2.Client;
import de.todesbaum.util.freenet.fcp2.ClientPutComplexDir;
import de.todesbaum.util.freenet.fcp2.ClientPutDir;
import de.todesbaum.util.freenet.fcp2.Command;
import de.todesbaum.util.freenet.fcp2.Connection;
import de.todesbaum.util.freenet.fcp2.DirectFileEntry;
import de.todesbaum.util.freenet.fcp2.FileEntry;
import de.todesbaum.util.freenet.fcp2.Message;
import de.todesbaum.util.freenet.fcp2.PriorityClass;
import de.todesbaum.util.freenet.fcp2.RedirectFileEntry;
import de.todesbaum.util.freenet.fcp2.Verbosity;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.io.StreamCopier;

public class ProjectInserter
implements FileScannerListener,
Runnable {
    private static final Logger logger = Logger.getLogger(ProjectInserter.class.getName());
    private static final int random = (int)(Math.random() * 2.147483647E9);
    private static int counter = 0;
    private List<InsertListener> insertListeners = new ArrayList<InsertListener>();
    protected Freenet7Interface freenetInterface;
    protected Project project;
    private FileScanner fileScanner;
    protected final Object lockObject = new Object();
    private String tempDirectory;
    private Connection connection;
    private volatile boolean cancelled = false;
    private StreamCopier.ProgressListener progressListener;
    private boolean useEarlyEncode;
    private PriorityClass priority;
    private ClientPutDir.ManifestPutter manifestPutter;

    public void addInsertListener(InsertListener insertListener) {
        this.insertListeners.add(insertListener);
    }

    public void removeInsertListener(InsertListener insertListener) {
        this.insertListeners.remove(insertListener);
    }

    protected void fireProjectInsertStarted() {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectInsertStarted(this.project);
        }
    }

    protected void fireProjectURIGenerated(String uri) {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectURIGenerated(this.project, uri);
        }
    }

    protected void fireProjectUploadFinished() {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectUploadFinished(this.project);
        }
    }

    protected void fireProjectInsertProgress(int succeeded, int failed, int fatal, int total, boolean finalized) {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectInsertProgress(this.project, succeeded, failed, fatal, total, finalized);
        }
    }

    protected void fireProjectInsertFinished(boolean success, Throwable cause) {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectInsertFinished(this.project, success, cause);
        }
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setFreenetInterface(Freenet7Interface freenetInterface) {
        this.freenetInterface = freenetInterface;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public void setUseEarlyEncode(boolean useEarlyEncode) {
        this.useEarlyEncode = useEarlyEncode;
    }

    public void setPriority(PriorityClass priority) {
        this.priority = priority;
    }

    public void setManifestPutter(ClientPutDir.ManifestPutter manifestPutter) {
        this.manifestPutter = manifestPutter;
    }

    public void start(StreamCopier.ProgressListener progressListener) {
        this.cancelled = false;
        this.progressListener = progressListener;
        this.fileScanner = new FileScanner(this.project);
        this.fileScanner.addFileScannerListener(this);
        new Thread(this.fileScanner).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.cancelled = true;
        Object object = this.lockObject;
        synchronized (object) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    private InputStream createFileInputStream(String filename, FileOption fileOption, int edition, long[] length) throws IOException {
        File file = new File(this.project.getLocalPath(), filename);
        length[0] = file.length();
        return new FileInputStream(file);
    }

    private FileEntry createFileEntry(FileScanner.ScannedFile file, int edition) {
        FileEntry fileEntry = null;
        String filename = file.getFilename();
        FileOption fileOption = this.project.getFileOption(filename);
        if (fileOption.isInsert()) {
            fileOption.setCurrentHash(file.getHash());
            if (!this.project.isAlwaysForceInsert() && !fileOption.isForceInsert() && file.getHash().equals(fileOption.getLastInsertHash())) {
                logger.log(Level.FINE, String.format("Inserting redirect to edition %d for %s.", fileOption.getLastInsertEdition(), filename));
                return new RedirectFileEntry(fileOption.hasChangedName() ? fileOption.getChangedName() : filename, fileOption.getMimeType(), "SSK@" + this.project.getRequestURI() + "/" + this.project.getPath() + "-" + fileOption.getLastInsertEdition() + "/" + fileOption.getLastInsertFilename());
            }
            try {
                long[] fileLength = new long[1];
                InputStream fileEntryInputStream = this.createFileInputStream(filename, fileOption, edition, fileLength);
                fileEntry = new DirectFileEntry(fileOption.hasChangedName() ? fileOption.getChangedName() : filename, fileOption.getMimeType(), fileEntryInputStream, fileLength[0]);
            }
            catch (IOException ioe1) {}
        } else if (fileOption.isInsertRedirect()) {
            fileEntry = new RedirectFileEntry(fileOption.hasChangedName() ? fileOption.getChangedName() : filename, fileOption.getMimeType(), fileOption.getCustomKey());
        }
        return fileEntry;
    }

    public static CheckReport validateProject(Project project) {
        FileOption fileOption;
        Object indexFile;
        CheckReport checkReport = new CheckReport();
        if (project.getLocalPath() == null || project.getLocalPath().trim().length() == 0) {
            checkReport.addIssue("error.no-local-path", true, new String[0]);
        }
        if (project.getPath() == null || project.getPath().trim().length() == 0) {
            checkReport.addIssue("error.no-path", true, new String[0]);
        }
        if (project.getIndexFile() == null || project.getIndexFile().length() == 0) {
            checkReport.addIssue("warning.empty-index", false, new String[0]);
        } else {
            indexFile = new File(project.getLocalPath(), project.getIndexFile());
            if (!((File)indexFile).exists()) {
                checkReport.addIssue("error.index-missing", true, new String[0]);
            }
        }
        indexFile = project.getIndexFile();
        boolean hasIndexFile = indexFile != null && ((String)indexFile).length() > 0;
        List<String> allowedIndexContentTypes = Arrays.asList("text/html", "application/xhtml+xml");
        if (hasIndexFile && !allowedIndexContentTypes.contains(project.getFileOption((String)indexFile).getMimeType())) {
            checkReport.addIssue("warning.index-not-html", false, new String[0]);
        }
        Map<String, FileOption> fileOptions = project.getFileOptions();
        Set<Map.Entry<String, FileOption>> fileOptionEntries = fileOptions.entrySet();
        boolean insert = fileOptionEntries.isEmpty();
        for (Map.Entry<String, FileOption> fileOptionEntry : fileOptionEntries) {
            String fileName = fileOptionEntry.getKey();
            fileOption = fileOptionEntry.getValue();
            insert |= fileOption.isInsert() || fileOption.isInsertRedirect();
            if (fileName.equals(project.getIndexFile()) && !fileOption.isInsert() && !fileOption.isInsertRedirect()) {
                checkReport.addIssue("error.index-not-inserted", true, new String[0]);
            }
            if (fileOption.isInsert() || !fileOption.isInsertRedirect() || fileOption.getCustomKey().length() != 0 && !"CHK@".equals(fileOption.getCustomKey())) continue;
            checkReport.addIssue("error.no-custom-key", true, fileName);
        }
        if (!insert) {
            checkReport.addIssue("error.no-files-to-insert", true, new String[0]);
        }
        HashSet<String> fileNames = new HashSet<String>();
        for (Map.Entry<String, FileOption> fileOptionEntry : fileOptionEntries) {
            fileOption = fileOptionEntry.getValue();
            if (!fileOption.isInsert() && !fileOption.isInsertRedirect()) {
                logger.log(Level.FINEST, "Ignoring {0}.", fileOptionEntry.getKey());
                continue;
            }
            String fileName = fileOptionEntry.getKey();
            if (fileOption.hasChangedName()) {
                fileName = fileOption.getChangedName();
            }
            logger.log(Level.FINEST, "Adding \u201c{0}\u201d for {1}.", new Object[]{fileName, fileOptionEntry.getKey()});
            if (fileNames.add(fileName)) continue;
            checkReport.addIssue("error.duplicate-file", true, fileName);
        }
        long totalSize = 0L;
        FileScanner fileScanner = new FileScanner(project);
        final CountDownLatch completionLatch = new CountDownLatch(1);
        fileScanner.addFileScannerListener(new FileScannerListener(){

            @Override
            public void fileScannerFinished(FileScanner fileScanner) {
                completionLatch.countDown();
            }
        });
        new Thread(fileScanner).start();
        while (completionLatch.getCount() > 0L) {
            try {
                completionLatch.await();
            }
            catch (InterruptedException ie1) {}
        }
        for (FileScanner.ScannedFile scannedFile : fileScanner.getFiles()) {
            String fileName = scannedFile.getFilename();
            FileOption fileOption2 = project.getFileOption(fileName);
            if (fileOption2 != null && !fileOption2.isInsert()) continue;
            totalSize += new File(project.getLocalPath(), fileName).length();
        }
        if (totalSize > 0x200000L) {
            checkReport.addIssue("warning.site-larger-than-2-mib", false, new String[0]);
        }
        return checkReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.fireProjectInsertStarted();
        List<FileScanner.ScannedFile> files = this.fileScanner.getFiles();
        Object object = this.lockObject;
        synchronized (object) {
            this.connection = this.freenetInterface.getConnection("project-insert-" + random + counter++);
        }
        this.connection.setTempDirectory(this.tempDirectory);
        boolean connected = false;
        IOException cause = null;
        try {
            connected = this.connection.connect();
        }
        catch (IOException e1) {
            cause = e1;
        }
        if (!connected || this.cancelled) {
            this.fireProjectInsertFinished(false, this.cancelled ? new AbortedException() : cause);
            return;
        }
        Client client = new Client(this.connection);
        int edition = this.project.getEdition();
        String dirURI = "USK@" + this.project.getInsertURI() + "/" + this.project.getPath() + "/" + edition + "/";
        ClientPutComplexDir putDir = new ClientPutComplexDir("dir-" + counter++, dirURI, this.tempDirectory);
        if (this.project.getIndexFile() != null && this.project.getIndexFile().length() > 0) {
            putDir.setDefaultName(this.project.getIndexFile());
        }
        putDir.setVerbosity(Verbosity.ALL);
        putDir.setMaxRetries(-1);
        putDir.setEarlyEncode(this.useEarlyEncode);
        putDir.setPriorityClass(this.priority);
        putDir.setManifestPutter(this.manifestPutter);
        for (FileScanner.ScannedFile file : files) {
            FileEntry fileEntry = this.createFileEntry(file, edition);
            if (fileEntry == null) continue;
            try {
                putDir.addFileEntry(fileEntry);
            }
            catch (IOException ioe1) {
                this.fireProjectInsertFinished(false, ioe1);
                return;
            }
        }
        try {
            client.execute((Command)putDir, this.progressListener);
            this.fireProjectUploadFinished();
        }
        catch (IOException ioe1) {
            this.fireProjectInsertFinished(false, ioe1);
            return;
        }
        String finalURI = null;
        boolean success = false;
        boolean finished = false;
        boolean disconnected = false;
        while (!finished && !this.cancelled) {
            Message message = client.readMessage();
            finished = message == null || (disconnected = client.isDisconnected());
            logger.log(Level.FINE, "Received message: " + message);
            if (finished) continue;
            String messageName = message.getName();
            if ("URIGenerated".equals(messageName)) {
                finalURI = message.get("URI");
                this.fireProjectURIGenerated(finalURI);
            }
            if ("SimpleProgress".equals(messageName)) {
                int total = Integer.parseInt(message.get("Total"));
                int succeeded = Integer.parseInt(message.get("Succeeded"));
                int fatal = Integer.parseInt(message.get("FatallyFailed"));
                int failed = Integer.parseInt(message.get("Failed"));
                boolean finalized = Boolean.parseBoolean(message.get("FinalizedTotal"));
                this.fireProjectInsertProgress(succeeded, failed, fatal, total, finalized);
            }
            finished = (success |= "PutSuccessful".equals(messageName)) && finalURI != null || "PutFailed".equals(messageName) || messageName.endsWith("Error");
        }
        if (success) {
            String editionPart = finalURI.substring(finalURI.lastIndexOf(47) + 1);
            int newEdition = Integer.parseInt(editionPart);
            this.project.setEdition(newEdition);
            this.project.setLastInsertionTime(System.currentTimeMillis());
            this.project.onSuccessfulInsert();
        }
        this.fireProjectInsertFinished(success, this.cancelled ? new AbortedException() : (disconnected ? new IOException("Connection terminated") : null));
    }

    @Override
    public void fileScannerFinished(FileScanner fileScanner) {
        if (!fileScanner.isError()) {
            new Thread(this).start();
        } else {
            this.fireProjectInsertFinished(false, null);
        }
        fileScanner.removeFileScannerListener(this);
    }

    public static class Issue {
        private final String errorKey;
        private final boolean fatal;
        private String[] parameters;

        protected Issue(String errorKey, boolean fatal, String ... parameters) {
            this.errorKey = errorKey;
            this.fatal = fatal;
            this.parameters = parameters;
        }

        public String getErrorKey() {
            return this.errorKey;
        }

        public boolean isFatal() {
            return this.fatal;
        }

        public String[] getParameters() {
            return this.parameters;
        }
    }

    public static class CheckReport
    implements Iterable<Issue> {
        private final List<Issue> issues = new ArrayList<Issue>();

        public void addIssue(Issue issue) {
            this.issues.add(issue);
        }

        public void addIssue(String errorKey, boolean fatal, String ... parameters) {
            this.addIssue(new Issue(errorKey, fatal, parameters));
        }

        @Override
        public Iterator<Issue> iterator() {
            return this.issues.iterator();
        }

        public boolean isEmpty() {
            return this.issues.isEmpty();
        }

        public int size() {
            return this.issues.size();
        }
    }
}

