/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.gui;

import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import de.todesbaum.util.freenet.fcp2.wot.OwnIdentity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.pterodactylus.util.swing.ComboBoxModelList;

public class KeyDialog
extends JDialog {
    private final Freenet7Interface freenetInterface;
    private String publicKey;
    private String privateKey;
    private Action okAction;
    private Action cancelAction;
    private Action generateAction;
    private Action copyFromProjectAction;
    private Action copyFromIdentityAction;
    private JTextField privateKeyTextField;
    private JTextField publicKeyTextField;
    private JComboBox projectsComboBox;
    private JComboBox ownIdentitiesComboBox;
    private boolean cancelled;
    private final List<Project> projects = new ArrayList<Project>();
    private final List<OwnIdentity> ownIdentities = new ArrayList<OwnIdentity>();

    public KeyDialog(Freenet7Interface freenetInterface, JFrame parent) {
        super(parent, I18n.getMessage("jsite.key-dialog.title"), true);
        this.freenetInterface = freenetInterface;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                KeyDialog.this.actionCancel();
            }
        });
        this.initDialog();
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
        this.publicKeyTextField.setText(publicKey);
        this.pack();
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        this.privateKeyTextField.setText(privateKey);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjects(Collection<? extends Project> projects) {
        List<Project> list = this.projects;
        synchronized (list) {
            this.projects.clear();
            this.projects.addAll(projects);
        }
        this.projectsComboBox.setSelectedIndex(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwnIdentities(Collection<? extends OwnIdentity> ownIdentities) {
        List<OwnIdentity> list = this.ownIdentities;
        synchronized (list) {
            this.ownIdentities.clear();
            this.ownIdentities.addAll(ownIdentities);
            Collections.sort(this.ownIdentities, new Comparator<OwnIdentity>(){

                @Override
                public int compare(OwnIdentity leftOwnIdentity, OwnIdentity rightOwnIdentity) {
                    return leftOwnIdentity.getNickname().compareToIgnoreCase(rightOwnIdentity.getNickname());
                }
            });
        }
        int selectedIndex = -1;
        int index = 0;
        for (OwnIdentity ownIdentity : this.ownIdentities) {
            if (ownIdentity.getInsertUri().equals(this.privateKey) && ownIdentity.getRequestUri().equals(this.publicKey)) {
                selectedIndex = index;
            }
            ++index;
        }
        this.ownIdentitiesComboBox.setSelectedIndex(selectedIndex);
    }

    @Override
    public void pack() {
        super.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
    }

    private void createActions() {
        this.okAction = new AbstractAction(I18n.getMessage("jsite.general.ok")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyDialog.this.actionOk();
            }
        };
        this.okAction.putValue("ShortDescription", I18n.getMessage("jsite.key-dialog.button.ok.tooltip"));
        this.okAction.putValue("MnemonicKey", 10);
        this.cancelAction = new AbstractAction(I18n.getMessage("jsite.general.cancel")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyDialog.this.actionCancel();
            }
        };
        this.cancelAction.putValue("ShortDescription", I18n.getMessage("jsite.key-dialog.button.cancel.tooltip"));
        this.cancelAction.putValue("MnemonicKey", 27);
        this.copyFromProjectAction = new AbstractAction(I18n.getMessage("jsite.key-dialog.button.copy-from-project")){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                KeyDialog.this.actionCopyFromProject();
            }
        };
        this.copyFromProjectAction.putValue("ShortDescription", I18n.getMessage("jsite.key-dialog.button.copy-from-project.tooltip"));
        this.copyFromProjectAction.putValue("MnemonicKey", 80);
        this.copyFromProjectAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 128));
        this.copyFromIdentityAction = new AbstractAction(I18n.getMessage("jsite.key-dialog.button.copy-from-identity")){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                KeyDialog.this.actionCopyFromIdentity();
            }
        };
        this.copyFromIdentityAction.putValue("ShortDescription", I18n.getMessage("jsite.key-dialog.button.copy-from-identity.tooltip"));
        this.copyFromIdentityAction.putValue("MnemonicKey", 73);
        this.copyFromIdentityAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 128));
        this.generateAction = new AbstractAction(I18n.getMessage("jsite.key-dialog.button.generate")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyDialog.this.actionGenerate();
            }
        };
        this.generateAction.putValue("ShortDescription", I18n.getMessage("jsite.key-dialog.button.generate.tooltip"));
        this.generateAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 128));
    }

    private void initDialog() {
        this.createActions();
        JPanel dialogPanel = new JPanel(new BorderLayout(12, 12));
        dialogPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JPanel contentPanel = new JPanel(new GridBagLayout());
        dialogPanel.add((Component)contentPanel, "Center");
        final JLabel keysLabel = new JLabel(I18n.getMessage("jsite.key-dialog.label.keys"));
        contentPanel.add((Component)keysLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        final JLabel privateKeyLabel = new JLabel(I18n.getMessage("jsite.key-dialog.label.private-key"));
        contentPanel.add((Component)privateKeyLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(12, 18, 0, 0), 0, 0));
        this.privateKeyTextField = new JTextField();
        contentPanel.add((Component)this.privateKeyTextField, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(6, 12, 0, 0), 0, 0));
        final JLabel publicKeyLabel = new JLabel(I18n.getMessage("jsite.key-dialog.label.public-key"));
        contentPanel.add((Component)publicKeyLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.publicKeyTextField = new JTextField();
        contentPanel.add((Component)this.publicKeyTextField, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(6, 12, 0, 0), 0, 0));
        final JLabel copyKeysLabel = new JLabel(I18n.getMessage("jsite.key-dialog.label.copy-keys"));
        contentPanel.add((Component)copyKeysLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(12, 0, 0, 0), 0, 0));
        final JLabel projectLabel = new JLabel(I18n.getMessage("jsite.key-dialog.label.project"));
        contentPanel.add((Component)projectLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(12, 18, 0, 0), 0, 0));
        this.projectsComboBox = new JComboBox<Project>(new ComboBoxModelList<Project>(this.projects));
        this.projectsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyDialog.this.copyFromProjectAction.setEnabled(KeyDialog.this.projectsComboBox.getSelectedIndex() > -1);
            }
        });
        contentPanel.add((Component)this.projectsComboBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 12, 0, 0), 0, 0));
        JButton copyFromProjectButton = new JButton(this.copyFromProjectAction);
        contentPanel.add((Component)copyFromProjectButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 22, 2, new Insets(6, 12, 0, 0), 0, 0));
        final JLabel identityLabel = new JLabel(I18n.getMessage("jsite.key-dialog.label.identity"));
        contentPanel.add((Component)identityLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 21, 0, new Insets(12, 18, 0, 0), 0, 0));
        this.ownIdentitiesComboBox = new JComboBox<OwnIdentity>(new ComboBoxModelList<OwnIdentity>(this.ownIdentities));
        this.ownIdentitiesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                KeyDialog.this.copyFromIdentityAction.setEnabled(KeyDialog.this.ownIdentitiesComboBox.getSelectedIndex() > -1);
            }
        });
        this.ownIdentitiesComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == null) {
                    this.setText("");
                } else {
                    OwnIdentity ownIdentity = (OwnIdentity)value;
                    this.setText(String.format("%s (%s)", ownIdentity.getNickname(), ownIdentity.getRequestUri().substring(0, ownIdentity.getRequestUri().indexOf(44))));
                }
                return this;
            }
        });
        contentPanel.add((Component)this.ownIdentitiesComboBox, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 12, 0, 0), 0, 0));
        JButton copyFromIdentityButton = new JButton(this.copyFromIdentityAction);
        contentPanel.add((Component)copyFromIdentityButton, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 22, 2, new Insets(6, 12, 0, 0), 0, 0));
        final JLabel actionsLabel = new JLabel(I18n.getMessage("jsite.key-dialog.label.actions"));
        contentPanel.add((Component)actionsLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 21, 0, new Insets(12, 0, 0, 0), 0, 0));
        JPanel actionButtonPanel = new JPanel(new FlowLayout(3, 12, 12));
        actionButtonPanel.setBorder(BorderFactory.createEmptyBorder(-12, -12, -12, -12));
        contentPanel.add((Component)actionButtonPanel, new GridBagConstraints(0, 7, 3, 1, 1.0, 0.0, 21, 2, new Insets(12, 18, 0, 0), 0, 0));
        actionButtonPanel.add(new JButton(this.generateAction));
        JPanel separatorPanel = new JPanel(new BorderLayout(12, 12));
        dialogPanel.add((Component)separatorPanel, "Last");
        separatorPanel.add((Component)new JSeparator(0), "First");
        JPanel buttonPanel = new JPanel(new FlowLayout(4, 12, 12));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(-12, -12, -12, -12));
        separatorPanel.add((Component)buttonPanel, "Center");
        buttonPanel.add(new JButton(this.okAction));
        buttonPanel.add(new JButton(this.cancelAction));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                keysLabel.setText(I18n.getMessage("jsite.key-dialog.label.keys"));
                privateKeyLabel.setText(I18n.getMessage("jsite.key-dialog.label.private-key"));
                publicKeyLabel.setText(I18n.getMessage("jsite.key-dialog.label.public-key"));
                copyKeysLabel.setText(I18n.getMessage("jsite.key-dialog.label.copy-keys"));
                identityLabel.setText(I18n.getMessage("jsite.key-dialog.label.identity"));
                projectLabel.setText(I18n.getMessage("jsite.key-dialog.label.project"));
                actionsLabel.setText(I18n.getMessage("jsite.key-dialog.label.actions"));
            }
        });
        this.getContentPane().add((Component)dialogPanel, "Center");
        this.pack();
        this.setResizable(false);
    }

    private void actionOk() {
        this.publicKey = this.publicKeyTextField.getText();
        this.privateKey = this.privateKeyTextField.getText();
        this.cancelled = false;
        this.setVisible(false);
    }

    private void actionCancel() {
        this.cancelled = true;
        this.setVisible(false);
    }

    private void actionCopyFromProject() {
        Project project = (Project)this.projectsComboBox.getSelectedItem();
        if (project == null) {
            return;
        }
        this.setPublicKey(project.getRequestURI());
        this.setPrivateKey(project.getInsertURI());
    }

    private void actionCopyFromIdentity() {
        OwnIdentity ownIdentity = (OwnIdentity)this.ownIdentitiesComboBox.getSelectedItem();
        if (ownIdentity == null) {
            return;
        }
        this.setPublicKey(ownIdentity.getRequestUri());
        this.setPrivateKey(ownIdentity.getInsertUri());
    }

    private void actionGenerate() {
        if (JOptionPane.showConfirmDialog(this, I18n.getMessage("jsite.project.warning.generate-new-key"), null, 2) == 2) {
            return;
        }
        String[] keyPair = null;
        try {
            keyPair = this.freenetInterface.generateKeyPair();
        }
        catch (IOException ioe1) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(I18n.getMessage("jsite.project.keygen.io-error"), ioe1.getMessage()), null, 0);
            return;
        }
        this.publicKeyTextField.setText(keyPair[1].substring(keyPair[1].indexOf(64) + 1, keyPair[1].lastIndexOf(47)));
        this.privateKeyTextField.setText(keyPair[0].substring(keyPair[0].indexOf(64) + 1, keyPair[0].lastIndexOf(47)));
        this.pack();
    }
}

