/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.gui;

import de.todesbaum.jsite.application.Node;
import de.todesbaum.jsite.gui.NodeManagerListener;
import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import de.todesbaum.util.swing.TLabel;
import de.todesbaum.util.swing.TWizard;
import de.todesbaum.util.swing.TWizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class NodeManagerPage
extends TWizardPage
implements ListSelectionListener,
DocumentListener,
ChangeListener {
    private List<NodeManagerListener> nodeManagerListeners = new ArrayList<NodeManagerListener>();
    protected Action addNodeAction;
    protected Action deleteNodeAction;
    private DefaultListModel nodeListModel;
    private JList nodeList;
    private JTextField nodeNameTextField;
    private JTextField nodeHostnameTextField;
    private JSpinner nodePortSpinner;

    public NodeManagerPage(TWizard wizard) {
        super(wizard);
        this.pageInit();
        this.setHeading(I18n.getMessage("jsite.node-manager.heading"));
        this.setDescription(I18n.getMessage("jsite.node-manager.description"));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                NodeManagerPage.this.setHeading(I18n.getMessage("jsite.node-manager.heading"));
                NodeManagerPage.this.setDescription(I18n.getMessage("jsite.node-manager.description"));
            }
        });
    }

    public void addNodeManagerListener(NodeManagerListener nodeManagerListener) {
        this.nodeManagerListeners.add(nodeManagerListener);
    }

    public void removeNodeManagerListener(NodeManagerListener nodeManagerListener) {
        this.nodeManagerListeners.remove(nodeManagerListener);
    }

    protected void fireNodesUpdated(Node[] nodes) {
        for (NodeManagerListener nodeManagerListener : this.nodeManagerListeners) {
            nodeManagerListener.nodesUpdated(nodes);
        }
    }

    protected void fireNodeSelected(Node node) {
        for (NodeManagerListener nodeManagerListener : this.nodeManagerListeners) {
            nodeManagerListener.nodeSelected(node);
        }
    }

    private void createActions() {
        this.addNodeAction = new AbstractAction(I18n.getMessage("jsite.node-manager.add-node")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodeManagerPage.this.addNode();
            }
        };
        this.deleteNodeAction = new AbstractAction(I18n.getMessage("jsite.node-manager.delete-node")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NodeManagerPage.this.deleteNode();
            }
        };
        this.deleteNodeAction.setEnabled(false);
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                NodeManagerPage.this.addNodeAction.putValue("Name", I18n.getMessage("jsite.node-manager.add-node"));
                NodeManagerPage.this.deleteNodeAction.putValue("Name", I18n.getMessage("jsite.node-manager.delete-node"));
            }
        });
    }

    private void pageInit() {
        this.createActions();
        this.nodeListModel = new DefaultListModel();
        this.nodeList = new JList(this.nodeListModel);
        this.nodeList.setName("node-list");
        this.nodeList.setSelectionMode(0);
        this.nodeList.addListSelectionListener(this);
        this.nodeList.setPreferredSize(new Dimension(250, -1));
        this.nodeNameTextField = new JTextField("");
        this.nodeNameTextField.getDocument().putProperty("Name", "node-name");
        this.nodeNameTextField.getDocument().addDocumentListener(this);
        this.nodeNameTextField.setEnabled(false);
        this.nodeHostnameTextField = new JTextField("localhost");
        this.nodeHostnameTextField.getDocument().putProperty("Name", "node-hostname");
        this.nodeHostnameTextField.getDocument().addDocumentListener(this);
        this.nodeHostnameTextField.setEnabled(false);
        this.nodePortSpinner = new JSpinner(new SpinnerNumberModel(9481, 1, 65535, 1));
        this.nodePortSpinner.setName("node-port");
        this.nodePortSpinner.addChangeListener(this);
        this.nodePortSpinner.setEnabled(false);
        JPanel buttonPanel = new JPanel(new FlowLayout(3, 12, 12));
        buttonPanel.setBorder(new EmptyBorder(-12, -12, -12, -12));
        buttonPanel.add(new JButton(this.addNodeAction));
        buttonPanel.add(new JButton(this.deleteNodeAction));
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel nodeInformationPanel = new JPanel(new GridBagLayout());
        centerPanel.add((Component)nodeInformationPanel, "First");
        nodeInformationPanel.add((Component)buttonPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        final JLabel nodeInformationLabel = new JLabel("<html><b>" + I18n.getMessage("jsite.node-manager.node-information") + "</b></html>");
        nodeInformationPanel.add((Component)nodeInformationLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 21, 2, new Insets(6, 0, 0, 0), 0, 0));
        final TLabel nodeNameLabel = new TLabel(I18n.getMessage("jsite.node-manager.name") + ":", 78, (Component)this.nodeNameTextField);
        nodeInformationPanel.add((Component)nodeNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        nodeInformationPanel.add((Component)this.nodeNameTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        final TLabel nodeHostnameLabel = new TLabel(I18n.getMessage("jsite.node-manager.hostname") + ":", 72, (Component)this.nodeHostnameTextField);
        nodeInformationPanel.add((Component)nodeHostnameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        nodeInformationPanel.add((Component)this.nodeHostnameTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        final TLabel nodePortLabel = new TLabel(I18n.getMessage("jsite.node-manager.port") + ":", 80, (Component)this.nodePortSpinner);
        nodeInformationPanel.add((Component)nodePortLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        nodeInformationPanel.add((Component)this.nodePortSpinner, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 6, 0, 0), 0, 0));
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)new JScrollPane(this.nodeList), "Before");
        this.add((Component)centerPanel, "Center");
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                nodeInformationLabel.setText("<html><b>" + I18n.getMessage("jsite.node-manager.node-information") + "</b></html>");
                nodeNameLabel.setText(I18n.getMessage("jsite.node-manager.name") + ":");
                nodeHostnameLabel.setText(I18n.getMessage("jsite.node-manager.hostname") + ":");
                nodePortLabel.setText(I18n.getMessage("jsite.node-manager.port") + ":");
            }
        });
    }

    @Override
    public void pageAdded(TWizard wizard) {
        this.wizard.setNextEnabled(this.nodeListModel.getSize() > 0);
        this.wizard.setPreviousName(I18n.getMessage("jsite.wizard.previous"));
        this.wizard.setNextName(I18n.getMessage("jsite.wizard.next"));
        this.wizard.setQuitName(I18n.getMessage("jsite.wizard.quit"));
    }

    public void setNodes(Node[] nodes) {
        this.nodeListModel.clear();
        for (Node node : nodes) {
            this.nodeListModel.addElement(node);
        }
        this.nodeList.repaint();
        this.fireNodesUpdated(nodes);
    }

    public Node[] getNodes() {
        Node[] returnNodes = new Node[this.nodeListModel.getSize()];
        int nodeCount = this.nodeListModel.getSize();
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            returnNodes[nodeIndex] = (Node)this.nodeListModel.get(nodeIndex);
        }
        return returnNodes;
    }

    private Node getSelectedNode() {
        return (Node)this.nodeList.getSelectedValue();
    }

    private void updateTextField(DocumentEvent documentEvent) {
        Node node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        Document document = documentEvent.getDocument();
        String documentText = null;
        try {
            documentText = document.getText(0, document.getLength());
        }
        catch (BadLocationException ble1) {
            // empty catch block
        }
        if (documentText == null) {
            return;
        }
        String documentName = (String)document.getProperty("Name");
        if ("node-name".equals(documentName)) {
            node.setName(documentText);
            this.nodeList.repaint();
            this.fireNodesUpdated(this.getNodes());
        } else if ("node-hostname".equals(documentName)) {
            node.setHostname(documentText);
            this.nodeList.repaint();
            this.fireNodesUpdated(this.getNodes());
        }
    }

    private void addNode() {
        Node node = new Node("localhost", 9481, I18n.getMessage("jsite.node-manager.new-node"));
        this.nodeListModel.addElement(node);
        this.deleteNodeAction.setEnabled(this.nodeListModel.size() > 1);
        this.wizard.setNextEnabled(true);
        this.fireNodesUpdated(this.getNodes());
    }

    private void deleteNode() {
        Node node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        if (JOptionPane.showConfirmDialog(this.wizard, I18n.getMessage("jsite.node-manager.delete-node.warning"), null, 2, 2) == 2) {
            return;
        }
        int nodeIndex = this.nodeListModel.indexOf(node);
        this.nodeListModel.removeElement(node);
        this.nodeList.repaint();
        this.fireNodeSelected((Node)this.nodeListModel.get(Math.min(nodeIndex, this.nodeListModel.size() - 1)));
        this.fireNodesUpdated(this.getNodes());
        this.deleteNodeAction.setEnabled(this.nodeListModel.size() > 1);
        this.wizard.setNextEnabled(this.nodeListModel.size() > 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        JList sourceList;
        Object source = e.getSource();
        if (source instanceof JList && "node-list".equals((sourceList = (JList)source).getName())) {
            Node node = (Node)sourceList.getSelectedValue();
            boolean enabled = node != null;
            this.nodeNameTextField.setEnabled(enabled);
            this.nodeHostnameTextField.setEnabled(enabled);
            this.nodePortSpinner.setEnabled(enabled);
            this.deleteNodeAction.setEnabled(enabled && this.nodeListModel.size() > 1);
            if (enabled) {
                this.nodeNameTextField.setText(node.getName());
                this.nodeHostnameTextField.setText(node.getHostname());
                this.nodePortSpinner.setValue(node.getPort());
            } else {
                this.nodeNameTextField.setText("");
                this.nodeHostnameTextField.setText("localhost");
                this.nodePortSpinner.setValue(9481);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTextField(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTextField(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTextField(e);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSpinner sourceSpinner;
        Object source = e.getSource();
        Node selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        if (source instanceof JSpinner && "node-port".equals((sourceSpinner = (JSpinner)source).getName())) {
            selectedNode.setPort((Integer)sourceSpinner.getValue());
            this.fireNodeSelected(selectedNode);
            this.nodeList.repaint();
        }
    }
}

