/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.gui;

import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import de.todesbaum.jsite.main.ConfigurationLocator;
import de.todesbaum.util.freenet.fcp2.ClientPutDir;
import de.todesbaum.util.freenet.fcp2.PriorityClass;
import de.todesbaum.util.swing.TWizard;
import de.todesbaum.util.swing.TWizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PreferencesPage
extends TWizardPage {
    private Action selectDefaultTempDirectoryAction;
    private Action selectCustomTempDirectoryAction;
    private Action chooseTempDirectoryAction;
    private Action nextToJarFileAction;
    private Action homeDirectoryAction;
    private Action customDirectoryAction;
    private Action useEarlyEncodeAction;
    private Action priorityAction;
    private JTextField tempDirectoryTextField;
    private String tempDirectory;
    private ConfigurationLocator.ConfigurationLocation configurationLocation;
    private boolean useEarlyEncode;
    private PriorityClass priority;
    private JRadioButton defaultTempDirectory;
    private JRadioButton customTempDirectory;
    private JRadioButton nextToJarFile;
    private JRadioButton homeDirectory;
    private JRadioButton customDirectory;
    private JCheckBox useEarlyEncodeCheckBox;
    private JComboBox insertPriorityComboBox;
    private JComboBox manifestPutterComboBox;

    public PreferencesPage(TWizard wizard) {
        super(wizard);
        this.pageInit();
        this.setHeading(I18n.getMessage("jsite.preferences.heading"));
        this.setDescription(I18n.getMessage("jsite.preferences.description"));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                PreferencesPage.this.setHeading(I18n.getMessage("jsite.preferences.heading"));
                PreferencesPage.this.setDescription(I18n.getMessage("jsite.preferences.description"));
            }
        });
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
        this.tempDirectoryTextField.setText(tempDirectory != null ? tempDirectory : "");
        if (tempDirectory != null) {
            this.customTempDirectory.setSelected(true);
            this.chooseTempDirectoryAction.setEnabled(true);
        } else {
            this.defaultTempDirectory.setSelected(true);
        }
    }

    public ConfigurationLocator.ConfigurationLocation getConfigurationLocation() {
        return this.configurationLocation;
    }

    public void setConfigurationLocation(ConfigurationLocator.ConfigurationLocation configurationLocation) {
        this.configurationLocation = configurationLocation;
        switch (configurationLocation) {
            case NEXT_TO_JAR_FILE: {
                this.nextToJarFile.setSelected(true);
                break;
            }
            case HOME_DIRECTORY: {
                this.homeDirectory.setSelected(true);
                break;
            }
            case CUSTOM: {
                this.customDirectory.setSelected(true);
            }
        }
    }

    public void setHasNextToJarConfiguration(boolean nextToJarFile) {
        this.nextToJarFile.setEnabled(nextToJarFile);
    }

    public void setHasCustomConfiguration(boolean customDirectory) {
        this.customDirectory.setEnabled(customDirectory);
    }

    public boolean useEarlyEncode() {
        return this.useEarlyEncode;
    }

    public void setUseEarlyEncode(boolean useEarlyEncode) {
        this.useEarlyEncodeCheckBox.setSelected(useEarlyEncode);
    }

    public PriorityClass getPriority() {
        return this.priority;
    }

    public void setPriority(PriorityClass priority) {
        this.insertPriorityComboBox.setSelectedItem(priority);
    }

    public ClientPutDir.ManifestPutter getManifestPutter() {
        return (ClientPutDir.ManifestPutter)((Object)this.manifestPutterComboBox.getSelectedItem());
    }

    public void setManifestPutter(ClientPutDir.ManifestPutter manifestPutter) {
        this.manifestPutterComboBox.setSelectedItem((Object)manifestPutter);
    }

    @Override
    public void pageAdded(TWizard wizard) {
        super.pageAdded(wizard);
        this.wizard.setPreviousName(I18n.getMessage("jsite.menu.nodes.manage-nodes"));
        this.wizard.setNextName(I18n.getMessage("jsite.wizard.next"));
        this.wizard.setQuitName(I18n.getMessage("jsite.wizard.quit"));
        this.wizard.setNextEnabled(false);
    }

    private void pageInit() {
        this.createActions();
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)this.createPreferencesPanel(), "Center");
    }

    private void createActions() {
        this.selectDefaultTempDirectoryAction = new AbstractAction(I18n.getMessage("jsite.preferences.temp-directory.default")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPage.this.selectDefaultTempDirectory();
            }
        };
        this.selectCustomTempDirectoryAction = new AbstractAction(I18n.getMessage("jsite.preferences.temp-directory.custom")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPage.this.selectCustomTempDirectory();
            }
        };
        this.chooseTempDirectoryAction = new AbstractAction(I18n.getMessage("jsite.preferences.temp-directory.choose")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesPage.this.chooseTempDirectory();
            }
        };
        this.nextToJarFileAction = new AbstractAction(I18n.getMessage("jsite.preferences.config-directory.jar")){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                PreferencesPage.this.configurationLocation = ConfigurationLocator.ConfigurationLocation.NEXT_TO_JAR_FILE;
            }
        };
        this.homeDirectoryAction = new AbstractAction(I18n.getMessage("jsite.preferences.config-directory.home")){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                PreferencesPage.this.configurationLocation = ConfigurationLocator.ConfigurationLocation.HOME_DIRECTORY;
            }
        };
        this.customDirectoryAction = new AbstractAction(I18n.getMessage("jsite.preferences.config-directory.custom")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPage.this.configurationLocation = ConfigurationLocator.ConfigurationLocation.CUSTOM;
            }
        };
        this.useEarlyEncodeAction = new AbstractAction(I18n.getMessage("jsite.preferences.insert-options.use-early-encode")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPage.this.useEarlyEncode = PreferencesPage.this.useEarlyEncodeCheckBox.isSelected();
            }
        };
        this.priorityAction = new AbstractAction(I18n.getMessage("jsite.preferences.insert-options.priority")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPage.this.priority = (PriorityClass)PreferencesPage.this.insertPriorityComboBox.getSelectedItem();
            }
        };
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                PreferencesPage.this.selectDefaultTempDirectoryAction.putValue("Name", I18n.getMessage("jsite.preferences.temp-directory.default"));
                PreferencesPage.this.selectCustomTempDirectoryAction.putValue("Name", I18n.getMessage("jsite.preferences.temp-directory.custom"));
                PreferencesPage.this.chooseTempDirectoryAction.putValue("Name", I18n.getMessage("jsite.preferences.temp-directory.choose"));
                PreferencesPage.this.nextToJarFileAction.putValue("Name", I18n.getMessage("jsite.preferences.config-directory.jar"));
                PreferencesPage.this.homeDirectoryAction.putValue("Name", I18n.getMessage("jsite.preferences.config-directory.home"));
                PreferencesPage.this.customDirectoryAction.putValue("Name", I18n.getMessage("jsite.preferences.config-directory.custom"));
                PreferencesPage.this.useEarlyEncodeAction.putValue("Name", I18n.getMessage("jsite.preferences.insert-options.use-early-encode"));
            }
        });
    }

    private JPanel createPreferencesPanel() {
        JPanel preferencesPanel = new JPanel(new GridBagLayout());
        preferencesPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        final JLabel tempDirectoryLabel = new JLabel("<html><b>" + I18n.getMessage("jsite.preferences.temp-directory") + "</b></html>");
        preferencesPanel.add((Component)tempDirectoryLabel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.defaultTempDirectory = new JRadioButton(this.selectDefaultTempDirectoryAction);
        preferencesPanel.add((Component)this.defaultTempDirectory, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 21, 1, new Insets(6, 18, 0, 0), 0, 0));
        this.customTempDirectory = new JRadioButton(this.selectCustomTempDirectoryAction);
        preferencesPanel.add((Component)this.customTempDirectory, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 1, new Insets(0, 18, 0, 0), 0, 0));
        ButtonGroup tempDirectoryButtonGroup = new ButtonGroup();
        this.defaultTempDirectory.getModel().setGroup(tempDirectoryButtonGroup);
        this.customTempDirectory.getModel().setGroup(tempDirectoryButtonGroup);
        this.tempDirectoryTextField = new JTextField();
        this.tempDirectoryTextField.setEditable(false);
        if (this.tempDirectory != null) {
            this.tempDirectoryTextField.setText(this.tempDirectory);
            this.customTempDirectory.setSelected(true);
        } else {
            this.defaultTempDirectory.setSelected(true);
        }
        this.chooseTempDirectoryAction.setEnabled(this.tempDirectory != null);
        preferencesPanel.add((Component)this.tempDirectoryTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 1, new Insets(0, 6, 0, 0), 0, 0));
        JButton chooseButton = new JButton(this.chooseTempDirectoryAction);
        preferencesPanel.add((Component)chooseButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 22, 1, new Insets(0, 6, 0, 0), 0, 0));
        final JLabel configurationDirectoryLabel = new JLabel("<html><b>" + I18n.getMessage("jsite.preferences.config-directory") + "</b></html>");
        preferencesPanel.add((Component)configurationDirectoryLabel, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 21, 1, new Insets(12, 0, 0, 0), 0, 0));
        this.nextToJarFile = new JRadioButton(this.nextToJarFileAction);
        preferencesPanel.add((Component)this.nextToJarFile, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 21, 1, new Insets(6, 18, 0, 0), 0, 0));
        this.homeDirectory = new JRadioButton(this.homeDirectoryAction);
        preferencesPanel.add((Component)this.homeDirectory, new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 21, 1, new Insets(0, 18, 0, 0), 0, 0));
        this.customDirectory = new JRadioButton(this.customDirectoryAction);
        preferencesPanel.add((Component)this.customDirectory, new GridBagConstraints(0, 6, 3, 1, 1.0, 0.0, 21, 1, new Insets(0, 18, 0, 0), 0, 0));
        ButtonGroup configurationDirectoryButtonGroup = new ButtonGroup();
        configurationDirectoryButtonGroup.add(this.nextToJarFile);
        configurationDirectoryButtonGroup.add(this.homeDirectory);
        configurationDirectoryButtonGroup.add(this.customDirectory);
        final JLabel insertOptionsLabel = new JLabel("<html><b>" + I18n.getMessage("jsite.preferences.insert-options") + "</b></html>");
        preferencesPanel.add((Component)insertOptionsLabel, new GridBagConstraints(0, 7, 3, 1, 1.0, 0.0, 21, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.useEarlyEncodeCheckBox = new JCheckBox(this.useEarlyEncodeAction);
        preferencesPanel.add((Component)this.useEarlyEncodeCheckBox, new GridBagConstraints(0, 8, 3, 1, 1.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        final JLabel insertPriorityLabel = new JLabel(I18n.getMessage("jsite.preferences.insert-options.priority"));
        preferencesPanel.add((Component)insertPriorityLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.insertPriorityComboBox = new JComboBox<PriorityClass>(new PriorityClass[]{PriorityClass.MINIMUM, PriorityClass.PREFETCH, PriorityClass.BULK, PriorityClass.UPDATABLE, PriorityClass.SEMI_INTERACTIVE, PriorityClass.INTERACTIVE, PriorityClass.MAXIMUM});
        this.insertPriorityComboBox.setAction(this.priorityAction);
        preferencesPanel.add((Component)this.insertPriorityComboBox, new GridBagConstraints(1, 9, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 18, 0, 0), 0, 0));
        final JLabel manifestPutterLabel = new JLabel(I18n.getMessage("jsite.preferences.insert-options.manifest-putter"));
        preferencesPanel.add((Component)manifestPutterLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.manifestPutterComboBox = new JComboBox<ClientPutDir.ManifestPutter>(ClientPutDir.ManifestPutter.values());
        preferencesPanel.add((Component)this.manifestPutterComboBox, new GridBagConstraints(1, 10, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 18, 0, 0), 0, 0));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                tempDirectoryLabel.setText("<html><b>" + I18n.getMessage("jsite.preferences.temp-directory") + "</b></html>");
                configurationDirectoryLabel.setText("<html><b>" + I18n.getMessage("jsite.preferences.config-directory") + "</b></html>");
                insertOptionsLabel.setText("<html><b>" + I18n.getMessage("jsite.preferences.insert-options") + "</b></html>");
                insertPriorityLabel.setText(I18n.getMessage("jsite.preferences.insert-options.priority"));
                manifestPutterLabel.setText(I18n.getMessage("jsite.preferences.insert-options.manifest-putter"));
            }
        });
        return preferencesPanel;
    }

    private void selectDefaultTempDirectory() {
        this.tempDirectoryTextField.setEnabled(false);
        this.chooseTempDirectoryAction.setEnabled(false);
        this.tempDirectory = null;
    }

    private void selectCustomTempDirectory() {
        this.tempDirectoryTextField.setEnabled(true);
        this.chooseTempDirectoryAction.setEnabled(true);
        if (this.tempDirectoryTextField.getText().length() == 0) {
            this.chooseTempDirectory();
            if (this.tempDirectoryTextField.getText().length() == 0) {
                this.defaultTempDirectory.setSelected(true);
            }
        }
    }

    private void chooseTempDirectory() {
        JFileChooser fileChooser = new JFileChooser(this.tempDirectory);
        fileChooser.setFileSelectionMode(1);
        int returnValue = fileChooser.showDialog(this.wizard, I18n.getMessage("jsite.preferences.temp-directory.choose.approve"));
        if (returnValue == 1) {
            return;
        }
        this.tempDirectory = fileChooser.getSelectedFile().getPath();
        this.tempDirectoryTextField.setText(this.tempDirectory);
    }
}

