/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.main;

import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.InsertListener;
import de.todesbaum.jsite.application.Node;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.application.ProjectInserter;
import de.todesbaum.jsite.main.Configuration;
import de.todesbaum.jsite.main.ConfigurationLocator;
import java.io.PrintWriter;
import java.util.List;
import net.pterodactylus.util.io.StreamCopier;

public class CLI
implements InsertListener {
    private Object lockObject = new Object();
    private PrintWriter outputWriter = new PrintWriter(System.out, true);
    private Freenet7Interface freenetInterface;
    private ProjectInserter projectInserter = new ProjectInserter();
    private Node[] nodes;
    private List<Project> projects;
    private boolean finished = false;
    private boolean success;

    private CLI(String[] args) {
        if (args.length == 0 || args[0].equals("-h") || args[0].equals("--help")) {
            this.outputWriter.println("\nParameters:\n");
            this.outputWriter.println("  --config-file=<configuration file>");
            this.outputWriter.println("  --node=<node name>");
            this.outputWriter.println("  --project=<project name>");
            this.outputWriter.println("  --local-directory=<local directory>");
            this.outputWriter.println("  --path=<path>");
            this.outputWriter.println("  --edition=<edition>");
            this.outputWriter.println("\nA project gets inserted when a new project is loaded on the command line,");
            this.outputWriter.println("or when the command line is finished. --local-directory, --path, and --edition");
            this.outputWriter.println("override the parameters in the project.");
            return;
        }
        String configFile = System.getProperty("user.home") + "/.jSite/config7";
        for (String argument : args) {
            String value = argument.substring(argument.indexOf(61) + 1).trim();
            if (!argument.startsWith("--config-file=")) continue;
            configFile = value;
        }
        ConfigurationLocator configurationLocator = new ConfigurationLocator();
        if (configFile != null) {
            configurationLocator.setCustomLocation(configFile);
        }
        Configuration configuration = new Configuration(configurationLocator, configurationLocator.findPreferredLocation());
        this.projectInserter.addInsertListener(this);
        this.projects = configuration.getProjects();
        Node node = configuration.getSelectedNode();
        this.nodes = configuration.getNodes();
        this.freenetInterface = new Freenet7Interface();
        this.freenetInterface.setNode(node);
        this.projectInserter.setFreenetInterface(this.freenetInterface);
        Project currentProject = null;
        for (String argument : args) {
            if (argument.startsWith("--config-file=")) continue;
            String value = argument.substring(argument.indexOf(61) + 1).trim();
            if (argument.startsWith("--node=")) {
                Node newNode = this.getNode(value);
                if (newNode == null) {
                    this.outputWriter.println("Node \"" + value + "\" not found.");
                    return;
                }
                node = newNode;
                this.freenetInterface.setNode(node);
                continue;
            }
            if (argument.startsWith("--project=")) {
                if (currentProject != null) {
                    if (this.insertProject(currentProject)) {
                        this.outputWriter.println("Project \"" + currentProject.getName() + "\" successfully inserted.");
                    } else {
                        this.outputWriter.println("Project \"" + currentProject.getName() + "\" was not successfully inserted.");
                    }
                    currentProject = null;
                }
                if ((currentProject = this.getProject(value)) != null) continue;
                this.outputWriter.println("Project \"" + value + "\" not found.");
                continue;
            }
            if (argument.startsWith("--local-directory")) {
                if (currentProject == null) {
                    this.outputWriter.println("You can't specifiy --local-directory before --project.");
                    return;
                }
                currentProject.setLocalPath(value);
                continue;
            }
            if (argument.startsWith("--path=")) {
                if (currentProject == null) {
                    this.outputWriter.println("You can't specify --path before --project.");
                    return;
                }
                currentProject.setPath(value);
                continue;
            }
            if (argument.startsWith("--edition=")) {
                if (currentProject == null) {
                    this.outputWriter.println("You can't specify --edition before --project.");
                    return;
                }
                currentProject.setEdition(Integer.parseInt(value));
                continue;
            }
            this.outputWriter.println("Unknown parameter: " + argument);
            return;
        }
        int errorCode = 1;
        if (currentProject != null) {
            if (this.insertProject(currentProject)) {
                this.outputWriter.println("Project \"" + currentProject.getName() + "\" successfully inserted.");
                errorCode = 0;
            } else {
                this.outputWriter.println("Project \"" + currentProject.getName() + "\" was not successfully inserted.");
            }
        }
        configuration.setProjects(this.projects);
        configuration.save();
        System.exit(errorCode);
    }

    private Project getProject(String name) {
        for (Project project : this.projects) {
            if (!project.getName().equals(name)) continue;
            return project;
        }
        return null;
    }

    private Node getNode(String name) {
        for (Node node : this.nodes) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertProject(Project currentProject) {
        if (!this.freenetInterface.hasNode()) {
            this.outputWriter.println("Node is not running!");
            return false;
        }
        this.projectInserter.setProject(currentProject);
        this.projectInserter.start(new StreamCopier.ProgressListener(){

            @Override
            public void onProgress(long copied, long length) {
                System.out.print("Uploaded: " + copied + " / " + length + " bytes...\r");
            }
        });
        Object object = this.lockObject;
        synchronized (object) {
            while (!this.finished) {
                try {
                    this.lockObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.success;
    }

    @Override
    public void projectInsertStarted(Project project) {
        this.outputWriter.println("Starting Insert of project \"" + project.getName() + "\".");
    }

    @Override
    public void projectUploadFinished(Project project) {
        this.outputWriter.println("Project \"" + project.getName() + "\" has been uploaded, starting insert...");
    }

    @Override
    public void projectURIGenerated(Project project, String uri) {
        this.outputWriter.println("URI: " + uri);
    }

    @Override
    public void projectInsertProgress(Project project, int succeeded, int failed, int fatal, int total, boolean finalized) {
        this.outputWriter.println("Progress: " + succeeded + " done, " + failed + " failed, " + fatal + " fatal, " + total + " total" + (finalized ? " (finalized)" : "") + ", " + (succeeded + failed + fatal) * 100 / total + "%");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void projectInsertFinished(Project project, boolean success, Throwable cause) {
        this.outputWriter.println("Request URI: " + project.getFinalRequestURI(0));
        this.finished = true;
        this.success = success;
        Object object = this.lockObject;
        synchronized (object) {
            this.lockObject.notify();
        }
    }

    public static void main(String[] args) {
        new CLI(args);
    }
}

